/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom.input;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.Group;
import org.zkoss.idom.Item;
import org.zkoss.idom.Namespace;
import org.zkoss.idom.input.DefaultIDOMFactory;
import org.zkoss.idom.input.IDOMFactory;
import org.zkoss.idom.util.SimpleLocator;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;

public class SAXHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler {
    private static final Log log = Log.lookup(SAXHandler.class);
    protected IDOMFactory _factory;
    private boolean _ignoreWhitespaces = false;
    private boolean _expandEntities = true;
    private boolean _coalescing = false;
    private boolean _ignoreComments = false;
    private ErrorHandler _errHandler = null;
    private EntityResolver _resolver = null;
    protected Document _doc = null;
    protected org.xml.sax.Locator _loc = null;
    protected boolean _inDTD = false;
    protected boolean _inCData = false;
    protected Stack<Group> _stack = null;
    protected List<Namespace> _declNamespaces = null;
    private StringBuffer _internSubset = null;
    private boolean _inInternSubset = false;

    public SAXHandler(IDOMFactory factory) {
        this._factory = factory != null ? factory : new DefaultIDOMFactory();
    }

    public SAXHandler() {
        this._factory = new DefaultIDOMFactory();
    }

    public final boolean isIgnoringElementContentWhitespace() {
        return this._ignoreWhitespaces;
    }

    public final void setIgnoringElementContentWhitespace(boolean ignore) {
        this._ignoreWhitespaces = ignore;
    }

    public final boolean isExpandEntityReferences() {
        return this._expandEntities;
    }

    public final void setExpandEntityReferences(boolean expand) {
        this._expandEntities = expand;
    }

    public final boolean isCoalescing() {
        return this._coalescing;
    }

    public final void setCoalescing(boolean coalescing) {
        this._coalescing = coalescing;
    }

    public final boolean isIgnoringComments() {
        return this._ignoreComments;
    }

    public final void setIgnoringComments(boolean ignoreComments) {
        this._ignoreComments = ignoreComments;
    }

    public final void setErrorHandler(ErrorHandler eh) {
        this._errHandler = eh;
    }

    public final ErrorHandler getErrorHandler() {
        return this._errHandler;
    }

    public final void setEntityResolver(EntityResolver er) {
        this._resolver = er;
    }

    public final EntityResolver getEntityResolver() {
        return this._resolver;
    }

    public final Document getDocument() {
        return this._doc;
    }

    public final IDOMFactory getIDOMFactory() {
        return this._factory;
    }

    public final void setIDOMFactory(IDOMFactory factory) {
        this._factory = factory;
    }

    protected final void attachLocator(Item vtx) {
        if (this._loc != null) {
            vtx.setLocator(new SimpleLocator(this._loc));
        }
    }

    protected final Group getTopGroup() {
        return this._stack.isEmpty() ? null : this._stack.peek();
    }

    protected final void addToCurrentGroup(Item vtx) {
        this.attachLocator(vtx);
        this._stack.peek().getChildren().add(vtx);
    }

    protected final void pushGroup(Group group) {
        if (this._stack.isEmpty()) {
            assert (group instanceof Document);
        } else {
            this.addToCurrentGroup(group);
        }
        this._stack.push(group);
    }

    protected final void popGroup() {
        this._stack.pop().coalesce(false);
    }

    public void externalEntityDecl(String name, String pubId, String sysId) throws SAXException {
        if (log.finerable()) {
            log.finer("externalEntityDecl: " + name + " p:" + pubId + " s:" + sysId);
        }
        if (!this._inInternSubset) {
            return;
        }
        this._internSubset.append("  <!ENTITY ").append(name);
        if (pubId != null) {
            this._internSubset.append(" PUBLIC \"").append(pubId).append("\" ");
        }
        if (sysId != null) {
            this._internSubset.append(" SYSTEM \"").append(sysId).append("\" ");
        }
        this._internSubset.append(">\n");
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (log.finerable()) {
            log.finer("internalEntityDecl: " + name + '=' + value);
        }
        if (!this._inInternSubset) {
            return;
        }
        this._internSubset.append("  <!ENTITY ").append(name).append(" \"").append(value).append("\">\n");
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        if (!this._inInternSubset) {
            return;
        }
        this._internSubset.append("  <!ATTLIST ").append(eName).append(' ').append(aName).append(' ').append(type).append(' ');
        if (valueDefault != null) {
            this._internSubset.append(valueDefault);
        } else {
            this._internSubset.append('\"').append(value).append('\"');
        }
        if (valueDefault != null && valueDefault.equals("#FIXED")) {
            this._internSubset.append(" \"").append(value).append('\"');
        }
        this._internSubset.append(">\n");
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (!this._inInternSubset) {
            return;
        }
        this._internSubset.append("  <!ELEMENT ").append(name).append(' ').append(model).append(">\n");
    }

    public void startDTD(String name, String pubId, String sysId) throws SAXException {
        if (log.finerable()) {
            log.finer("start DTD: " + name + " p:" + pubId + " s:" + sysId);
        }
        this.addToCurrentGroup(this._factory.newDocType(name, pubId, sysId));
        this._inDTD = true;
        this._internSubset = new StringBuffer();
        this._inInternSubset = true;
    }

    public void endDTD() throws SAXException {
        if (log.finerable()) {
            log.finer("end DTD: \"" + this._internSubset + '\"');
        }
        this._doc.getDocType().setInternalSubset(this._internSubset.toString());
        this._inDTD = false;
        this._internSubset = null;
        this._inInternSubset = false;
    }

    public void startEntity(String name) throws SAXException {
        if (log.finerable()) {
            log.finer("startEntity: " + name);
        }
        if (name.equals("[dtd]")) {
            this._inInternSubset = false;
            return;
        }
        if (!(this.isExpandEntityReferences() || this._inDTD || this.entityToSkip(name))) {
            this.pushGroup(this._factory.newEntityRef(name));
        }
    }

    private boolean entityToSkip(String name) {
        switch (name.charAt(0)) {
            case 'a': {
                return name.equals("amp") || name.equals("apos");
            }
            case 'g': {
                return name.equals("gt");
            }
            case 'l': {
                return name.equals("lt");
            }
            case 'q': {
                return name.equals("quot");
            }
        }
        return false;
    }

    public void endEntity(String name) throws SAXException {
        if (log.finerable()) {
            log.finer("endEntity: " + name);
        }
        if (name.equals("[dtd]")) {
            this._inInternSubset = false;
            return;
        }
        if (!(this.isExpandEntityReferences() || this._inDTD || this.entityToSkip(name))) {
            this.popGroup();
        }
    }

    public void startCDATA() throws SAXException {
        this._inCData = true;
    }

    public void endCDATA() throws SAXException {
        this._inCData = false;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (length == 0 || this.isIgnoringComments()) {
            return;
        }
        String data = new String(ch, start, length);
        if (this._inDTD && this._inInternSubset && !this.isExpandEntityReferences()) {
            this._internSubset.append("  <!--").append(data).append("-->\n");
        }
        if (!this._inDTD && data.length() != 0) {
            this.addToCurrentGroup(this._factory.newComment(data));
        }
    }

    public void startDocument() throws SAXException {
        this._declNamespaces = new LinkedList<Namespace>();
        this._stack = new Stack();
        this._doc = this._factory.newDocument(null, null);
        this.pushGroup(this._doc);
    }

    public void endDocument() throws SAXException {
        this.popGroup();
        assert (this._stack.isEmpty());
        this._stack = null;
        this._loc = null;
        this._declNamespaces = null;
    }

    public void setDocumentLocator(org.xml.sax.Locator locator) {
        this._loc = locator;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.addToCurrentGroup(this._factory.newProcessingInstruction(target, data));
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        Namespace ns;
        if (log.finerable()) {
            log.finer("start prefix: " + prefix + ", " + uri + SimpleLocator.toString(this._loc));
        }
        if ((ns = Namespace.getSpecial(prefix)) == null || !ns.getURI().equals(uri)) {
            this._declNamespaces.add(0, new Namespace(prefix, uri));
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (log.finerable()) {
            log.finer("end prefix: " + prefix + SimpleLocator.toString(this._loc));
        }
        Iterator<Namespace> itr = this._declNamespaces.iterator();
        while (itr.hasNext()) {
            Namespace ns = itr.next();
            if (!prefix.equals(ns.getPrefix())) continue;
            itr.remove();
            break;
        }
    }

    public void startElement(String nsURI, String lname, String tname, Attributes attrs) throws SAXException {
        if (log.finerable()) {
            log.finer("start element: nsURI=\"" + nsURI + "\", lname=" + lname + ", tname=" + tname + " attr#=" + attrs.getLength() + SimpleLocator.toString(this._loc));
        }
        if (tname == null || tname.length() == 0) {
            tname = lname;
        }
        Element element = this.newElement(nsURI, tname);
        int len = attrs.getLength();
        for (int j = 0; j < len; ++j) {
            Attribute attr;
            int kp;
            String attQname = attrs.getQName(j);
            String attLname = attrs.getLocalName(j);
            if (attQname == null || attQname.length() == 0) {
                attQname = attLname;
            }
            if ((kp = attQname.indexOf(58)) >= 0) {
                String prefix = attQname.substring(0, kp);
                Namespace ns = element.getNamespace(prefix);
                if (ns == null) {
                    throw new SAXException("Unknown prefix: " + prefix + " at " + this._loc + "\nDo you forget to turn on namespace-aware");
                }
                attr = this._factory.newAttribute(ns, attQname.substring(kp + 1), attrs.getValue(j));
            } else {
                attr = this._factory.newAttribute(attLname == null || attLname.length() == 0 ? attQname : attLname, attrs.getValue(j));
            }
            this.attachLocator(attr);
            element.getAttributeItems().add(attr);
        }
    }

    private Element newElement(String nsURI, String tname) throws SAXException {
        Element element;
        Namespace ns;
        int j;
        if (nsURI == null) {
            nsURI = "";
        }
        String prefix = (j = tname.indexOf(58)) >= 0 ? tname.substring(0, j) : "";
        String lname = j >= 0 ? tname.substring(j + 1) : tname;
        Group parent = this.getTopGroup();
        if (parent instanceof Element) {
            ns = ((Element)parent).getNamespace(prefix);
            if (ns != null && !ns.getURI().equals(nsURI)) {
                ns = null;
            }
        } else {
            ns = Namespace.getSpecial(prefix);
        }
        if (ns == null) {
            if (this._declNamespaces.size() > 0) {
                for (Namespace n : this._declNamespaces) {
                    if (!n.getPrefix().equals(prefix) || !n.getURI().equals(nsURI)) continue;
                    if (log.finerable()) {
                        log.finer("Namespace found in _declNamespaces: " + n);
                    }
                    ns = n;
                    break;
                }
            }
            if (ns == null && nsURI.length() > 0) {
                if (log.finerable()) {
                    log.finer("Create namespace: " + prefix + " " + nsURI);
                }
                ns = new Namespace(prefix, nsURI);
            }
        }
        Element element2 = element = ns != null ? this._factory.newElement(ns, lname) : this._factory.newElement(lname);
        if (this._declNamespaces.size() > 0) {
            for (Namespace n : this._declNamespaces) {
                element.addDeclaredNamespace(n);
            }
            this._declNamespaces.clear();
        }
        this.pushGroup(element);
        return element;
    }

    public void endElement(String nsURI, String lname, String tname) throws SAXException {
        if (log.finerable()) {
            log.finer("end element: " + nsURI + ", " + lname + ", " + tname);
        }
        this.popGroup();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        String data = new String(ch, start, length);
        if (this.getTopGroup() instanceof Document) {
            if (data.trim().length() > 0) {
                throw new SAXException("Adding non-empty text to Document: " + data);
            }
            return;
        }
        if (this._inCData && !this.isCoalescing()) {
            this.addToCurrentGroup(this._factory.newCData(data));
        } else {
            this.addToCurrentGroup(this._factory.newText(data));
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (length == 0 || this.isIgnoringElementContentWhitespace()) {
            return;
        }
        this.addToCurrentGroup(this._factory.newText(new String(ch, start, length)));
    }

    public void notationDecl(String name, String publicID, String systemID) throws SAXException {
        if (!this._inInternSubset) {
            return;
        }
        this._internSubset.append("  <!NOTATION ").append(name).append(" \"").append(systemID).append("\">\n");
    }

    public void unparsedEntityDecl(String name, String pubId, String sysId, String notationName) throws SAXException {
        if (log.finerable()) {
            log.finer("externalEntityDecl: " + name + " p:" + pubId + " s:" + sysId + " n:" + notationName);
        }
        if (!this._inInternSubset) {
            return;
        }
        this._internSubset.append("  <!ENTITY ").append(name);
        if (pubId != null) {
            this._internSubset.append(" PUBLIC \"").append(pubId).append("\" ");
        }
        if (sysId != null) {
            this._internSubset.append(" SYSTEM \"").append(sysId).append("\" ");
        }
        this._internSubset.append(" NDATA ").append(notationName).append(">\n");
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        EntityResolver er;
        if (log.finerable()) {
            log.finer("resolveEntity public=" + publicId + " system=" + systemId);
        }
        if ((er = this.getEntityResolver()) != null) {
            try {
                return er.resolveEntity(publicId, systemId);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
        InputSource is = this.defaultResolveEntity(publicId, systemId);
        if (is == null && log.finerable()) {
            log.finer("Unable to resolve public=" + publicId + " system=" + systemId);
        }
        return is;
    }

    protected InputSource defaultResolveEntity(String publicId, String systemId) throws SAXException {
        String resId;
        block11: {
            if (systemId == null) {
                return null;
            }
            if (systemId.indexOf("file:/") >= 0) {
                try {
                    InputSource is = new InputSource(new URL(systemId).openStream());
                    is.setSystemId(systemId);
                    if (log.finerable()) {
                        log.finer("Entity found " + systemId);
                    }
                    return is;
                }
                catch (Exception ex) {
                    if (!log.finerable()) break block11;
                    log.finer("Unable to open " + systemId);
                }
            }
        }
        String PREFIX = "/metainfo/xml";
        Locator loader = Locators.getDefault();
        URL url = null;
        int j = systemId.indexOf("://");
        if (j > 0) {
            resId = "/metainfo/xml" + systemId.substring(j + 2);
            url = loader.getResource(resId);
        }
        if (url == null) {
            j = systemId.lastIndexOf(47);
            resId = j >= 0 ? "/metainfo/xml" + systemId.substring(j) : "/metainfo/xml/" + systemId;
            url = loader.getResource(resId);
        }
        if (url != null) {
            if (log.finerable()) {
                log.finer("Entity resovled to " + url);
            }
            try {
                InputSource is = new InputSource(url.openStream());
                is.setSystemId(url.toExternalForm());
                return is;
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }
        return null;
    }

    public void warning(SAXParseException ex) throws SAXException {
        ErrorHandler eh = this.getErrorHandler();
        if (eh != null) {
            eh.warning(ex);
        } else {
            log.warning(ex.getMessage() + SimpleLocator.toString(this._loc));
        }
    }

    public void error(SAXParseException ex) throws SAXException {
        ErrorHandler eh = this.getErrorHandler();
        if (eh == null) {
            log.error(ex.getMessage() + SimpleLocator.toString(this._loc));
            throw ex;
        }
        eh.error(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        ErrorHandler eh = this.getErrorHandler();
        if (eh == null) {
            if (log.debugable()) {
                log.debug(ex.getMessage() + SimpleLocator.toString(this._loc));
            }
            throw ex;
        }
        eh.fatalError(ex);
    }
}

