/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Generics;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadInfoService
implements AuService {
    private UploadInfoService() {
    }

    private static Media[] parseResult(List<Media> result) {
        if (result != null) {
            Iterator<Media> it = result.iterator();
            while (it.hasNext()) {
                byte[] bs;
                String nm;
                Media media = it.next();
                if (media == null || !media.inMemory() || !media.isBinary() || (nm = media.getName()) != null && nm.length() != 0 || (bs = media.getByteData()) != null && bs.length != 0) continue;
                it.remove();
            }
            if (!result.isEmpty()) {
                return result.toArray(new Media[result.size()]);
            }
        }
        return null;
    }

    @Override
    public boolean service(AuRequest request, boolean everError) {
        if ("updateResult".equals(request.getCommand())) {
            Map<String, Object> data = request.getData();
            Desktop desktop = request.getDesktop();
            String uuid = (String)request.getData().get("wid");
            String sid = (String)request.getData().get("sid");
            List result = Generics.cast((List)((List)AuRequests.getUpdateResult(request)));
            Events.postEvent(new UploadEvent("onUpload", desktop.getComponentByUuid(uuid), UploadInfoService.parseResult(result)));
            Map precent = (Map)desktop.getAttribute("org.zkoss.zk.upload.percent");
            Map size = (Map)desktop.getAttribute("org.zkoss.zk.upload.size");
            String key = uuid + '_' + sid;
            precent.remove(key);
            size.remove(key);
            return true;
        }
        return false;
    }

    public static class DesktopInit
    implements org.zkoss.zk.ui.util.DesktopInit {
        public void init(Desktop desktop, Object request) {
            desktop.addListener(new UploadInfoService());
        }
    }
}

