/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.impl.EventQueueProvider;
import org.zkoss.zk.ui.event.impl.EventQueueProviderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventQueues {
    public static final String DESKTOP = "desktop";
    public static final String GROUP = "group";
    public static final String APPLICATION = "application";
    public static final String SESSION = "session";
    private static EventQueueProvider _provider;

    public static <T extends Event> EventQueue<T> lookup(String name, String scope, boolean autoCreate) {
        return EventQueues.getProvider().lookup(name, scope, autoCreate);
    }

    public static <T extends Event> EventQueue<T> lookup(String name, Session sess, boolean autoCreate) {
        return EventQueues.getProvider().lookup(name, sess, autoCreate);
    }

    public static <T extends Event> EventQueue<T> lookup(String name, WebApp wapp, boolean autoCreate) {
        return EventQueues.getProvider().lookup(name, wapp, autoCreate);
    }

    public static <T extends Event> EventQueue<T> lookup(String name, boolean autoCreate) {
        return EventQueues.lookup(name, DESKTOP, autoCreate);
    }

    public static <T extends Event> EventQueue<T> lookup(String name) {
        return EventQueues.lookup(name, DESKTOP, true);
    }

    public static boolean exists(String name, String scope) {
        return EventQueues.lookup(name, scope, false) != null;
    }

    public static boolean exists(String name) {
        return EventQueues.lookup(name, false) != null;
    }

    public static boolean remove(String name) {
        return EventQueues.remove(name, DESKTOP);
    }

    public static boolean remove(String name, String scope) {
        return EventQueues.getProvider().remove(name, scope);
    }

    public static boolean remove(String name, Session sess) {
        return EventQueues.getProvider().remove(name, sess);
    }

    public static boolean remove(String name, WebApp wapp) {
        return EventQueues.getProvider().remove(name, wapp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final EventQueueProvider getProvider() {
        if (_provider != null) return _provider;
        Class<EventQueues> clazz = EventQueues.class;
        synchronized (EventQueues.class) {
            if (_provider != null) return _provider;
            EventQueueProvider provider = null;
            String clsnm = Library.getProperty((String)"org.zkoss.zk.ui.event.EventQueueProvider.class");
            if (clsnm == null) {
                clsnm = Library.getProperty((String)"org.zkoss.zkmax.ui.EventQueueProvider.class");
            }
            if (clsnm != null) {
                try {
                    Object o = Classes.newInstanceByThread((String)clsnm);
                    if (!(o instanceof EventQueueProvider)) {
                        throw new UiException(o.getClass().getName() + " must implement " + EventQueueProvider.class.getName());
                    }
                    provider = (EventQueueProvider)o;
                }
                catch (UiException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex, "Unable to load " + clsnm);
                }
            }
            if (provider == null) {
                provider = new EventQueueProviderImpl();
            }
            _provider = provider;
            // ** MonitorExit[var0] (shouldn't be in output)
            return _provider;
        }
    }
}

