/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.impl.AsyncListenerThread;
import org.zkoss.zk.ui.event.impl.ListenerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopEventQueue<T extends Event>
implements EventQueue<T>,
Serializable {
    static final Log log = Log.lookup(DesktopEventQueue.class);
    private static final String ON_QUEUE = "onQueue";
    private final Component _dummyTarget = new AbstractComponent();
    private final List<ListenerInfo<T>> _listenerInfos = new LinkedList<ListenerInfo<T>>();
    private int _nAsync;
    private boolean _serverPushEnabled;
    private boolean _closed;

    public DesktopEventQueue() {
        this._dummyTarget.addEventListener(ON_QUEUE, new QueueListener());
    }

    public boolean isIdle() {
        return this._listenerInfos.isEmpty();
    }

    @Override
    public void publish(T event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (Executions.getCurrent() == null) {
            DesktopEventQueue.currentThread().postEvent(event);
        } else {
            Events.postEvent(ON_QUEUE, this._dummyTarget, event);
        }
    }

    private static final <W extends Event> AsyncListenerThread<W> currentThread() {
        Thread thd = Thread.currentThread();
        if (!(thd instanceof AsyncListenerThread)) {
            throw new IllegalStateException("publish() can be called only in an event listener");
        }
        return (AsyncListenerThread)thd;
    }

    @Override
    public void subscribe(EventListener<T> listener) {
        this.subscribe(listener, null, false);
    }

    @Override
    public void subscribe(EventListener<T> listener, EventListener<T> callback) {
        this.subscribe(listener, callback, true);
    }

    @Override
    public void subscribe(EventListener<T> listener, boolean async) {
        this.subscribe(listener, null, async);
    }

    private void subscribe(EventListener<T> listener, EventListener<T> callback, boolean async) {
        if (async && this._nAsync++ == 0) {
            Execution exec = Executions.getCurrent();
            if (exec == null) {
                throw new IllegalStateException("Execution required");
            }
            this._serverPushEnabled = !exec.getDesktop().enableServerPush(true);
        }
        this._listenerInfos.add(new ListenerInfo<T>(listener, callback, async));
    }

    @Override
    public boolean unsubscribe(EventListener<T> listener) {
        if (listener != null) {
            Iterator<ListenerInfo<T>> it = this._listenerInfos.iterator();
            while (it.hasNext()) {
                ListenerInfo<T> inf = it.next();
                if (!listener.equals(inf.listener)) continue;
                it.remove();
                if (inf.async && --this._nAsync == 0 && this._serverPushEnabled) {
                    Executions.getCurrent().getDesktop().enableServerPush(false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSubscribed(EventListener<T> listener) {
        if (listener != null) {
            for (ListenerInfo<T> li : this._listenerInfos) {
                if (!listener.equals(li.listener)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() {
        this._closed = true;
        this._listenerInfos.clear();
        if (this._serverPushEnabled) {
            try {
                Executions.getCurrent().getDesktop().enableServerPush(false);
            }
            catch (Throwable ex) {
                log.warningBriefly("Ingored: unable to stop server push", ex);
            }
        }
    }

    @Override
    public boolean isClose() {
        return this._closed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueListener
    implements EventListener<Event>,
    Serializable {
        private QueueListener() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            Event evt = (Event)event.getData();
            Iterator it = CollectionsX.comodifiableIterator((Collection)DesktopEventQueue.this._listenerInfos);
            while (it.hasNext()) {
                ListenerInfo inf = (ListenerInfo)it.next();
                if (inf.async) {
                    new AsyncListenerThread<Event>(DesktopEventQueue.this, inf, evt).start();
                    continue;
                }
                inf.listener.onEvent(evt);
            }
        }
    }
}

