/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.impl.DesktopEventQueue;
import org.zkoss.zk.ui.util.DesktopCleanup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPushEventQueue<T extends Event>
implements EventQueue<T>,
Serializable {
    private static final Log log = Log.lookup(ServerPushEventQueue.class);
    private final Map<Desktop, DesktopInfo> _dtInfos = new HashMap<Desktop, DesktopInfo>();
    private boolean _closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(T event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        Map<Desktop, DesktopInfo> map = this._dtInfos;
        synchronized (map) {
            for (DesktopInfo di : this._dtInfos.values()) {
                di.publish(event);
            }
        }
    }

    @Override
    public void subscribe(EventListener<T> listener) {
        this.subscribe(listener, null, false);
    }

    @Override
    public void subscribe(EventListener<T> listener, EventListener<T> callback) {
        this.subscribe(listener, callback, true);
    }

    @Override
    public void subscribe(EventListener<T> listener, boolean async) {
        this.subscribe(listener, null, async);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribe(EventListener<T> listener, EventListener<T> callback, boolean async) {
        DesktopInfo di;
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("execution required");
        }
        Desktop desktop = exec.getDesktop();
        Map<Desktop, DesktopInfo> map = this._dtInfos;
        synchronized (map) {
            di = this._dtInfos.get(desktop);
            if (di == null) {
                di = new DesktopInfo(desktop, new EQService(), new EQCleanup());
                this._dtInfos.put(desktop, di);
            }
        }
        di.subscribe(listener, callback, async);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubscribed(EventListener<T> listener) {
        DesktopInfo di;
        if (listener == null) {
            return false;
        }
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("execution required");
        }
        Desktop desktop = exec.getDesktop();
        Map<Desktop, DesktopInfo> map = this._dtInfos;
        synchronized (map) {
            di = this._dtInfos.get(desktop);
        }
        return di != null && di.isSubscribed(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unsubscribe(EventListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("execution required");
        }
        Desktop desktop = exec.getDesktop();
        Map<Desktop, DesktopInfo> map = this._dtInfos;
        synchronized (map) {
            DesktopInfo di = this._dtInfos.get(desktop);
            if (di != null && di.unsubscribe(listener)) {
                if (di.isIdle()) {
                    this._dtInfos.remove(desktop);
                    di.close();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() {
        this._closed = true;
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            this.close(exec.getDesktop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Desktop desktop) {
        DesktopInfo di;
        Map<Desktop, DesktopInfo> map = this._dtInfos;
        synchronized (map) {
            di = this._dtInfos.remove(desktop);
        }
        if (di != null) {
            di.close();
        }
    }

    @Override
    public boolean isClose() {
        return this._closed;
    }

    private class EQCleanup
    implements DesktopCleanup,
    Serializable {
        private EQCleanup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup(Desktop desktop) throws Exception {
            DesktopInfo di;
            Map map = ServerPushEventQueue.this._dtInfos;
            synchronized (map) {
                di = (DesktopInfo)ServerPushEventQueue.this._dtInfos.remove(desktop);
            }
            if (di != null) {
                di.close();
            }
        }
    }

    private class EQService
    implements AuService,
    Serializable {
        private EQService() {
        }

        public boolean service(AuRequest request, boolean everError) {
            if (ServerPushEventQueue.this._closed) {
                ServerPushEventQueue.this.close(request.getDesktop());
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScheduleListener<T extends Event>
    implements EventListener<T>,
    Serializable {
        private final DesktopEventQueue<T> _que;

        private ScheduleListener(DesktopEventQueue<T> queue) {
            this._que = queue;
        }

        @Override
        public void onEvent(T event) {
            if (!this._que.isClose()) {
                this._que.publish(event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DesktopInfo
    implements Serializable {
        private final Desktop _desktop;
        private final DesktopEventQueue<T> _que;
        private final EQService _service;
        private final EQCleanup _cleanup;
        private boolean _spEnabled;

        private DesktopInfo(Desktop desktop, EQService service, EQCleanup cleanup) {
            this._desktop = desktop;
            this._que = new DesktopEventQueue();
            boolean bl = this._spEnabled = !desktop.isServerPushEnabled();
            if (this._spEnabled) {
                desktop.enableServerPush(true);
            }
            this._service = service;
            desktop.addListener(this._service);
            this._cleanup = cleanup;
            desktop.addListener(this._cleanup);
        }

        private void publish(T event) {
            Executions.schedule(this._desktop, new ScheduleListener(this._que), event);
        }

        private void subscribe(EventListener<T> listener, EventListener<T> callback, boolean async) {
            if (callback != null) {
                this._que.subscribe(listener, callback);
            } else {
                this._que.subscribe(listener, async);
            }
        }

        private boolean isSubscribed(EventListener<T> listener) {
            return this._que.isSubscribed(listener);
        }

        private boolean unsubscribe(EventListener<T> listener) {
            return this._que.unsubscribe(listener);
        }

        private boolean isIdle() {
            return this._que.isIdle();
        }

        private void close() {
            Execution exec;
            this._que.close();
            this._desktop.removeListener(this._cleanup);
            this._desktop.removeListener(this._service);
            if (this._spEnabled && (exec = Executions.getCurrent()) != null && exec.getDesktop() == this._desktop) {
                this._spEnabled = false;
                if (this._desktop.isAlive()) {
                    try {
                        this._desktop.enableServerPush(false);
                    }
                    catch (Throwable ex) {
                        log.warningBriefly("Ingored: unable to stop server push", ex);
                    }
                }
            }
        }
    }
}

