/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.metainfo.LeafInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.EvaluatorRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BranchInfo
extends LeafInfo
implements Condition {
    private List<NodeInfo> _children = new LinkedList<NodeInfo>();
    private ConditionImpl _cond;

    BranchInfo() {
    }

    BranchInfo(NodeInfo parent, ConditionImpl cond) {
        super(parent);
        this._cond = cond;
    }

    BranchInfo(BranchInfo from) {
        this._children = from._children;
        this._cond = from._cond;
    }

    public ConditionImpl getCondition() {
        return this._cond;
    }

    public void setCondition(ConditionImpl cond) {
        this._cond = cond;
    }

    public boolean withCondition() {
        return this._cond != null;
    }

    @Override
    public void appendChild(NodeInfo child) {
        NodeInfo oldp = child.getParent();
        if (oldp != null) {
            oldp.removeChild(child);
        }
        this._children.add(child);
        ((LeafInfo)child).setParentDirectly(this);
        BranchInfo.fixEvaluatorRefDown(child, this._evalr);
    }

    static final void fixEvaluatorRefDown(NodeInfo child, EvaluatorRef evalr) {
        List<NodeInfo> children;
        if (child instanceof LeafInfo) {
            ((LeafInfo)child)._evalr = evalr;
        }
        if ((children = child.getChildren()) != null) {
            for (NodeInfo c : children) {
                BranchInfo.fixEvaluatorRefDown(c, evalr);
            }
        }
    }

    @Override
    public boolean removeChild(NodeInfo child) {
        if (child != null && this._children.remove(child)) {
            ((LeafInfo)child).setParentDirectly(null);
            BranchInfo.fixEvaluatorRefDown(child, null);
            return true;
        }
        return false;
    }

    @Override
    public List<NodeInfo> getChildren() {
        return this._children;
    }

    @Override
    public boolean isEffective(Component comp) {
        return this._cond == null || this._cond.isEffective((Evaluator)this._evalr, comp);
    }

    @Override
    public boolean isEffective(Page page) {
        return this._cond == null || this._cond.isEffective((Evaluator)this._evalr, page);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Iterator<NodeInfo> it = this._children.iterator();
        while (it.hasNext()) {
            ((LeafInfo)it.next()).setParentDirectly(this);
        }
    }
}

