/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.html.JavaScript;
import org.zkoss.html.StyleSheet;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.ProcessingInstruction;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.XMLResourcesLocator;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.Macro;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.WidgetDefinition;
import org.zkoss.zk.ui.metainfo.impl.AnnotationHelper;
import org.zkoss.zk.ui.metainfo.impl.ComponentDefinitionImpl;
import org.zkoss.zk.ui.metainfo.impl.WidgetDefinitionImpl;
import org.zkoss.zk.ui.sys.ConfigParser;
import org.zkoss.zk.ui.sys.PageRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionLoaders {
    private static final Log log = Log.lookup(DefinitionLoaders.class);
    private static List<Object[]> _addons;
    private static List<Object[]> _langs;
    private static Map<String, String> _exts;
    private static boolean _loaded;
    private static boolean _loading;

    public static void addAddon(Locator locator, URL url) {
        if (locator == null || url == null) {
            throw new IllegalArgumentException("null");
        }
        if (_loaded) {
            DefinitionLoaders.loadLang(locator, url, true);
        } else {
            if (_addons == null) {
                _addons = new LinkedList<Object[]>();
            }
            _addons.add(new Object[]{locator, url});
        }
    }

    public static void addLanguage(Locator locator, URL url) {
        if (locator == null || url == null) {
            throw new IllegalArgumentException("null");
        }
        if (_loaded) {
            DefinitionLoaders.loadLang(locator, url, false);
        } else {
            if (_langs == null) {
                _langs = new LinkedList<Object[]>();
            }
            _langs.add(new Object[]{locator, url});
        }
    }

    public static final void addExtension(String ext, String lang) {
        if (_loaded) {
            LanguageDefinition.addExtension(ext, lang);
        } else {
            if (lang == null || ext == null) {
                throw new IllegalArgumentException("null");
            }
            if (_exts == null) {
                _exts = new HashMap<String, String>();
            }
            _exts.put(ext, lang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void load() throws IOException {
        if (_loaded) return;
        Class<DefinitionLoaders> clazz = DefinitionLoaders.class;
        synchronized (DefinitionLoaders.class) {
            if (_loaded || _loading) return;
            try {
                _loading = true;
                DefinitionLoaders.load0();
                Object var2_1 = null;
                _loaded = true;
                _loading = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                _loaded = true;
                _loading = false;
                throw throwable;
            }
            return;
        }
    }

    private static void load0() throws IOException {
        XMLResourcesLocator locator = Utils.getXMLResourcesLocator();
        ConfigParser parser = new ConfigParser();
        parser.parseConfigXml(null);
        Enumeration en = locator.getResources("metainfo/zk/lang.xml");
        while (en.hasMoreElements()) {
            URL url = (URL)en.nextElement();
            if (log.debugable()) {
                log.debug("Loading " + url);
            }
            try {
                Document document = new SAXBuilder(true, false, true).build(url);
                if (!ConfigParser.checkVersion(url, document, true)) continue;
                DefinitionLoaders.parseLang(document, (Locator)locator, url, false);
            }
            catch (Exception exception) {
                log.error("Failed to load " + url, (Throwable)exception);
                throw UiException.Aide.wrap((Throwable)exception, "Failed to load " + url);
            }
        }
        if (_langs != null) {
            for (Object[] p : _langs) {
                DefinitionLoaders.loadLang((Locator)p[0], (URL)p[1], false);
            }
            _langs = null;
        }
        List xmls = locator.getDependentXMLResources("metainfo/zk/lang-addon.xml", "addon-name", "depends");
        for (XMLResourcesLocator.Resource resource : xmls) {
            try {
                if (!ConfigParser.checkVersion(resource.url, resource.document, true)) continue;
                DefinitionLoaders.parseLang(resource.document, (Locator)locator, resource.url, true);
            }
            catch (Exception ex) {
                log.realCauseBriefly("Failed to load " + resource.url, (Throwable)ex);
            }
        }
        if (_addons != null) {
            for (Object[] objectArray : _addons) {
                DefinitionLoaders.loadLang((Locator)objectArray[0], (URL)objectArray[1], true);
            }
            _addons = null;
        }
        if (_exts != null) {
            for (Map.Entry entry : _exts.entrySet()) {
                String ext = (String)entry.getKey();
                String lang = (String)entry.getValue();
                try {
                    LanguageDefinition.addExtension(ext, lang);
                }
                catch (DefinitionNotFoundException ex) {
                    log.warning("Extension " + ext + " ignored since language " + lang + " not found");
                }
            }
            _exts = null;
        }
    }

    private static void loadLang(Locator locator, URL url, boolean addon) {
        try {
            DefinitionLoaders.parseLang(new SAXBuilder(true, false, true).build(url), locator, url, addon);
        }
        catch (Exception ex) {
            log.error("Failed to load " + (addon ? "addon" : "language") + ": " + url, (Throwable)ex);
        }
    }

    private static void parseLang(Document doc, Locator locator, URL url, boolean addon) throws Exception {
        String val;
        String nm;
        Device device;
        LanguageDefinition langdef;
        Element root = doc.getRootElement();
        String lang = IDOMs.getRequiredElementValue((Element)root, (String)"language-name");
        if (addon) {
            if (log.debugable()) {
                log.debug("Addon language to " + lang + " from " + root.getElementValue("addon-name", true));
            }
            langdef = LanguageDefinition.lookup(lang);
            device = Devices.getDevice(langdef.getDeviceType());
            if (root.getElement("case-insensitive") != null) {
                throw new UiException("case-insensitive not allowed in addon");
            }
        } else {
            String ns = IDOMs.getRequiredElementValue((Element)root, (String)"namespace");
            String deviceType = IDOMs.getRequiredElementValue((Element)root, (String)"device-type");
            PageRenderer pageRenderer = (PageRenderer)DefinitionLoaders.locateClass(IDOMs.getRequiredElementValue((Element)root, (String)"renderer-class"), PageRenderer.class).newInstance();
            List<String> exts = DefinitionLoaders.parseExtensions(root);
            if (exts.isEmpty()) {
                throw new UiException("The extension must be specified for " + lang);
            }
            String ignoreCase = root.getElementValue("case-insensitive", true);
            String bNative = root.getElementValue("native-namespace", true);
            langdef = new LanguageDefinition(deviceType, lang, ns, exts, pageRenderer, "true".equals(ignoreCase), "true".equals(bNative), locator);
            device = Devices.getDevice(deviceType);
        }
        DefinitionLoaders.parsePI(langdef, doc);
        DefinitionLoaders.parseLabelTemplate(langdef, root);
        DefinitionLoaders.parseDynamicTag(langdef, root);
        DefinitionLoaders.parseMacroTemplate(langdef, root);
        DefinitionLoaders.parseNativeTemplate(langdef, root);
        for (Element el : root.getElements("library-property")) {
            nm = IDOMs.getRequiredElementValue((Element)el, (String)"name");
            val = IDOMs.getRequiredElementValue((Element)el, (String)"value");
            Library.setProperty((String)nm, (String)val);
        }
        for (Element el : root.getElements("system-property")) {
            nm = IDOMs.getRequiredElementValue((Element)el, (String)"name");
            val = IDOMs.getRequiredElementValue((Element)el, (String)"value");
            System.setProperty(nm, val);
        }
        for (Element el : root.getElements("javascript")) {
            JavaScript js;
            boolean merge;
            String src = el.getAttributeValue("src");
            String pkg = el.getAttributeValue("package");
            String mergeTo = el.getAttributeValue("merge");
            boolean bl = merge = mergeTo != null && !"false".equals(mergeTo);
            if (merge && "true".equals(mergeTo)) {
                mergeTo = "zk";
            }
            boolean ondemand = "true".equals(el.getAttributeValue("ondemand"));
            if (pkg != null) {
                if (src != null) {
                    log.warning("The src attribute ignored because package is specified, " + el.getLocator());
                }
                if (!ondemand && !merge) {
                    src = "~." + device.packageToPath(pkg);
                    pkg = null;
                }
            }
            String ctn = el.getText(true);
            if (pkg != null && pkg.length() > 0) {
                if (ondemand) {
                    langdef.removeJavaScript("~." + device.packageToPath(pkg));
                    langdef.unmergeJavaScriptPackage(pkg, mergeTo);
                    continue;
                }
                langdef.mergeJavaScriptPackage(pkg, mergeTo);
                continue;
            }
            if (src != null && src.length() > 0) {
                if (ctn != null && ctn.length() > 0) {
                    throw new UiException("You cannot specify the content if the src attribute is specified, " + el.getLocator());
                }
                String charset = el.getAttributeValue("charset");
                js = new JavaScript(src, charset);
            } else if (ctn != null && ctn.length() > 0) {
                js = new JavaScript(ctn);
            } else {
                log.warning("Ignored: none of the src or package attribute, or the content specified, " + el.getLocator());
                continue;
            }
            langdef.addJavaScript(js);
        }
        for (Element el : root.getElements("javascript-module")) {
            langdef.addJavaScriptModule(IDOMs.getRequiredAttributeValue((Element)el, (String)"name"), IDOMs.getRequiredAttributeValue((Element)el, (String)"version"));
        }
        for (Element el : root.getElements("stylesheet")) {
            StyleSheet ss;
            String href = el.getAttributeValue("href");
            String ctn = el.getText(true);
            if (href != null && href.length() > 0) {
                if (ctn != null && ctn.length() > 0) {
                    throw new UiException("You cannot specify the content if the href attribute is specified, " + el.getLocator());
                }
                ss = new StyleSheet(href, el.getAttributeValue("type"), el.getAttributeValue("media"), false);
            } else if (ctn != null && ctn.length() > 0) {
                ss = new StyleSheet(ctn, el.getAttributeValue("type"), el.getAttributeValue("media"), true);
            } else {
                throw new UiException("You must specify either the href attribute or the content, " + el.getLocator());
            }
            langdef.addStyleSheet(ss);
        }
        for (Element el : root.getElements("zscript")) {
            String zslang;
            Attribute attr = el.getAttributeItem("language");
            if (attr == null) {
                zslang = "Java";
            } else {
                zslang = attr.getValue();
                if (zslang == null || zslang.length() == 0) {
                    throw new UiException("The language attribute cannot be empty, " + attr.getLocator());
                }
            }
            String s = el.getText(true);
            String eachTime = el.getAttributeValue("each-time");
            if ("true".equals(eachTime)) {
                langdef.addEachTimeScript(zslang, s);
                continue;
            }
            langdef.addInitScript(zslang, s);
        }
        for (Element el : root.getElements("component")) {
            ComponentDefinitionImpl compdef;
            String name = IDOMs.getRequiredElementValue((Element)el, (String)"component-name");
            String clsnm = el.getElementValue("component-class", true);
            Class cls = null;
            if (clsnm != null) {
                if (clsnm.length() > 0) {
                    DefinitionLoaders.noEL("component-class", clsnm, el);
                    try {
                        cls = DefinitionLoaders.locateClass(clsnm, Component.class);
                    }
                    catch (Throwable ex) {
                        log.warning("Component " + name + " ignored. Reason: unable to load " + clsnm + " due to " + ex.getClass().getName() + ": " + ex.getMessage() + (ex instanceof NoClassDefFoundError ? "" : "\n" + el.getLocator()));
                        log.debug(ex);
                    }
                } else {
                    clsnm = null;
                }
            }
            String macroURI = el.getElementValue("macro-uri", true);
            boolean extend = false;
            if (macroURI != null && macroURI.length() != 0) {
                if (log.finerable()) {
                    log.finer("macro component definition: " + name);
                }
                String inline = el.getElementValue("inline", true);
                compdef = (ComponentDefinitionImpl)langdef.getMacroDefinition(name, macroURI, "true".equals(inline), null);
                if (cls != null) {
                    compdef.setImplementationClass(cls);
                } else if (clsnm != null) {
                    compdef.setImplementationClass(clsnm);
                }
                compdef.setDeclarationURL(url);
                langdef.addComponentDefinition(compdef);
            } else if (el.getElement("extends") != null) {
                ComponentDefinition ref;
                extend = true;
                String extnm = el.getElementValue("extends", true);
                if (log.finerable()) {
                    log.finer("Extends component definition, " + name + ", from " + extnm);
                }
                if ((ref = langdef.getComponentDefinitionIfAny(extnm)) == null) {
                    log.warning("Component " + name + " ignored. Reason: extends a non-existent component " + extnm + ".\n" + el.getLocator());
                    continue;
                }
                if (ref.isMacro()) {
                    throw new UiException("Unable to extend from a macro component, " + el.getLocator());
                }
                if (extnm.equals(name)) {
                    compdef = (ComponentDefinitionImpl)ref;
                } else {
                    compdef = (ComponentDefinitionImpl)ref.clone(ref.getLanguageDefinition(), name);
                    compdef.setDeclarationURL(url);
                }
                if (cls != null) {
                    compdef.setImplementationClass(cls);
                } else if (clsnm != null) {
                    compdef.setImplementationClass(clsnm);
                }
                langdef.addComponentDefinition(compdef);
            } else {
                if (log.finerable()) {
                    log.finer("Add component definition: name=" + name);
                }
                if (cls == null && clsnm == null) {
                    throw new UiException("component-class is required, " + el.getLocator());
                }
                compdef = cls != null ? new ComponentDefinitionImpl(langdef, null, name, cls) : new ComponentDefinitionImpl(langdef, null, name, clsnm);
                compdef.setDeclarationURL(url);
                langdef.addComponentDefinition(compdef);
            }
            String s = el.getElementValue("text-as", true);
            if (s != null) {
                DefinitionLoaders.noEL("text-as", s, el);
                compdef.setTextAs(s);
            }
            if ((s = el.getElementValue("preserve-blank", true)) != null && !"false".equals(s)) {
                compdef.setBlankPreserved(true);
            }
            String wgtnm = el.getElementValue("widget-class", true);
            WidgetDefinition wgtdef = null;
            if (wgtnm == null && extend) {
                wgtnm = compdef.getDefaultWidgetClass(null);
            }
            if (wgtnm != null) {
                if (!DefinitionLoaders.withEL(wgtnm)) {
                    wgtdef = DefinitionLoaders.getWidgetDefinition(langdef, compdef, wgtnm);
                }
                compdef.setDefaultWidgetClass(wgtnm);
            }
            if ((s = el.getElementValue("component-apply", true)) == null) {
                s = el.getElementValue("apply", true);
            }
            compdef.setApply(s);
            for (Element e : el.getElements("mold")) {
                WidgetDefinition wd;
                String nm2 = IDOMs.getRequiredElementValue((Element)e, (String)"mold-name");
                String moldURI = e.getElementValue("mold-uri", true);
                String cssURI = e.getElementValue("css-uri", true);
                String wn = e.getElementValue("widget-class", true);
                DefinitionLoaders.noEL("mold-uri", moldURI, e);
                DefinitionLoaders.noEL("css-uri", cssURI, e);
                compdef.addMold(nm2, wn != null ? wn : wgtnm);
                WidgetDefinition widgetDefinition = wn == null ? wgtdef : (wd = DefinitionLoaders.withEL(wn) ? null : DefinitionLoaders.getWidgetDefinition(langdef, compdef, wn));
                if (moldURI != null) {
                    if (wd != null) {
                        wd.addMold(nm2, moldURI);
                    } else {
                        log.error("Mold " + nm2 + " for " + name + " ignored because " + (wn != null && DefinitionLoaders.withEL(wn) || wgtnm != null && DefinitionLoaders.withEL(wgtnm) ? "widget-class contains EL expressions" : "widget-class is required") + ", " + e.getLocator());
                    }
                }
                if (cssURI == null || cssURI.length() <= 0) continue;
                char cc = cssURI.charAt(0);
                if (cc != '/' && cc != '~') {
                    String n;
                    String string = n = wn != null ? wn : wgtnm;
                    if (!DefinitionLoaders.withEL(n)) {
                        int k = n.lastIndexOf(46);
                        cssURI = "~." + device.toAbsolutePath(n.substring(0, k).replace('.', '/') + '/' + cssURI);
                    } else {
                        log.error("Absolute path required for cssURI, since the widget class contains EL expressions, " + e.getLocator());
                    }
                }
                langdef.addCSSURI(cssURI);
            }
            for (Map.Entry<String, String> me : DefinitionLoaders.parseCustAttrs(el).entrySet()) {
                compdef.addCustomAttribute(me.getKey(), me.getValue());
            }
            for (Map.Entry<String, String> me : DefinitionLoaders.parseProps(el).entrySet()) {
                compdef.addProperty(me.getKey(), me.getValue());
            }
            DefinitionLoaders.parseAnnots(compdef, el);
        }
    }

    private static WidgetDefinition getWidgetDefinition(LanguageDefinition langdef, ComponentDefinition compdef, String wgtnm) {
        WidgetDefinition wgtdef = langdef.getWidgetDefinitionIfAny(wgtnm);
        if (wgtdef != null) {
            return wgtdef;
        }
        wgtdef = new WidgetDefinitionImpl(wgtnm, compdef.isBlankPreserved());
        langdef.addWidgetDefinition(wgtdef);
        return wgtdef;
    }

    private static <T> Class<? extends T> locateClass(String clsnm, Class<?> ... clses) throws Exception {
        Class c = Classes.forNameByThread((String)clsnm);
        if (clses != null) {
            for (Class<?> cls : clses) {
                if (cls.isAssignableFrom(c)) continue;
                throw new UiException(c + " must implement " + cls);
            }
        }
        return c;
    }

    private static void noEL(String nm, String val, Element el) throws UiException {
        if (DefinitionLoaders.withEL(val)) {
            throw new UiException(nm + " does not support EL expressions, " + el.getLocator());
        }
    }

    private static boolean withEL(String val) {
        return val != null && val.indexOf("${") >= 0;
    }

    private static void parsePI(LanguageDefinition langdef, Document doc) throws Exception {
        for (Object o : doc.getChildren()) {
            if (!(o instanceof ProcessingInstruction)) continue;
            ProcessingInstruction pi = (ProcessingInstruction)o;
            String target = pi.getTarget();
            Map params = pi.parseData();
            if ("taglib".equals(target)) {
                String uri = (String)params.remove("uri");
                String prefix = (String)params.remove("prefix");
                if (!params.isEmpty()) {
                    log.warning("Ignored unknown attribute: " + params + ", " + pi.getLocator());
                }
                if (uri == null || prefix == null) {
                    throw new UiException("Both uri and prefix attribute are required, " + pi.getLocator());
                }
                if (log.debugable()) {
                    log.debug("taglib: prefix=" + prefix + " uri=" + uri);
                }
                langdef.addTaglib(new Taglib(prefix, uri));
                continue;
            }
            log.warning("Unknown processing instruction: " + target);
        }
    }

    private static void parseLabelTemplate(LanguageDefinition langdef, Element el) {
        if ((el = el.getElement("label-template")) != null) {
            Element raw = el.getElement("raw");
            langdef.setLabelTemplate(IDOMs.getRequiredElementValue((Element)el, (String)"component-name"), IDOMs.getRequiredElementValue((Element)el, (String)"component-attribute"), raw != null && !"false".equals(raw.getText(true)));
        }
    }

    private static void parseMacroTemplate(LanguageDefinition langdef, Element el) throws Exception {
        if ((el = el.getElement("macro-template")) != null) {
            Class cls = DefinitionLoaders.locateClass(IDOMs.getRequiredElementValue((Element)el, (String)"macro-class"), Component.class, Macro.class);
            langdef.setMacroTemplate(cls);
        }
    }

    private static void parseNativeTemplate(LanguageDefinition langdef, Element el) throws Exception {
        if ((el = el.getElement("native-template")) != null) {
            Class cls = DefinitionLoaders.locateClass(IDOMs.getRequiredElementValue((Element)el, (String)"native-class"), Component.class, Native.class);
            langdef.setNativeTemplate(cls);
        }
    }

    private static void parseDynamicTag(LanguageDefinition langdef, Element el) throws ClassNotFoundException {
        if ((el = el.getElement("dynamic-tag")) != null) {
            String compnm = IDOMs.getRequiredElementValue((Element)el, (String)"component-name");
            HashSet<String> reservedAttrs = new HashSet<String>(8);
            for (Element e : el.getElements("reserved-attribute")) {
                reservedAttrs.add(e.getText(true));
            }
            langdef.setDynamicTagInfo(compnm, reservedAttrs);
        }
    }

    private static List<String> parseExtensions(Element elm) {
        LinkedList<String> exts = new LinkedList<String>();
        for (Element el : elm.getElements("extension")) {
            String ext = el.getText(true);
            if (ext.length() == 0) continue;
            int len = ext.length();
            for (int j = 0; j < len; ++j) {
                char cc = ext.charAt(j);
                if (cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z' || cc >= '0' && cc <= '9') continue;
                throw new UiException("Invalid extension; only letters and numbers are allowed: " + ext);
            }
            exts.add(ext);
        }
        return exts;
    }

    private static Map<String, String> parseProps(Element elm) {
        return IDOMs.parseParams((Element)elm, (String)"property", (String)"property-name", (String)"property-value");
    }

    private static Map<String, String> parseCustAttrs(Element elm) {
        return IDOMs.parseParams((Element)elm, (String)"custom-attribute", (String)"attribute-name", (String)"attribute-value");
    }

    private static Map<String, String> parseAttrs(Element elm) {
        return IDOMs.parseParams((Element)elm, (String)"attribute", (String)"attribute-name", (String)"attribute-value");
    }

    private static void parseAnnots(ComponentDefinitionImpl compdef, Element top) {
        for (Element el : top.getElements("annotation")) {
            String annotName = IDOMs.getRequiredElementValue((Element)el, (String)"annotation-name");
            LinkedHashMap<String, Object> annotAttrs = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, String> me : DefinitionLoaders.parseAttrs(el).entrySet()) {
                annotAttrs.put(me.getKey(), AnnotationHelper.parseAttributeValue(me.getValue().trim()));
            }
            String prop = el.getElementValue("property-name", true);
            if (prop == null || prop.length() == 0) {
                compdef.addAnnotation(annotName, annotAttrs);
                continue;
            }
            compdef.addAnnotation(prop, annotName, annotAttrs);
        }
    }

    private static Integer parseInteger(Element el, String subnm, boolean positiveOnly) throws UiException {
        String val = el.getElementValue(subnm, true);
        if (val != null && val.length() > 0) {
            try {
                int v = Integer.parseInt(val);
                if (!positiveOnly || v > 0) {
                    return new Integer(v);
                }
                log.warning("Ignored: the " + subnm + " element must be a positive number, not " + val + ", at " + el.getLocator());
            }
            catch (NumberFormatException ex) {
                log.warning("Ignored: the " + subnm + " element must be a number, not " + val + ", at " + el.getLocator());
            }
        }
        return null;
    }
}

