/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.zkoss.lang.Classes;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.GenericComposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericAnnotatedComposer<T extends Component>
extends GenericComposer<T>
implements ComponentCloneListener,
ComponentActivationListener {
    private static final long serialVersionUID = 5022810317492589463L;
    private static final String COMPOSER_CLONE = "COMPOSER_CLONE";
    private static final String ON_CLONE_DO_AFTER_COMPOSE = "onCLONE_DO_AFTER_COMPOSE";
    private Component _self;
    private static Method _alert;

    @Override
    public void doAfterCompose(T comp) throws Exception {
        super.doAfterCompose(comp);
        this._self = comp;
        this.autowire((Component)comp);
        Selectors.wireEventListeners(comp, this);
        comp.addEventListener("onCreate", new BeforeCreateWireListener());
    }

    protected final void rewire() {
        this.autowire(this._self);
    }

    protected void alert(String m) {
        try {
            if (_alert == null) {
                Class mboxcls = Classes.forNameByThread((String)"org.zkoss.zul.Messagebox");
                _alert = mboxcls.getMethod("show", String.class);
            }
            _alert.invoke(null, m);
        }
        catch (InvocationTargetException e) {
            throw UiException.Aide.wrap(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object willClone(Component comp) {
        try {
            Execution exec = Executions.getCurrent();
            int idcode = System.identityHashCode(comp);
            Composer composerClone = (Composer)exec.getAttribute(COMPOSER_CLONE + idcode);
            if (composerClone == null) {
                composerClone = (Composer)Classes.newInstance(this.getClass(), null);
                exec.setAttribute(COMPOSER_CLONE + idcode, composerClone);
                comp.addEventListener(ON_CLONE_DO_AFTER_COMPOSE, new CloneDoAfterCompose());
                Events.postEvent(new Event(ON_CLONE_DO_AFTER_COMPOSE, comp, composerClone));
            }
            return composerClone;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    private void autowire(Component comp) {
        IdSpace spaceOwner = comp.getSpaceOwner();
        if (spaceOwner instanceof Page) {
            Selectors.wireVariables((Page)spaceOwner, (Object)this);
        } else {
            Selectors.wireVariables((Component)((Object)spaceOwner), (Object)this);
        }
    }

    @Override
    public void doBeforeComposeChildren(Component comp) throws Exception {
        Selectors.wireController(comp, this);
    }

    @Override
    public void didActivate(Component comp) {
        IdSpace spaceOwner = comp.getSpaceOwner();
        if (spaceOwner instanceof Page) {
            Selectors.rewireVariables((Page)spaceOwner, (Object)this);
        } else {
            Selectors.rewireVariables((Component)((Object)spaceOwner), (Object)this);
        }
    }

    @Override
    public void willPassivate(Component comp) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloneDoAfterCompose
    implements EventListener<Event> {
        private CloneDoAfterCompose() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            Component clone = event.getTarget();
            GenericAnnotatedComposer composerClone = (GenericAnnotatedComposer)event.getData();
            Selectors.wireController(clone, composerClone);
            composerClone.doAfterCompose(clone);
            clone.removeEventListener(GenericAnnotatedComposer.ON_CLONE_DO_AFTER_COMPOSE, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeforeCreateWireListener
    implements EventListener<Event> {
        private BeforeCreateWireListener() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            GenericAnnotatedComposer.this.autowire(event.getTarget());
            event.getTarget().removeEventListener("onCreate", this);
        }
    }
}

