/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.GenericAnnotatedComposer;
import org.zkoss.zk.ui.select.Listen;
import org.zkoss.zk.ui.select.Wire;
import org.zkoss.zk.ui.select.WireXel;
import org.zkoss.zk.ui.select.WireZScript;
import org.zkoss.zk.ui.select.impl.ComponentIterator;
import org.zkoss.zk.ui.select.impl.Reflections;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selectors {
    public static Iterable<Component> iterable(final Page page, final String selector) {
        return new Iterable<Component>(){

            @Override
            public Iterator<Component> iterator() {
                return new ComponentIterator(page, selector);
            }
        };
    }

    public static Iterable<Component> iterable(final Component root, final String selector) {
        return new Iterable<Component>(){

            @Override
            public Iterator<Component> iterator() {
                return new ComponentIterator(root, selector);
            }
        };
    }

    public static List<Component> find(Page page, String selector) {
        return Selectors.toList(Selectors.iterable(page, selector));
    }

    public static List<Component> find(Component root, String selector) {
        return Selectors.toList(Selectors.iterable(root, selector));
    }

    public static Component find(Page page, String selector, int index) {
        return Selectors.getIthItem(new ComponentIterator(page, selector), index);
    }

    public static Component find(Component root, String selector, int index) {
        return Selectors.getIthItem(new ComponentIterator(root, selector), index);
    }

    public static void wireVariables(Page page, Object controller) {
        new Wirer(controller, false).wireVariables(new PageFunctor(page));
    }

    static void rewireVariables(Page page, Object controller) {
        new Wirer(controller, true).wireVariables(new PageFunctor(page));
    }

    public static void wireVariables(Component component, Object controller) {
        new Wirer(controller, false).wireVariables(new ComponentFunctor(component));
    }

    static void rewireVariables(Component component, Object controller) {
        new Wirer(controller, true).wireVariables(new ComponentFunctor(component));
    }

    public static void wireController(Component component, Object controller) {
        Wire anno = controller.getClass().getAnnotation(Wire.class);
        if (anno == null || anno.value().length() == 0) {
            Components.wireController(component, controller);
            return;
        }
        String compKey = anno.value();
        if (!component.hasAttributeOrFellow(compKey, false)) {
            component.setAttribute(compKey, controller);
        }
    }

    public static void wireEventListeners(final Component component, final Object controller) {
        Reflections.forMethods(controller.getClass(), Listen.class, new Reflections.MethodRunner<Listen>(){

            @Override
            public void onMethod(Class<?> clazz, Method method, Listen anno) {
                if ((method.getModifiers() & 8) != 0) {
                    throw new UiException("Cannot add forward to static method: " + method.getName());
                }
                if (method.getParameterTypes().length > 1) {
                    throw new UiException("Event handler method should have at most one parameter: " + method.getName());
                }
                for (String[] strs : Selectors.splitListenAnnotationValues(anno.value())) {
                    String name = strs[0];
                    if (name == null) {
                        name = "onClick";
                    }
                    Iterable<Component> iter = Selectors.iterable(component, strs[1]);
                    for (Component c : iter) {
                        c.addEventListener(name, new ComposerEventListener(method, controller));
                    }
                }
            }
        });
    }

    private static String[][] splitListenAnnotationValues(String str) {
        String last;
        ArrayList<String[]> result = new ArrayList<String[]>();
        int len = str.length();
        boolean inSqBracket = false;
        boolean inQuote = false;
        boolean escaped = false;
        String evtName = null;
        int i = 0;
        for (int j = 0; j < len; ++j) {
            char c = str.charAt(j);
            if (!escaped) {
                switch (c) {
                    case '[': {
                        inSqBracket = true;
                        break;
                    }
                    case ']': {
                        inSqBracket = false;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        inQuote = !inQuote;
                        break;
                    }
                    case '=': {
                        if (inSqBracket || inQuote) break;
                        if (evtName != null) {
                            throw new UiException("Illegal value of @Listen: " + str);
                        }
                        evtName = str.substring(i, j).trim();
                        if (evtName.length() < 3 || !evtName.startsWith("on") || !Character.isUpperCase(evtName.charAt(2))) {
                            throw new UiException("Illegal value of @Listen: " + str);
                        }
                        i = j + 1;
                        break;
                    }
                    case ';': {
                        if (inQuote) break;
                        String target = str.substring(i, j).trim();
                        if (target.length() == 0) {
                            throw new UiException("Illegal value of @Listen: " + str);
                        }
                        result.add(new String[]{evtName, target});
                        i = j + 1;
                        evtName = null;
                        break;
                    }
                }
            }
            escaped = !escaped && c == '\\';
        }
        if (i < len && (last = str.substring(i).trim()).length() > 0) {
            result.add(new String[]{evtName, last});
        }
        return (String[][])result.toArray((T[])new String[0][0]);
    }

    private static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            result.add(t);
        }
        return result;
    }

    private static <A extends Annotation> A getAnnotation(Class<?> ctrlClass, Class<A> annoClass) {
        for (Class<?> cls = ctrlClass; cls != null && !cls.equals(GenericAnnotatedComposer.class); cls = cls.getSuperclass()) {
            A anno = cls.getAnnotation(annoClass);
            if (anno == null) continue;
            return anno;
        }
        return null;
    }

    private static boolean isValidValue(Object value, Class<?> clazz) {
        return value != null && clazz.isAssignableFrom(value.getClass());
    }

    private static Collection getCollectionInstanceIfPossible(Class<?> clazz) {
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet();
        }
        if (clazz.isAssignableFrom(TreeSet.class)) {
            return new TreeSet();
        }
        return null;
    }

    private static <T> T[] generateArray(Class<T> clazz, Iterable<Component> comps) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (Component c : comps) {
            if (!clazz.isAssignableFrom(c.getClass())) continue;
            list.add(c);
        }
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    private static <T> T getIthItem(Iterator<T> iter, int index) {
        for (int i = 1; i < index; ++i) {
            if (!iter.hasNext()) {
                return null;
            }
            iter.next();
        }
        return iter.hasNext() ? (T)iter.next() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentFunctor
    implements PsdoCompFunctor {
        private final Component _comp;

        private ComponentFunctor(Component comp) {
            this._comp = comp;
        }

        @Override
        public Iterable<Component> iterable(String selector) {
            IdSpace spaceOwner = this._comp.getSpaceOwner();
            return spaceOwner instanceof Component ? Selectors.iterable((Component)((Object)spaceOwner), selector) : Selectors.iterable((Page)spaceOwner, selector);
        }

        @Override
        public Object getImplicit(String name) {
            return Components.getImplicit(this._comp, name);
        }

        @Override
        public Object getZScriptVariable(String name) {
            return this.getPage().getZScriptVariable(name);
        }

        @Override
        public Object getXelVariable(String name) {
            return this.getPage().getXelVariable(null, null, name, true);
        }

        @Override
        public Object getAttributeOrFellow(String name) {
            return this._comp.getAttributeOrFellow(name, true);
        }

        private Page getPage() {
            Page page = this._comp.getPage();
            if (page != null) {
                return page;
            }
            Execution exec = Executions.getCurrent();
            return exec != null ? ((ExecutionCtrl)((Object)exec)).getCurrentPage() : null;
        }

        @Override
        public Component getFellowIfAny(String name) {
            return this._comp.getFellowIfAny(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PageFunctor
    implements PsdoCompFunctor {
        private final Page _page;

        private PageFunctor(Page page) {
            this._page = page;
        }

        @Override
        public Iterable<Component> iterable(String selector) {
            return Selectors.iterable(this._page, selector);
        }

        @Override
        public Object getImplicit(String name) {
            return Components.getImplicit(this._page, name);
        }

        @Override
        public Object getZScriptVariable(String name) {
            return this._page.getZScriptVariable(name);
        }

        @Override
        public Object getXelVariable(String name) {
            return this._page.getXelVariable(null, null, name, true);
        }

        @Override
        public Object getAttributeOrFellow(String name) {
            return this._page.getAttributeOrFellow(name, true);
        }

        @Override
        public Component getFellowIfAny(String name) {
            return this._page.getFellowIfAny(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PsdoCompFunctor {
        public Iterable<Component> iterable(String var1);

        public Object getImplicit(String var1);

        public Object getZScriptVariable(String var1);

        public Object getAttributeOrFellow(String var1);

        public Object getXelVariable(String var1);

        public Component getFellowIfAny(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComposerEventListener
    implements EventListener<Event> {
        private final Method _ctrlMethod;
        private final Object _ctrl;

        public ComposerEventListener(Method method, Object controller) {
            this._ctrlMethod = method;
            this._ctrl = controller;
        }

        @Override
        public void onEvent(Event event) throws Exception {
            if (this._ctrlMethod.getParameterTypes().length == 0) {
                this._ctrlMethod.invoke(this._ctrl, new Object[0]);
            } else {
                this._ctrlMethod.invoke(this._ctrl, event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Wirer {
        private final Object _controller;
        private final boolean _ignoreXel;
        private final boolean _ignoreZScript;
        private final boolean _rewire;

        private Wirer(Object controller, boolean rewire) {
            this._controller = controller;
            Class<?> cls = controller.getClass();
            WireZScript wz = (WireZScript)Selectors.getAnnotation(cls, WireZScript.class);
            WireXel wx = (WireXel)Selectors.getAnnotation(cls, WireXel.class);
            this._ignoreZScript = wz == null || !wz.value();
            this._ignoreXel = wx == null || !wx.value();
            this._rewire = rewire;
        }

        private void wireVariables(final PsdoCompFunctor functor) {
            Class<?> ctrlClass = this._controller.getClass();
            Reflections.forFields(ctrlClass, Wire.class, new Reflections.FieldRunner<Wire>(){

                @Override
                public void onField(Class<?> clazz, Field field, Wire anno) {
                    if ((field.getModifiers() & 8) != 0) {
                        throw new UiException("Cannot wire variable to static field: " + field.getName());
                    }
                    Type tp = field.getGenericType();
                    if (Wirer.this._rewire && tp instanceof Class) {
                        Class cls = (Class)tp;
                        if (!(anno.rewireOnActivate() || Session.class.isAssignableFrom(cls) || WebApp.class.isAssignableFrom(cls))) {
                            return;
                        }
                    }
                    String selector = anno.value();
                    boolean optional = anno.optional();
                    if (selector.length() > 0) {
                        Wirer.this.injectComponent(field, (Iterable<Component>)functor.iterable(selector), optional);
                        return;
                    }
                    Object value = Wirer.this.getObjectByName(functor, field.getName(), field.getType());
                    if (value != null) {
                        Reflections.setFieldValue(Wirer.this._controller, field, value);
                        return;
                    }
                    if (optional) {
                        return;
                    }
                    String name = field.getName();
                    if (name.contains("$")) {
                        throw new UiException("GenericAnnotatedComposer does not support syntax with '$'. Please use selector as alternative.");
                    }
                    throw new UiException("Cannot wire variable to field: " + name);
                }
            });
            Reflections.forMethods(ctrlClass, Wire.class, new Reflections.MethodRunner<Wire>(){

                @Override
                public void onMethod(Class<?> clazz, Method method, Wire anno) {
                    String selector;
                    String name = method.getName();
                    if ((method.getModifiers() & 8) != 0) {
                        throw new UiException("Cannot wire variable by static method: " + name);
                    }
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length != 1) {
                        throw new UiException("Setter method should have only one parameter: " + name);
                    }
                    if (Wirer.this._rewire) {
                        Class<?> cls = paramTypes[0];
                        if (!(anno.rewireOnActivate() || Session.class.isAssignableFrom(cls) || WebApp.class.isAssignableFrom(cls))) {
                            return;
                        }
                    }
                    if ((selector = anno.value()).length() == 0) {
                        throw new UiException("Selector is empty on method: " + method.getName());
                    }
                    Wirer.this.injectComponent(method, (Iterable<Component>)functor.iterable(selector), anno.optional());
                }
            });
        }

        private void injectComponent(Method method, Iterable<Component> iter, boolean optional) {
            this.injectComponent(new MethodFunctor(method), iter, optional);
        }

        private void injectComponent(Field field, Iterable<Component> iter, boolean optional) {
            this.injectComponent(new FieldFunctor(field), iter, optional);
        }

        private void injectComponent(InjectionFunctor injector, Iterable<Component> comps, boolean optional) {
            Class<?> type = injector.getType();
            boolean isField = injector instanceof FieldFunctor;
            if (type.isArray()) {
                injector.inject(this._controller, Selectors.generateArray(type.getComponentType(), comps));
                return;
            }
            if (Collection.class.isAssignableFrom(type)) {
                Collection collection = null;
                if (isField) {
                    Field field = ((FieldFunctor)injector).getField();
                    try {
                        collection = (Collection)field.get(this._controller);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Field " + field + " not accessible or not declared by" + this._controller);
                    }
                }
                if (collection == null) {
                    collection = Selectors.getCollectionInstanceIfPossible(type);
                    if (collection == null) {
                        throw new UiException("Cannot initiate collection for " + (isField ? "field" : "method") + ": " + injector.getName() + " on " + this._controller);
                    }
                    if (isField) {
                        injector.inject(this._controller, collection);
                    }
                }
                collection.clear();
                for (Component c : comps) {
                    if (!Reflections.isAppendableToCollection(injector.getGenericType(), c)) continue;
                    collection.add(c);
                }
                if (!isField) {
                    injector.inject(this._controller, collection);
                }
                return;
            }
            for (Component c : comps) {
                if (!type.isInstance(c)) continue;
                injector.inject(this._controller, c);
                return;
            }
            if (!optional) {
                throw new UiException("Failed to inject to field " + injector.getName() + "on controller " + this._controller);
            }
            injector.inject(this._controller, null);
        }

        private Object getObjectByName(PsdoCompFunctor functor, String name, Class<?> type) {
            Object result = functor.getImplicit(name);
            if (Selectors.isValidValue(result, type)) {
                return result;
            }
            if (!this._ignoreZScript && Selectors.isValidValue(result = functor.getZScriptVariable(name), type)) {
                return result;
            }
            result = functor.getAttributeOrFellow(name);
            if (Selectors.isValidValue(result, type)) {
                return result;
            }
            if (!this._ignoreXel && Selectors.isValidValue(result = functor.getXelVariable(name), type)) {
                return result;
            }
            result = functor.getFellowIfAny(name);
            return Selectors.isValidValue(result, type) ? result : null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MethodFunctor
        implements InjectionFunctor {
            private final Method _method;

            private MethodFunctor(Method method) {
                this._method = method;
            }

            @Override
            public String getName() {
                return this._method.getName();
            }

            @Override
            public void inject(Object obj, Object value) {
                Reflections.invokeMethod(this._method, obj, value);
            }

            @Override
            public Class<?> getType() {
                return this._method.getParameterTypes()[0];
            }

            @Override
            public Type getGenericType() {
                return this._method.getGenericParameterTypes()[0];
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FieldFunctor
        implements InjectionFunctor {
            private final Field _field;

            private FieldFunctor(Field field) {
                this._field = field;
            }

            @Override
            public void inject(Object obj, Object value) {
                Reflections.setFieldValue(obj, this._field, value);
            }

            @Override
            public String getName() {
                return this._field.getName();
            }

            @Override
            public Class<?> getType() {
                return this._field.getType();
            }

            public Field getField() {
                return this._field;
            }

            @Override
            public Type getGenericType() {
                return this._field.getGenericType();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static interface InjectionFunctor {
            public void inject(Object var1, Object var2);

            public String getName();

            public Class<?> getType();

            public Type getGenericType();
        }
    }
}

