/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.select.impl.ComponentMatchCtx;
import org.zkoss.zk.ui.select.impl.Parser;
import org.zkoss.zk.ui.select.impl.PseudoClassDef;
import org.zkoss.zk.ui.select.impl.Selector;
import org.zkoss.zk.ui.select.impl.SimpleSelectorSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentIterator
implements Iterator<Component> {
    private Page _page;
    private Component _root;
    private List<Selector> _selectorList;
    private Map<String, PseudoClassDef> _localDefs;
    private ComponentMatchCtx _currCtx;
    private boolean _ready = false;
    private Component _next;
    private int _index = -1;

    public ComponentIterator(Page page, String selector) {
        this(page, null, selector);
    }

    public ComponentIterator(Component root, String selector) {
        this(root.getPage(), root, selector);
    }

    private ComponentIterator(Page page, Component root, String selector) {
        if (page == null && root == null || selector == null || selector.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this._localDefs = new HashMap<String, PseudoClassDef>();
        this._selectorList = new Parser().parse(selector);
        this._root = root;
        this._page = page;
    }

    public void setPseudoClassDef(String name, PseudoClassDef def) {
        this._localDefs.put(name, def);
    }

    public PseudoClassDef removePseudoClassDef(String name) {
        return this._localDefs.remove(name);
    }

    public void clearPseudoClassDefs() {
        this._localDefs.clear();
    }

    @Override
    public boolean hasNext() {
        this.loadNext();
        return this._next != null;
    }

    @Override
    public Component next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this._ready = false;
        return this._next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Component peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._next;
    }

    public int nextIndex() {
        return this._ready ? this._index : this._index + 1;
    }

    private void loadNext() {
        if (this._ready) {
            return;
        }
        this._next = this.seekNext();
        this._ready = true;
    }

    private Component seekNext() {
        ComponentMatchCtx componentMatchCtx = this._currCtx = this._index < 0 ? this.buildRootCtx() : this.buildNextCtx();
        while (this._currCtx != null && !this._currCtx.isMatched()) {
            this._currCtx = this.buildNextCtx();
        }
        if (this._currCtx != null) {
            ++this._index;
            return this._currCtx.getComponent();
        }
        return null;
    }

    private ComponentMatchCtx buildRootCtx() {
        Component rt = this._root == null ? this._page.getFirstRoot() : this._root;
        ComponentMatchCtx ctx = new ComponentMatchCtx(rt, this._selectorList);
        this.matchLevel0(this._selectorList, ctx);
        return ctx;
    }

    private ComponentMatchCtx buildNextCtx() {
        if (this._currCtx.getComponent().getFirstChild() != null) {
            return this.buildFirstChildCtx(this._currCtx);
        }
        while (this._currCtx.getComponent().getNextSibling() == null) {
            this._currCtx = this._currCtx.getParent();
            if (this._currCtx != null && this._currCtx.getComponent() != this._root) continue;
            return null;
        }
        return this.buildNextSiblingCtx(this._currCtx);
    }

    private ComponentMatchCtx buildFirstChildCtx(ComponentMatchCtx parent) {
        ComponentMatchCtx ctx = new ComponentMatchCtx(parent.getComponent().getFirstChild(), parent);
        this.matchLevel0(this._selectorList, ctx);
        for (Selector selector : this._selectorList) {
            int i = selector.getSelectorIndex();
            block5: for (int j = 0; j < selector.size() - 1; ++j) {
                switch (selector.getCombinator(j)) {
                    case DESCENDANT: {
                        if (parent.isQualified(i, j)) {
                            ctx.setQualified(i, j);
                        }
                    }
                    case CHILD: {
                        if (!parent.isQualified(i, j) || !this.match(selector, ctx, j + 1)) continue block5;
                        ctx.setQualified(i, j + 1);
                    }
                }
            }
        }
        return ctx;
    }

    private ComponentMatchCtx buildNextSiblingCtx(ComponentMatchCtx ctx) {
        ctx.moveToNextSibling();
        for (Selector selector : this._selectorList) {
            int i = selector.getSelectorIndex();
            ctx.setQualified(i, selector.size() - 1, this.match(selector, ctx, selector.size() - 1));
            block6: for (int j = selector.size() - 2; j > -1; --j) {
                Selector.Combinator cb = selector.getCombinator(j);
                ComponentMatchCtx parent = ctx.getParent();
                switch (cb) {
                    case DESCENDANT: 
                    case CHILD: {
                        if (parent == null || !parent.isQualified(i, j) || !this.match(selector, ctx, j + 1)) continue block6;
                        ctx.setQualified(i, j + 1);
                        continue block6;
                    }
                    case GENERAL_SIBLING: {
                        if (!ctx.isQualified(i, j)) continue block6;
                        ctx.setQualified(i, j + 1, this.match(selector, ctx, j + 1));
                        continue block6;
                    }
                    case ADJACENT_SIBLING: {
                        ctx.setQualified(i, j + 1, ctx.isQualified(i, j) && this.match(selector, ctx, j + 1));
                        ctx.setQualified(i, j, false);
                    }
                }
            }
        }
        this.matchLevel0(this._selectorList, ctx);
        return ctx;
    }

    private void matchLevel0(List<Selector> list, ComponentMatchCtx ctx) {
        for (Selector selector : list) {
            if (!this.match(selector, ctx, 0)) continue;
            ctx.setQualified(selector.getSelectorIndex(), 0);
        }
    }

    private boolean match(Selector selector, ComponentMatchCtx ctx, int index) {
        return ctx.match((SimpleSelectorSequence)selector.get(index), this._localDefs);
    }
}

