/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.StubComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubsComponent
extends StubComponent {
    private String[] _uuids;
    private String[][] _idmap;

    public void onChildrenMerged(Component replaced) {
        if (this._uuids != null) {
            throw new IllegalStateException("called twice");
        }
        LinkedList<String> uuids = new LinkedList<String>();
        LinkedList<String[]> idmap = new LinkedList<String[]>();
        Page page = this.getPage();
        this.mapChildren(page != null ? (DesktopCtrl)((Object)page.getDesktop()) : null, uuids, idmap, replaced);
        this._uuids = uuids.toArray(new String[uuids.size()]);
        this._idmap = (String[][])idmap.toArray((T[])new String[idmap.size()][]);
    }

    private void mapChildren(DesktopCtrl desktopCtrl, List<String> uuids, List<String[]> idmap, Component comp) {
        for (Component p = comp.getFirstChild(); p != null; p = p.getNextSibling()) {
            String id;
            if (p instanceof StubsComponent) {
                String[][] kidids;
                String[] kiduuids = ((StubsComponent)p)._uuids;
                if (kiduuids != null) {
                    for (int j = 0; j < kiduuids.length; ++j) {
                        uuids.add(kiduuids[j]);
                        if (desktopCtrl == null) continue;
                        desktopCtrl.mapComponent(kiduuids[j], this);
                    }
                }
                if ((kidids = ((StubsComponent)p)._idmap) != null) {
                    for (int j = 0; j < kidids.length; ++j) {
                        idmap.add(kidids[j]);
                    }
                }
            }
            String uuid = p.getUuid();
            uuids.add(uuid);
            if (desktopCtrl != null) {
                desktopCtrl.mapComponent(uuid, this);
            }
            if ((id = p.getId()) != null && id.length() > 0) {
                idmap.add(new String[]{uuid, id});
            }
            this.mapChildren(desktopCtrl, uuids, idmap, p);
        }
    }

    @Override
    public String getId(String uuid) {
        if (this._idmap != null) {
            for (int j = 0; j < this._idmap.length; ++j) {
                if (!uuid.equals(this._idmap[j][0])) continue;
                return this._idmap[j][1];
            }
        }
        return super.getId(uuid);
    }

    @Override
    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)newpage.getDesktop());
            for (int j = 0; j < this._uuids.length; ++j) {
                desktopCtrl.mapComponent(this._uuids[j], this);
            }
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)page.getDesktop());
        for (int j = 0; j < this._uuids.length; ++j) {
            desktopCtrl.mapComponent(this._uuids[j], null);
        }
    }

    @Override
    public String getWidgetClass() {
        return "#stubs";
    }

    @Override
    protected boolean isChildable() {
        return false;
    }

    @Override
    public String toString() {
        int j;
        StringBuffer sb = new StringBuffer(super.toString());
        if (this._uuids != null) {
            sb.append('(');
            for (j = 0; j < this._uuids.length; ++j) {
                if (j != 0) {
                    sb.append(", ");
                }
                sb.append(this._uuids[j]);
            }
            sb.append(')');
        }
        if (this._idmap != null) {
            sb.append('(');
            for (j = 0; j < this._idmap.length; ++j) {
                if (j != 0) {
                    sb.append(", ");
                }
                sb.append(this._idmap[j][0]).append('=').append(this._idmap[j][1]);
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

