/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.theme;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.util.ThemeProvider;
import org.zkoss.zkplus.theme.Themes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardThemeProvider
implements ThemeProvider {
    public static final String DEFAULT_WCS = "~./zul/css/zk.wcs";

    public Collection<Object> getThemeURIs(Execution exec, List<Object> uris) {
        String suffix = StandardThemeProvider.getThemeFileSuffix();
        if (!Strings.isEmpty((String)suffix)) {
            this.bypassURI(uris, suffix);
        }
        return uris;
    }

    private static String getThemeFileSuffix() {
        String suffix = Themes.getCurrentTheme();
        return "breeze".equals(suffix) ? null : suffix;
    }

    private void bypassURI(List<Object> uris, String suffix) {
        ListIterator<Object> it = uris.listIterator();
        while (it.hasNext()) {
            String uri;
            Object o = it.next();
            if (!(o instanceof String) || !(uri = (String)o).startsWith(DEFAULT_WCS)) continue;
            it.set(ThemeProvider.Aide.injectURI((String)uri, (String)suffix));
            break;
        }
    }

    public int getWCSCacheControl(Execution exec, String uri) {
        return 8760;
    }

    public String beforeWCS(Execution exec, String uri) {
        return uri;
    }

    public String beforeWidgetCSS(Execution exec, String uri) {
        String suffix = StandardThemeProvider.getThemeFileSuffix();
        if (Strings.isEmpty((String)suffix)) {
            return uri;
        }
        if (uri.startsWith("~./zul/css/") || uri.startsWith("~./js/zul/") || uri.startsWith("~./js/zkex/") || uri.startsWith("~./js/zkmax/")) {
            return uri.replaceFirst("~./", "~./" + suffix + "/");
        }
        return uri;
    }
}

