/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import org.zkoss.zul.AbstractTreeModel;
import org.zkoss.zul.TreeModelExt;
import org.zkoss.zul.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeModel<E>
extends AbstractTreeModel<TreeNode<E>>
implements TreeModelExt<TreeNode<E>>,
Serializable {
    private static final long serialVersionUID = 20110131094811L;

    public DefaultTreeModel(TreeNode<E> root) {
        super(root);
        TreeNode<E> parent = root.getParent();
        if (parent != null) {
            parent.remove(root);
        }
        root.setModel(this);
    }

    @Override
    public boolean isLeaf(TreeNode<E> node) {
        return node.isLeaf();
    }

    @Override
    public TreeNode<E> getChild(TreeNode<E> parent, int index) {
        return parent.getChildAt(index);
    }

    @Override
    public int getChildCount(TreeNode<E> parent) {
        return parent.getChildCount();
    }

    @Override
    public int getIndexOfChild(TreeNode<E> parent, TreeNode<E> child) {
        return parent.getIndex(child);
    }

    @Override
    public void sort(Comparator<TreeNode<E>> cmpr, boolean ascending) {
        TreeNode root = (TreeNode)this.getRoot();
        if (root != null) {
            this.sort0(root, cmpr);
            this.fireStructureChangedEvent(root);
        }
    }

    private void sort0(TreeNode<E> node, Comparator<TreeNode<E>> cmpr) {
        if (node.getChildren() == null) {
            return;
        }
        Collections.sort(node.getChildren(), cmpr);
        for (TreeNode<E> child : node.getChildren()) {
            this.sort0(child, cmpr);
        }
    }

    private void fireStructureChangedEvent(TreeNode<E> node) {
        if (node.getChildCount() == 0) {
            return;
        }
        this.fireEvent(node, 0, 0, 3);
    }
}

