/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.util.ArraysX;
import org.zkoss.zul.AbstractGroupsModel;
import org.zkoss.zul.GroupComparator;
import org.zkoss.zul.GroupsModelExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsModelArray<D, H, F>
extends AbstractGroupsModel<D, H, F>
implements GroupsModelExt<D> {
    protected D[] _nativedata;
    protected Comparator<D> _comparator;
    protected D[][] _data;
    protected Object[] _heads;
    protected Object[] _foots;
    protected boolean[] _closes;

    public GroupsModelArray(D[] data, Comparator<D> cmpr) {
        this(data, cmpr, 0);
    }

    public GroupsModelArray(D[] data, Comparator<D> cmpr, int col) {
        this(data, cmpr, col, true);
    }

    public GroupsModelArray(D[] data, Comparator<D> cmpr, int col, boolean clone) {
        if (data == null || cmpr == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this._nativedata = clone ? ArraysX.duplicate((Object[])data) : data;
        this._comparator = cmpr;
        this.group(this._comparator, true, col);
    }

    public GroupsModelArray(List<D> data, Comparator cmpr, int col) {
        this(data.toArray(), cmpr, col, false);
    }

    public GroupsModelArray(List<D> data, Comparator cmpr) {
        this(data, cmpr, 0);
    }

    @Override
    public D getChild(int groupIndex, int index) {
        return this._data[groupIndex][index];
    }

    @Override
    public int getChildCount(int groupIndex) {
        return this._data[groupIndex].length;
    }

    @Override
    public H getGroup(int groupIndex) {
        return (H)this._heads[groupIndex];
    }

    @Override
    public int getGroupCount() {
        return this._data.length;
    }

    @Override
    public F getGroupfoot(int groupIndex) {
        return (F)this._foots[groupIndex];
    }

    @Override
    public boolean hasGroupfoot(int groupIndex) {
        return this._foots == null ? false : this._foots[groupIndex] != null;
    }

    @Override
    public void sort(Comparator<D> cmpr, boolean ascending, int col) {
        this.sortAllGroupData(cmpr, ascending, col);
        this.fireEvent(3, -1, -1, -1);
    }

    @Override
    public void group(final Comparator<D> cmpr, boolean ascending, int col) {
        Comparator cmprx = cmpr instanceof GroupComparator ? new Comparator<D>(){

            @Override
            public int compare(D o1, D o2) {
                return ((GroupComparator)cmpr).compareGroup(o1, o2);
            }
        } : cmpr;
        this.sortDataInGroupOrder(cmprx, ascending, col);
        this.organizeGroup(cmprx, col);
        if (cmprx != cmpr) {
            this.sortAllGroupData(cmpr, ascending, col);
        }
        this.fireEvent(7, -1, -1, -1);
    }

    @Override
    public boolean isClose(int groupIndex) {
        return this._closes == null ? false : this._closes[groupIndex];
    }

    @Override
    public void setClose(int groupIndex, boolean close) {
        if (this._closes == null) {
            this._closes = new boolean[this.getGroupCount()];
        }
        if (this._closes[groupIndex] != close) {
            this._closes[groupIndex] = close;
            this.fireEvent(4, groupIndex, -1, -1);
        }
    }

    private void sortAllGroupData(Comparator<D> cmpr, boolean ascending, int col) {
        for (int i = 0; i < this._data.length; ++i) {
            this.sortGroupData(this.getGroup(i), this._data[i], cmpr, ascending, col);
        }
    }

    protected void sortGroupData(H group, D[] groupdata, Comparator<D> cmpr, boolean ascending, int col) {
        Arrays.sort(groupdata, cmpr);
    }

    protected void organizeGroup(Comparator<D> cmpr, int col) {
        LinkedList group = new LinkedList();
        List gdata = null;
        Object last = null;
        Object curr = null;
        for (int i = 0; i < this._nativedata.length; ++i) {
            curr = this._nativedata[i];
            boolean hitn = false;
            boolean hita = false;
            if (last == null || cmpr.compare(last, curr) != 0) {
                hitn = true;
                gdata = new LinkedList<Object>();
                group.add(gdata);
            }
            gdata.add(curr);
            last = this._nativedata[i];
        }
        List[] gd = new List[group.size()];
        group.toArray(gd);
        Class<?> classD = this._nativedata.getClass().getComponentType();
        this._data = (Object[][])Array.newInstance(classD, gd.length, 0);
        this._foots = new Object[gd.length];
        this._heads = new Object[gd.length];
        this._closes = new boolean[this._data.length];
        for (int i = 0; i < gd.length; ++i) {
            gdata = gd[i];
            this._data[i] = (Object[])Array.newInstance(classD, gdata.size());
            gdata.toArray(this._data[i]);
            this._heads[i] = this.createGroupHead(this._data[i], i, col);
            this._foots[i] = this.createGroupFoot(this._data[i], i, col);
            this._closes[i] = this.createGroupClose(this._data[i], i, col);
        }
    }

    protected H createGroupHead(D[] groupdata, int index, int col) {
        D o = groupdata[0];
        return (H)(o != null && o.getClass().isArray() && col < Array.getLength(o) ? Array.get(o, col) : o);
    }

    protected F createGroupFoot(D[] groupdata, int index, int col) {
        return null;
    }

    protected void sortDataInGroupOrder(Comparator<D> cmpr, boolean ascending, int colIndex) {
        Arrays.sort(this._nativedata, cmpr);
    }

    protected boolean createGroupClose(D[] groupdata, int index, int col) {
        return false;
    }
}

