/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuSetAttribute;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.MaximizeEvent;
import org.zkoss.zk.ui.event.MinimizeEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.ext.Framable;
import org.zkoss.zul.impl.XulElement;

public class Panel
extends XulElement
implements Framable {
    private Toolbar _tbar;
    private Toolbar _bbar;
    private Toolbar _fbar;
    private Panelchildren _panelchildren;
    private Caption _caption;
    private String _border = "none";
    private String _title = "";
    private int _minheight = 100;
    private int _minwidth = 200;
    private boolean _closable;
    private boolean _collapsible;
    private boolean _floatable;
    private boolean _movable;
    private boolean _maximizable;
    private boolean _minimizable;
    private boolean _maximized;
    private boolean _minimized;
    private boolean _sizable;
    private boolean _open = true;
    private boolean _framableBC;

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", this._open);
        }
    }

    public boolean isFramable() {
        return this._border.startsWith("rounded");
    }

    public void setFramable(boolean framable) {
        boolean bordered;
        this._framableBC = true;
        boolean bl = bordered = "normal".equals(this._border) || "rounded+".equals(this._border);
        this.setBorder0(framable ? (bordered ? "rounded+" : "rounded") : (bordered ? "normal" : "none"));
    }

    public void setMovable(boolean movable) {
        if (this._movable != movable) {
            this._movable = movable;
            this.smartUpdate("movable", this._movable);
        }
    }

    public boolean isMovable() {
        return this._movable;
    }

    public boolean isFloatable() {
        return this._floatable;
    }

    public boolean setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return visible;
        }
        this._minimized = false;
        this._maximized = false;
        return this.setVisible0(visible);
    }

    private boolean setVisible0(boolean visible) {
        return super.setVisible(visible);
    }

    public void setFloatable(boolean floatable) {
        if (this._floatable != floatable) {
            this._floatable = floatable;
            this.smartUpdate("floatable", this._floatable);
        }
    }

    public boolean isMaximized() {
        return this._maximized;
    }

    public void setMaximized(boolean maximized) {
        if (this._maximized != maximized) {
            if (!this._maximizable) {
                throw new UiException("Not maximizable, " + this);
            }
            this._maximized = maximized;
            if (this._maximized) {
                this._minimized = false;
                this.setVisible0(true);
            }
            this.smartUpdate("maximized", this._maximized);
        }
    }

    public boolean isMaximizable() {
        return this._maximizable;
    }

    public void setMaximizable(boolean maximizable) {
        if (this._maximizable != maximizable) {
            this._maximizable = maximizable;
            this.smartUpdate("maximizable", this._maximizable);
        }
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    public void setMinimized(boolean minimized) {
        if (this._minimized != minimized) {
            if (!this._minimizable) {
                throw new UiException("not minimizable, " + this);
            }
            this._minimized = minimized;
            if (this._minimized) {
                this._maximized = false;
                this.setVisible0(false);
            } else {
                this.setVisible0(true);
            }
            this.smartUpdate("minimized", this._minimized);
        }
    }

    public boolean isMinimizable() {
        return this._minimizable;
    }

    public void setMinimizable(boolean minimizable) {
        if (this._minimizable != minimizable) {
            this._minimizable = minimizable;
            this.smartUpdate("minimizable", this._minimizable);
        }
    }

    public boolean isCollapsible() {
        return this._collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        if (this._collapsible != collapsible) {
            this._collapsible = collapsible;
            this.smartUpdate("collapsible", this._collapsible);
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.smartUpdate("closable", this._closable);
        }
    }

    public void setMinheight(int minheight) {
        if (minheight < 0) {
            minheight = 100;
        }
        if (this._minheight != minheight) {
            this._minheight = minheight;
            this.smartUpdate("minheight", this._minheight);
        }
    }

    public int getMinheight() {
        return this._minheight;
    }

    public void setMinwidth(int minwidth) {
        if (minwidth < 0) {
            minwidth = 200;
        }
        if (this._minwidth != minwidth) {
            this._minwidth = minwidth;
            this.smartUpdate("minwidth", this._minwidth);
        }
    }

    public int getMinwidth() {
        return this._minwidth;
    }

    public void setHflex(String flex) {
        super.setHflex(flex);
        Panelchildren pc = this.getPanelchildren();
        if (pc != null) {
            pc.smartUpdate("hflex", flex);
        }
    }

    public void setVflex(String flex) {
        super.setVflex(flex);
        Panelchildren pc = this.getPanelchildren();
        if (pc != null) {
            pc.smartUpdate("vflex", flex);
        }
    }

    public boolean isSizable() {
        return this._sizable;
    }

    public void setSizable(boolean sizable) {
        if (this._sizable != sizable) {
            this._sizable = sizable;
            this.smartUpdate("sizable", sizable);
        }
    }

    public Caption getCaption() {
        return this._caption;
    }

    public String getBorder() {
        if (this._framableBC && this._border.startsWith("rounded")) {
            return "rounded".equals(this._border) ? "none" : "normal";
        }
        return this._border;
    }

    public void setBorder(String border) {
        if (border == null || "0".equals(border) || "false".equals(border)) {
            border = "none";
        } else if ("true".equals(border)) {
            border = "normal";
        }
        if (this._framableBC) {
            if (border.startsWith("rounded")) {
                this._framableBC = false;
            } else if ("normal".equals(border)) {
                if (this._border.startsWith("rounded")) {
                    border = "rounded+";
                }
            } else if (this._border.startsWith("rounded")) {
                border = "rounded";
            }
        }
        this.setBorder0(border);
    }

    public void setBorder(boolean border) {
        this.setBorder(border ? "normal" : "none");
    }

    private void setBorder0(String border) {
        if (!Objects.equals((Object)this._border, (Object)border)) {
            this._border = border;
            this.smartUpdate("border", this._border);
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            this.smartUpdate("title", this._title);
        }
    }

    public boolean addToolbar(String name, Toolbar toolbar) {
        Object refChild = null;
        if ("tbar".equals(name)) {
            if (this._tbar != null) {
                throw new UiException("Only one top toolbar child is allowed: " + this);
            }
            refChild = this.getFirstChild();
        } else if ("bbar".equals(name)) {
            if (this._bbar != null) {
                throw new UiException("Only one bottom toolbar child is allowed: " + this);
            }
            refChild = this._fbar;
        } else if ("fbar".equals(name)) {
            if (this._fbar != null) {
                throw new UiException("Only one foot toolbar child is allowed: " + this);
            }
        } else {
            throw new UiException("Unknown toolbar: " + name);
        }
        if (super.insertBefore((Component)toolbar, refChild)) {
            if ("tbar".equals(name)) {
                this._tbar = toolbar;
                this.response((AuResponse)new AuSetAttribute((Component)this, "tbar", (Object)toolbar.getUuid()));
            } else if ("bbar".equals(name)) {
                this._bbar = toolbar;
                this.response((AuResponse)new AuSetAttribute((Component)this, "bbar", (Object)toolbar.getUuid()));
            } else if ("fbar".equals(name)) {
                this._fbar = toolbar;
                this.response((AuResponse)new AuSetAttribute((Component)this, "fbar", (Object)toolbar.getUuid()));
            }
            return true;
        }
        return false;
    }

    public void onClose() {
        this.detach();
    }

    public Toolbar getTopToolbar() {
        return this._tbar;
    }

    public Toolbar getBottomToolbar() {
        return this._bbar;
    }

    public Toolbar getFootToolbar() {
        return this._fbar;
    }

    public Panelchildren getPanelchildren() {
        return this._panelchildren;
    }

    public String getZclass() {
        return this._zclass == null ? "z-panel" : this._zclass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof Caption) {
            if (this._caption != null && this._caption != newChild) {
                throw new UiException("Only one caption is allowed: " + this);
            }
        } else {
            if (refChild instanceof Caption) {
                throw new UiException("caption must be the first child");
            }
            if (newChild instanceof Panelchildren) {
                if (this._panelchildren != null && this._panelchildren != newChild) {
                    throw new UiException("Only one panelchildren child is allowed: " + this);
                }
            } else {
                if (!(newChild instanceof Toolbar)) throw new UiException("Unsupported child for Panel: " + newChild);
                if (refChild instanceof Panelchildren || refChild == null && this.getChildren().isEmpty()) {
                    if (this._tbar != null && this._tbar != newChild) {
                        throw new UiException("Only one top toolbar child is allowed: " + this);
                    }
                } else {
                    if (refChild != null && refChild != this._fbar) throw new UiException("Only three toolbars child is allowed: " + this);
                    if (this._bbar != null && this._bbar != newChild) {
                        if (refChild != null && refChild == this._fbar) {
                            throw new UiException("Only one bottom toolbar child is allowed: " + this);
                        }
                        if (this._fbar != null && this._fbar != newChild) {
                            throw new UiException("Only one foot toolbar child is allowed: " + this);
                        }
                    }
                }
            }
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Caption) {
            refChild = this.getFirstChild();
            if (super.insertBefore(newChild, refChild)) {
                this._caption = (Caption)newChild;
                return true;
            }
        } else if (newChild instanceof Panelchildren) {
            if (super.insertBefore(newChild, refChild)) {
                this._panelchildren = (Panelchildren)newChild;
                return true;
            }
        } else if (newChild instanceof Toolbar) {
            if (super.insertBefore(newChild, refChild)) {
                if (refChild instanceof Panelchildren || refChild == null && this.getChildren().size() == (this._caption != null ? 2 : 1)) {
                    this._tbar = (Toolbar)newChild;
                } else if (refChild == null || refChild == this._fbar) {
                    if (this._bbar != null && this._bbar != newChild) {
                        this._fbar = (Toolbar)newChild;
                    } else {
                        this._bbar = (Toolbar)newChild;
                    }
                }
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (this._caption == child) {
            this._caption = null;
        } else if (this._tbar == child) {
            this._tbar = null;
        } else if (this._bbar == child) {
            this._bbar = null;
        } else if (this._panelchildren == child) {
            this._panelchildren = null;
        } else if (this._fbar == child) {
            this._fbar = null;
        }
    }

    public Object clone() {
        Panel clone = (Panel)super.clone();
        clone.afterUnmarshal();
        return clone;
    }

    private void afterUnmarshal() {
        if (this._caption != null) {
            this._caption = (Caption)((Object)this.getChildren().get(this._caption.getParent().getChildren().indexOf((Object)this._caption)));
        }
        if (this._tbar != null) {
            this._tbar = (Toolbar)((Object)this.getChildren().get(this._tbar.getParent().getChildren().indexOf((Object)this._tbar)));
        }
        if (this._panelchildren != null) {
            this._panelchildren = (Panelchildren)((Object)this.getChildren().get(this._panelchildren.getParent().getChildren().indexOf((Object)this._panelchildren)));
        }
        if (this._bbar != null) {
            this._bbar = (Toolbar)((Object)this.getChildren().get(this._bbar.getParent().getChildren().indexOf((Object)this._bbar)));
        }
        if (this._fbar != null) {
            this._fbar = (Toolbar)((Object)this.getChildren().get(this._fbar.getParent().getChildren().indexOf((Object)this._fbar)));
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._title.length() > 0) {
            this.render(renderer, "title", this._title);
        }
        this.render(renderer, "closable", this._closable);
        this.render(renderer, "floatable", this._floatable);
        this.render(renderer, "collapsible", this._collapsible);
        this.render(renderer, "movable", this._movable);
        this.render(renderer, "maximizable", this._maximizable);
        this.render(renderer, "minimizable", this._minimizable);
        this.render(renderer, "maximized", this._maximized);
        this.render(renderer, "minimized", this._minimized);
        this.render(renderer, "sizable", this._sizable);
        if (this._minheight != 100) {
            renderer.render("minheight", this._minheight);
        }
        if (this._minwidth != 200) {
            renderer.render("minwidth", this._minwidth);
        }
        if (!this._open) {
            renderer.render("open", false);
        }
        if (!"none".equals(this._border)) {
            renderer.render("border", this._border);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onMaximize")) {
            MaximizeEvent evt = MaximizeEvent.getMaximizeEvent((AuRequest)request);
            this.setLeftDirectly(evt.getLeft());
            this.setTopDirectly(evt.getTop());
            this.setWidthDirectly(evt.getWidth());
            this.setHeightDirectly(evt.getHeight());
            this._maximized = evt.isMaximized();
            if (this._maximized) {
                this.setVisibleDirectly(true);
            }
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onMinimize")) {
            MinimizeEvent evt = MinimizeEvent.getMinimizeEvent((AuRequest)request);
            this.setLeftDirectly(evt.getLeft());
            this.setTopDirectly(evt.getTop());
            this.setWidthDirectly(evt.getWidth());
            this.setHeightDirectly(evt.getHeight());
            this._minimized = evt.isMinimized();
            if (this._minimized) {
                this.setVisibleDirectly(false);
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Panel.addClientEvent(Panel.class, (String)"onClose", (int)0);
        Panel.addClientEvent(Panel.class, (String)"onMove", (int)8193);
        Panel.addClientEvent(Panel.class, (String)"onSize", (int)8193);
        Panel.addClientEvent(Panel.class, (String)"onOpen", (int)1);
        Panel.addClientEvent(Panel.class, (String)"onZIndex", (int)8193);
        Panel.addClientEvent(Panel.class, (String)"onMaximize", (int)8193);
        Panel.addClientEvent(Panel.class, (String)"onMinimize", (int)8193);
    }
}

