/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.zkoss.util.Dates;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.mesg.MZul;

public class SimpleDateConstraint
extends SimpleConstraint {
    private Date _beg;
    private Date _end;
    private static final ThreadLocal<SimpleDateFormat> _df = new ThreadLocal();

    public SimpleDateConstraint(int flags) {
        super(flags);
        this.fixConstraint();
    }

    public SimpleDateConstraint(int flags, String errmsg) {
        super(flags, errmsg);
        this.fixConstraint();
    }

    public SimpleDateConstraint(String regex, String errmsg) {
        super(regex, errmsg);
        this.fixConstraint();
    }

    public SimpleDateConstraint(int flags, String regex, String errmsg) {
        super(flags, regex, errmsg);
        this.fixConstraint();
    }

    public SimpleDateConstraint(int flags, Date begin, Date end, String errmsg) {
        super(flags, errmsg);
        this._beg = begin;
        this._end = end;
        this.fixConstraint();
    }

    public SimpleDateConstraint(String constraint) {
        super(constraint);
        this.fixConstraint();
    }

    private void fixConstraint() {
        if ((this._flags & 1) != 0 && this._end == null) {
            this._end = Dates.today();
        }
        if ((this._flags & 2) != 0 && this._beg == null) {
            this._beg = Dates.today();
        }
    }

    public Date getBeginDate() {
        return this._beg;
    }

    public Date getEndDate() {
        return this._end;
    }

    protected int parseConstraint(String constraint) throws UiException {
        if (constraint.startsWith("between")) {
            int j = constraint.indexOf("and", 7);
            if (j < 0) {
                throw new UiException("Constraint syntax error: " + constraint);
            }
            this._beg = SimpleDateConstraint.parseDate(constraint.substring(7, j));
            this._end = SimpleDateConstraint.parseDate(constraint.substring(j + 3));
            if (this._beg.compareTo(this._end) > 0) {
                Date d = this._beg;
                this._beg = this._end;
                this._end = d;
            }
            return 0;
        }
        if (constraint.startsWith("before")) {
            this._end = SimpleDateConstraint.parseDate(constraint.substring(6));
            return 0;
        }
        if (constraint.startsWith("after")) {
            this._beg = SimpleDateConstraint.parseDate(constraint.substring(5));
            return 0;
        }
        return super.parseConstraint(constraint);
    }

    private static Date parseDate(String val) throws UiException {
        try {
            return SimpleDateConstraint.getDateFormat().parse(val.trim());
        }
        catch (ParseException ex) {
            throw new UiException("Not a date: " + val + ". Format: yyyyMMdd", (Throwable)ex);
        }
    }

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = _df.get();
        if (df == null) {
            df = new SimpleDateFormat("yyyyMMdd");
            _df.set(df);
        }
        df.setTimeZone(TimeZones.getCurrent());
        return df;
    }

    public void validate(Component comp, Object value) throws WrongValueException {
        if (value instanceof Date) {
            Date d = Dates.beginOfDate((Date)((Date)value), (TimeZone)TimeZones.getCurrent());
            if (this._beg != null && this._beg.compareTo(d) > 0) {
                throw this.outOfRangeValue(comp);
            }
            if (this._end != null && this._end.compareTo(d) < 0) {
                throw this.outOfRangeValue(comp);
            }
        }
        super.validate(comp, value);
    }

    private WrongValueException outOfRangeValue(Component comp) {
        String errmsg = this.getErrorMessage(comp);
        if (errmsg != null) {
            return new WrongValueException(comp, errmsg);
        }
        String s = this._beg != null ? (this._end != null ? SimpleDateConstraint.dateToString(comp, this._beg) + " ~ " + SimpleDateConstraint.dateToString(comp, this._end) : ">= " + SimpleDateConstraint.dateToString(comp, this._beg)) : "<= " + SimpleDateConstraint.dateToString(comp, this._end);
        return new WrongValueException(comp, MZul.OUT_OF_RANGE, (Object)s);
    }

    private static String dateToString(Component comp, Date d) {
        if (d == null) {
            return "";
        }
        if (comp instanceof Datebox) {
            return ((Datebox)comp).coerceToString(d);
        }
        return SimpleDateConstraint.getDateFormat().format(d);
    }
}

