/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Arrays;
import java.util.Comparator;
import org.zkoss.zul.AbstractGroupsModel;
import org.zkoss.zul.GroupsModelExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGroupsModel<D, H, F>
extends AbstractGroupsModel<D, Object, F>
implements GroupsModelExt<D> {
    protected D[][] _data;
    protected H[] _heads;
    protected F[] _foots;
    protected boolean[] _closes;

    public SimpleGroupsModel(D[][] data) {
        this(data, null, null);
    }

    public SimpleGroupsModel(D[][] data, H[] heads) {
        this(data, heads, null);
    }

    public SimpleGroupsModel(D[][] data, H[] heads, F[] foots) {
        if (data == null) {
            throw new NullPointerException();
        }
        this._data = data;
        this._heads = heads;
        this._foots = foots;
    }

    public SimpleGroupsModel(D[][] data, H[] heads, F[] foots, boolean[] closes) {
        if (data == null) {
            throw new NullPointerException();
        }
        this._data = data;
        this._heads = heads;
        this._foots = foots;
        this._closes = closes;
    }

    @Override
    public D getChild(int groupIndex, int index) {
        return this._data[groupIndex][index];
    }

    @Override
    public int getChildCount(int groupIndex) {
        return this._data[groupIndex].length;
    }

    @Override
    public Object getGroup(int groupIndex) {
        return this._heads == null ? this._data[groupIndex] : this._heads[groupIndex];
    }

    @Override
    public int getGroupCount() {
        return this._data.length;
    }

    @Override
    public F getGroupfoot(int groupIndex) {
        return this._foots == null ? null : (F)this._foots[groupIndex];
    }

    @Override
    public boolean hasGroupfoot(int groupIndex) {
        return this._foots == null ? false : this._foots[groupIndex] != null;
    }

    @Override
    public boolean isClose(int groupIndex) {
        return this._closes == null ? false : this._closes[groupIndex];
    }

    @Override
    public void setClose(int groupIndex, boolean close) {
        if (this._closes == null) {
            this._closes = new boolean[this.getGroupCount()];
        }
        if (this._closes[groupIndex] != close) {
            this._closes[groupIndex] = close;
            this.fireEvent(4, groupIndex, -1, -1);
        }
    }

    @Override
    public void group(Comparator<D> cmpr, boolean ascending, int colIndex) {
    }

    @Override
    public void sort(Comparator<D> cmpr, boolean ascending, int colIndex) {
        for (int i = 0; i < this._data.length; ++i) {
            this.sortGroupData(this._heads == null ? this._data[i] : this._heads[i], this._data[i], cmpr, ascending, colIndex);
        }
        this.fireEvent(3, -1, -1, -1);
    }

    protected void sortGroupData(Object group, D[] groupdata, Comparator<D> cmpr, boolean ascending, int colIndex) {
        Arrays.sort(groupdata, cmpr);
    }
}

