/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.impl.XulElement;

public class Tabs
extends XulElement {
    private String _align = "start";

    public Tabbox getTabbox() {
        return (Tabbox)this.getParent();
    }

    public String getWidth() {
        String width = super.getWidth();
        Tabbox tabbox = this.getTabbox();
        if (width == null && tabbox != null && tabbox.isVertical()) {
            width = "50px";
        }
        return width;
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) throws WrongValueException {
        if (!("start".equals(align) || "center".equals(align) || "end".equals(align))) {
            throw new WrongValueException(align);
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public void invalidate() {
        Tabbox tbox = this.getTabbox();
        if (tbox != null && tbox.isVertical()) {
            tbox.invalidate();
        } else {
            super.invalidate();
        }
    }

    public String getZclass() {
        if (this._zclass != null) {
            return this._zclass;
        }
        Tabbox tabbox = this.getTabbox();
        String added = tabbox != null && tabbox.isVertical() ? "-ver" : "";
        return "z-tabs" + added;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Tabbox)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Tab)) {
            throw new UiException("Unsupported child for tabs: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        boolean sel = this.getChildren().isEmpty();
        boolean desel = false;
        Tab newtab = (Tab)child;
        if (!sel && newtab.isSelected()) {
            newtab.setSelectedDirectly(false);
            desel = true;
            sel = true;
        }
        if (super.insertBefore(child, refChild)) {
            Tabbox tabbox = this.getTabbox();
            if (sel) {
                if (tabbox != null) {
                    tabbox.setSelectedTab(newtab);
                } else {
                    newtab.setSelectedDirectly(true);
                    if (desel) {
                        for (Tab tab : this.getChildren()) {
                            if (tab == newtab || !tab.isSelected()) continue;
                            tab.setSelectedDirectly(false);
                            break;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        Tabbox tabbox = this.getTabbox();
        if (tabbox != null) {
            ((Tab)child).removeEventListener("onSelect", tabbox._listener);
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        Tabbox tabbox = this.getTabbox();
        if (tabbox != null) {
            ((Tab)child).addEventListener("onSelect", tabbox._listener);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"start".equals(this._align)) {
            this.render(renderer, "align", this._align);
        }
    }
}

