/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.zul.AbstractChartModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaferMapModel
extends AbstractChartModel {
    private static final long serialVersionUID = 20091008182524L;
    private int _xsize = 100;
    private int _ysize = 100;
    private double _space = 1.0;
    private Map<IntPair, Number> _values;

    public WaferMapModel() {
    }

    public WaferMapModel(int xsize, int ysize) {
        this(xsize, ysize, 1.0);
    }

    public WaferMapModel(int xsize, int ysize, double space) {
        this._xsize = xsize;
        this._ysize = ysize;
        this._space = space;
    }

    public int getXsize() {
        return this._xsize;
    }

    public int getYsize() {
        return this._ysize;
    }

    public void setXsize(int xsize) {
        if (xsize != this._xsize) {
            this._xsize = xsize;
            this.fireEvent(0, null, null);
        }
    }

    public void setYsize(int ysize) {
        if (ysize != this._ysize) {
            this._ysize = ysize;
            this.fireEvent(0, null, null);
        }
    }

    public double getSpace() {
        return this._space;
    }

    public Number getValue(int x, int y) {
        if (this._values != null) {
            return this._values.get(new IntPair(x, y));
        }
        return null;
    }

    public void addValue(int value, int x, int y) {
        if (x >= this._xsize) {
            throw new IndexOutOfBoundsException("x size: " + this._xsize + ", x: " + x);
        }
        if (y >= this._ysize) {
            throw new IndexOutOfBoundsException("y size: " + this._ysize + ", y: " + y);
        }
        if (this._values == null) {
            this._values = new HashMap<IntPair, Number>();
        }
        this._values.put(new IntPair(x, y), new Integer(value));
        this.fireEvent(0, null, null);
    }

    public Collection<Map.Entry<IntPair, Number>> getEntrySet() {
        if (this._values != null) {
            return this._values.entrySet();
        }
        return Collections.emptySet();
    }

    public void removeValue(int x, int y) {
        Number old;
        if (this._values != null && (old = this._values.remove(new IntPair(x, y))) != null) {
            this.fireEvent(2, null, null);
        }
    }

    public void clear() {
        if (this._values != null && !this._values.isEmpty()) {
            this._values.clear();
            this.fireEvent(2, null, null);
        }
    }

    public static class IntPair
    implements Serializable {
        private static final long serialVersionUID = 20091008182635L;
        private int _x;
        private int _y;

        private IntPair(int x, int y) {
            this._x = x;
            this._y = y;
        }

        public int getX() {
            return this._x;
        }

        public int getY() {
            return this._y;
        }

        public int hashCode() {
            return this._x ^ this._y;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntPair)) {
                return false;
            }
            IntPair o = (IntPair)other;
            return o._x == this._x && o._y == this._y;
        }
    }
}

