/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.portlet;

import java.io.BufferedReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.zkoss.util.CollectionsX;
import org.zkoss.web.portlet.PortletHttpSession;

public class RenderHttpServletRequest
implements HttpServletRequest {
    private final RenderRequest _req;
    private final HttpServletRequest _hreq;
    private String _enc = "UTF-8";
    private final Map<String, String> _attrs = new HashMap<String, String>(8);

    public static HttpServletRequest getInstance(RenderRequest req) {
        if (req instanceof HttpServletRequest) {
            return (HttpServletRequest)req;
        }
        return new RenderHttpServletRequest(req);
    }

    private RenderHttpServletRequest(RenderRequest req) {
        if (req == null) {
            throw new IllegalArgumentException("null");
        }
        this._req = req;
        this._hreq = this.getHttpServletRequest(req);
        String ctxpath = req.getContextPath();
        if (ctxpath == null) {
            ctxpath = "";
        }
        this._attrs.put("javax.servlet.include.context_path", ctxpath);
        this._attrs.put("javax.servlet.include.servlet_path", "");
        this._attrs.put("javax.servlet.include.path_info", "");
        this._attrs.put("javax.servlet.include.query_string", "");
        this._attrs.put("javax.servlet.include.request_uri", ctxpath);
    }

    protected HttpServletRequest getHttpServletRequest(RenderRequest req) {
        try {
            Method m;
            try {
                m = req.getClass().getMethod("getHttpServletRequest", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                m = req.getClass().getMethod("getRequest", new Class[0]);
            }
            return (HttpServletRequest)m.invoke((Object)req, new Object[0]);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public Object getAttribute(String name) {
        String val = this._attrs.get(name);
        return val != null ? val : this._req.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        final Enumeration _e = this._req.getAttributeNames();
        final Iterator<String> _it = this._attrs.keySet().iterator();
        return new Enumeration(){
            Object _next;
            {
                this.next();
            }

            public boolean hasMoreElements() {
                return this._next != null;
            }

            public Object nextElement() {
                Object next = this._next;
                this.next();
                return next;
            }

            private void next() {
                this._next = null;
                while (_e.hasMoreElements()) {
                    Object next = _e.nextElement();
                    if (RenderHttpServletRequest.this._attrs.containsKey(next)) continue;
                    this._next = next;
                    return;
                }
                if (_it.hasNext()) {
                    this._next = _it.next();
                }
            }
        };
    }

    public RenderRequest getRenderRequest() {
        return this._req;
    }

    public String getCharacterEncoding() {
        return this._enc;
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        String ct = this._req.getResponseContentType();
        return ct != null ? ct : "text/html";
    }

    public ServletInputStream getInputStream() {
        return new ServletInputStream(){

            public int read() {
                return -1;
            }
        };
    }

    public String getLocalAddr() {
        return this._hreq != null ? this._hreq.getLocalAddr() : "";
    }

    public Locale getLocale() {
        return this._req.getLocale();
    }

    public Enumeration getLocales() {
        return this._req.getLocales();
    }

    public String getLocalName() {
        return this._hreq != null ? this._hreq.getLocalName() : "";
    }

    public int getLocalPort() {
        return this._hreq != null ? this._hreq.getLocalPort() : -1;
    }

    public String getParameter(String name) {
        return this._req.getParameter(name);
    }

    public Map getParameterMap() {
        return this._req.getParameterMap();
    }

    public Enumeration getParameterNames() {
        return this._req.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this._req.getParameterValues(name);
    }

    public String getProtocol() {
        return "HTTP/1.0";
    }

    public BufferedReader getReader() {
        return new BufferedReader(new StringReader(""));
    }

    public String getRealPath(String path) {
        return this._hreq != null ? this._hreq.getRealPath(path) : null;
    }

    public String getRemoteAddr() {
        return this._hreq != null ? this._hreq.getRemoteAddr() : "";
    }

    public String getRemoteHost() {
        return this._hreq != null ? this._hreq.getRemoteHost() : "";
    }

    public int getRemotePort() {
        return this._hreq != null ? this._hreq.getRemotePort() : -1;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this._hreq != null ? this._hreq.getRequestDispatcher(path) : null;
    }

    public String getScheme() {
        return this._req.getScheme();
    }

    public String getServerName() {
        return this._req.getServerName();
    }

    public int getServerPort() {
        return this._req.getServerPort();
    }

    public boolean isSecure() {
        return this._req.isSecure();
    }

    public void removeAttribute(String name) {
        this._req.removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        this._req.setAttribute(name, o);
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        byte[] buffer = new byte[]{97};
        String dummy = new String(buffer, enc);
        this._enc = enc;
    }

    public String getAuthType() {
        return this._req.getAuthType();
    }

    public String getContextPath() {
        return this._attrs.get("javax.servlet.include.context_path");
    }

    public Cookie[] getCookies() {
        return this._hreq != null ? this._hreq.getCookies() : new Cookie[]{};
    }

    public long getDateHeader(String name) {
        return this._hreq != null ? this._hreq.getDateHeader(name) : -1L;
    }

    public String getHeader(String name) {
        return this._hreq != null ? this._hreq.getHeader(name) : null;
    }

    public Enumeration getHeaderNames() {
        return this._hreq != null ? this._hreq.getHeaderNames() : CollectionsX.EMPTY_ENUMERATION;
    }

    public Enumeration getHeaders(String name) {
        return this._hreq != null ? this._hreq.getHeaders(name) : CollectionsX.EMPTY_ENUMERATION;
    }

    public int getIntHeader(String name) {
        return this._hreq != null ? this._hreq.getIntHeader(name) : -1;
    }

    public String getMethod() {
        return this._hreq != null ? this._hreq.getMethod() : "GET";
    }

    public String getPathInfo() {
        return this._hreq != null ? this._hreq.getPathInfo() : this._attrs.get("javax.servlet.include.path_info");
    }

    public String getPathTranslated() {
        return this._hreq != null ? this._hreq.getPathTranslated() : null;
    }

    public String getQueryString() {
        return this._hreq != null ? this._hreq.getQueryString() : this._attrs.get("javax.servlet.include.query_string");
    }

    public String getRemoteUser() {
        return this._req.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this._req.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this._hreq != null ? this._hreq.getRequestURI() : this._attrs.get("javax.servlet.include.request_uri");
    }

    public StringBuffer getRequestURL() {
        return this._hreq != null ? this._hreq.getRequestURL() : new StringBuffer();
    }

    public String getServletPath() {
        return this._hreq != null ? this._hreq.getServletPath() : this._attrs.get("javax.servlet.include.servlet_path");
    }

    public HttpSession getSession() {
        return PortletHttpSession.getInstance(this._req.getPortletSession());
    }

    public HttpSession getSession(boolean create) {
        PortletSession sess = this._req.getPortletSession(create);
        return sess != null ? PortletHttpSession.getInstance(sess) : null;
    }

    public Principal getUserPrincipal() {
        return this._req.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return this._req.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String role) {
        return this._req.isUserInRole(role);
    }

    public int hashCode() {
        return this._req.hashCode();
    }

    public boolean equals(Object o) {
        RenderRequest val = o instanceof RenderRequest ? (RenderRequest)o : (o instanceof RenderHttpServletRequest ? ((RenderHttpServletRequest)o)._req : null);
        return val != null && val.equals(this._req);
    }
}

