
window.FCKeditor_OnComplete = function (fed) {
	fed.ResetIsDirty();
		//Bug 1876996: FCKeditor 2.5 and 2.5.1 doesn't reset it correctly

	fed.Events.AttachEvent("OnBlur", fckez.FCKeditor.onBlur);
	fed.Events.AttachEvent("OnSave", fckez.FCKeditor.onSave);
	fed.Events.AttachEvent("OnSelectionChange", fckez.FCKeditor.onSelection);
	if (window.FCKed_OnComplete)
		window.FCKed_OnComplete(fed);
};

fckez.FCKeditor = zk.$extends(zul.Widget, {
	_width: '100%',
	_height: '200px',
	_value: '',
	$define: {
		value: [function (v) {
			return !v ? '' : v;
		}, function (v) {
			var ed = this.getEditor();
			if (ed)
				ed.SetHTML(v);
		}],
		autoHeight: null,
		customConfigurationsPath: _zkf = function () {
			if (this.desktop)
				this.rerender();
		},
		toolbarset: _zkf,
		width: function (v) {
			var f = this.getFrame();
			if (f)
				f.style.width = f.width = v;
		},
		height: function (v) {
			var f = this.getFrame();
			if (f)
				f.style.height = f.height = v;
		}
	},
	getFrame: function () {
		return this.$n('ed___Frame');
	},
	getEditor: function () {
		return window.FCKeditorAPI ? FCKeditorAPI.GetInstance(this.uuid + "-ed") : null;
	},
	redraw: function (out) {

		FCKeditorAPI = null;
		//Note: we have to clean up, because iframe (FCKeditor lives)
		//might be dropped and another instance might be created

		//Bug 1734809: we cannot switch iframe's src, since BACK will cause problem
		var instid = this.uuid + '-ed',
			html = '<input type="hidden" id="' + instid
				+ '" name="' + instid + '" value="';
		if (this._value)
			html += zUtl.encodeXML(this._value);

		html += '"/><input type="hidden" id="' + instid + '___Config" value="';
		if (this._customConfigurationsPath)
			html += 'CustomConfigurationsPath=' + this._customConfigurationsPath;
		var s = '/web/js/fckez/ext/FCKeditor/editor/fckeditor.html?InstanceName='
			+ instid + (this._toolbarset ? '&amp;Toolbar=' + this._toolbarset: '');
		html += '"/>\n<iframe id="' + instid + '___Frame" src="'
			+ zk.ajaxURI(s, {desktop:this.desktop,au:true}) +'"';
		if (this._width) html  += ' width="' + this._width + '"';
		if (this._height) html  += ' height="' + this._height + '"';
		html += ' frameborder="0" scrolling="no">\n</iframe>';
		out.push('<div', this.domAttrs_({domStyle: true}), '>', html, '</div>');
	},
	
	domAttrs_: function (no) {
		var attr = this.$supers('domAttrs_', arguments);
		if (!this.isVisible() && (!no || !no.visible))
			attr += ' style="display:none;"';
		return attr;
	},
	
	bind_: function () {		
		this.$supers('bind_', arguments);
		zWatch.listen({onSend: this});
	},
	unbind_: function () {		
		zWatch.unlisten({onSend: this});
		this.$supers('unbind_', arguments);
	},
	onSend: function (ctrl) {
		var implicit = ctrl.args[1];
		//don't send back if implicit (such as onTimer)
		if (!implicit && FCKeditorAPI) {
			var fed = this.getEditor();
			if (fed && fed.EditorDocument)
				this.$class.onBlur(fed, true);
				//It is possible that EditorDocument is not initialized yet
		}
	}
}, {
	onBlur: function(fed, ahead) {
		if (fed.IsDirty()) {
			var wgt = zk.Widget.$(fed.Name),
				val = fed.GetXHTML();
			wgt.fire('onChange', {value: val}, {sendAhead: ahead});
			fed.ResetIsDirty();
		}
	},
	onSave: function(fed, ahead) {
		var wgt = zk.Widget.$(fed.Name),
			val = fed.GetXHTML();
		wgt.fire('onChange', {value: val});
		wgt.fire('onSave', {value: val});
	},
	onSelection: function(fed) {
		var wgt = zk.Widget.$(fed.Name);
		if (!zk(wgt).isRealVisible)
			return;

		var inner = wgt.$n('ed___Frame'),//jq('#' + wgt.uuid + "-ed___Frame")[0],
			selection = fed.EditorDocument.selection ? fed.EditorDocument.selection.createRange().text : fed.EditorWindow.getSelection().toString();

		// ignore wrong selection for IE
		if (zk.ie && wgt.zselection === String.fromCharCode(65279) || selection === String.fromCharCode(65279))
			return;
		fed.zselection = selection;
		if (wgt.isListen("onSelection")) {
			if (wgt.zselection || fed.zselection) {
				if (wgt.zselection != fed.zselection) {
					wgt.zselection = fed.zselection;
					wgt.fire('onSelection', {
						start: 0,
						end: 0,
						selected: fed.zselection
					});
				}
			}
		}
		if (wgt._autoHeight) {
			var iframe = fed.EditingArea.IFrame,
				body = iframe.contentDocument ? iframe.contentDocument.body
							: iframe.contentWindow.document.body;
			if (!wgt._hgh)
				wgt._hgh = inner.offsetHeight - iframe.offsetHeight;
			if (wgt._now && wgt._now > zUtl.now())
				return;

			wgt._now = zUtl.now() + 100;
			if (body.scrollHeight + wgt._hgh > inner.offsetHeight) {
				setTimeout(function() {
					if (body.scrollHeight + wgt._hgh > inner.offsetHeight)
						inner.style.height = body.scrollHeight + wgt._hgh + "px";

				}, 100);
			} else {
				var hgh = zk.parseInt(wgt.getHeight()), offHgh = zk.ie ? body.scrollHeight : body.offsetHeight;

				setTimeout(function() {
					if (offHgh + wgt._hgh > hgh)
						hgh = offHgh + wgt._hgh;
					if (inner.style.height != hgh + "px") {
						inner.style.height = hgh + "px";
					}
				}, 100);
			}
		}
	}
});