/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import java.util.HashMap;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.image.Image;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Gimage
extends XulElement
implements Mapitem {
    private static final long serialVersionUID = 200801071632L;
    protected double _swlat = 37.4419;
    protected double _swlng = -122.1419;
    protected double _nelat = 37.4419;
    protected double _nelng = -122.1419;
    private String _src;
    private Image _image;
    private int _imgver;

    public Gimage() {
    }

    public Gimage(String src, double swlat, double swlng, double nelat, double nelng) {
        this.setSrc(src);
        this.setSwlat(swlat);
        this.setSwlng(swlng);
        this.setNelat(nelat);
        this.setNelng(nelng);
    }

    public double getSwlat() {
        return this._swlat;
    }

    public void setSwlat(double swlat) {
        if (this._swlat != swlat) {
            this._swlat = swlat;
            this.smartRerender();
        }
    }

    public double getSwlng() {
        return this._swlng;
    }

    public void setSwlng(double swlng) {
        if (this._swlng != swlng) {
            this._swlng = swlng;
            this.smartRerender();
        }
    }

    public double getNelat() {
        return this._nelat;
    }

    public void setNelat(double nelat) {
        if (this._nelat != nelat) {
            this._nelat = nelat;
            this.smartRerender();
        }
    }

    public double getNelng() {
        return this._nelng;
    }

    public void setNelng(double nelng) {
        if (this._nelng != nelng) {
            this._nelng = nelng;
            this.smartRerender();
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._image != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._image = null;
            this.smartRerender();
        }
    }

    public void setContent(Image image) {
        if (image != this._image) {
            this._image = image;
            if (this._image != null) {
                ++this._imgver;
            }
            this.smartRerender();
        }
    }

    public Image getContent() {
        return this._image;
    }

    public boolean isChildable() {
        return false;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "src", this.getEncodedURL());
        this.render(renderer, "swlat", new Double(this.getSwlat()));
        this.render(renderer, "swlng", new Double(this.getSwlng()));
        this.render(renderer, "nelat", new Double(this.getNelat()));
        this.render(renderer, "nelng", new Double(this.getNelng()));
    }

    private String getEncodedURL() {
        if (this._image != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, (int)this._imgver, (String)("c/" + this._image.getName()), (String)this._image.getFormat());
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(this._src != null ? this._src : "~./img/spacer.gif") : "";
    }

    private void smartRerender() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("src", new EncodedURL());
        info.put("swlat", new Double(this._swlat));
        info.put("swlng", new Double(this._swlng));
        info.put("nelat", new Double(this._nelat));
        info.put("nelng", new Double(this._nelng));
        this.smartUpdate("rerender_", info);
    }

    private class EncodedURL
    implements DeferredValue {
        private EncodedURL() {
        }

        public Object getValue() {
            return Gimage.this.getEncodedURL();
        }
    }
}

