/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import org.zkoss.gmaps.Gmaps;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Ginfo
extends XulElement
implements Mapitem {
    private static final long serialVersionUID = 200807041526L;
    protected double _lat = 37.4419;
    protected double _lng = -122.1419;
    private String _content = "";
    private boolean _open = false;

    public Ginfo() {
    }

    public Ginfo(String content) {
        this.setContent(content);
    }

    public Ginfo(String content, double lat, double lng) {
        this.setContent(content);
        this.setAnchor(lat, lng);
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content == null) {
            content = "";
        }
        if (!Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this.smartUpdate("content", this._content);
        }
    }

    public void setAnchor(double lat, double lng) {
        boolean update = false;
        if (lat != this._lat) {
            this._lat = lat;
            update = true;
        }
        if (lng != this._lng) {
            this._lng = lng;
            update = true;
        }
        if (update) {
            this.smartUpdate("anchor", this.getAnchor());
        }
    }

    public void setLat(double lat) {
        if (lat != this._lat) {
            this._lat = lat;
            this.smartUpdate("anchor", this.getAnchor());
        }
    }

    public double getLat() {
        return this._lat;
    }

    public void setLng(double lng) {
        if (lng != this._lng) {
            this._lng = lng;
            this.smartUpdate("anchor", this.getAnchor());
        }
    }

    public double getLng() {
        return this._lng;
    }

    public void setOpen(boolean b) {
        Gmaps gmaps = (Gmaps)this.getParent();
        if (gmaps != null) {
            if (b) {
                gmaps.openInfo(this);
            } else if (gmaps.getInfo() == this) {
                gmaps.closeInfo();
            }
        }
        this._open = b;
    }

    void setOpenByClient(boolean b) {
        this._open = b;
    }

    public boolean isOpen() {
        Gmaps gmaps = (Gmaps)this.getParent();
        return gmaps != null && gmaps.getInfo() == this || this._open;
    }

    private double[] getAnchor() {
        return new double[]{this._lat, this._lng};
    }

    boolean isGinfo() {
        return true;
    }

    public boolean isChildable() {
        return false;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Gmaps)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "anchor", this.getAnchor());
        this.render(renderer, "content", this.getContent());
        this.render(renderer, "open", this._open);
    }
}

