/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.gmaps.Gpolyline;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;

public class Gpolygon
extends Gpolyline {
    private static final long serialVersionUID = 200807091638L;
    private boolean _outline = true;
    private boolean _fill = true;
    private String _fillColor = "#808080";
    private int _fillOpacity = 50;

    public boolean isOutline() {
        return this._outline;
    }

    public void setOutline(boolean b) {
        if (this._outline != b) {
            this._outline = b;
            this.smartRerender();
        }
    }

    public boolean isFill() {
        return this._fill;
    }

    public void setFill(boolean b) {
        if (this._fill != b) {
            this._fill = b;
            this.smartRerender();
        }
    }

    public String getFillColor() {
        return this._fillColor;
    }

    public void setFillColor(String color) {
        if (color == null) {
            color = "#808080";
        }
        if (!color.equals(this._fillColor)) {
            this._fillColor = color;
            this.smartRerender();
        }
    }

    public int getFillOpacity() {
        return this._fillOpacity;
    }

    public void setFillOpacity(int op) {
        if (op < 0 || op > 100) {
            throw new UiException("Fill opacity must be between 0 to 100 (inclusive): " + op);
        }
        if (this._fillOpacity != op) {
            this._fillOpacity = op;
            this.smartRerender();
        }
    }

    public String getEncodedPolyline() {
        if (this._encodedPolyline == null) {
            int lat = 0;
            int lng = 0;
            StringBuffer sb = new StringBuffer(this._points.size() * 4);
            int lat0 = 0;
            int lng0 = 0;
            int j = 0;
            Iterator it = this._points.iterator();
            while (it.hasNext()) {
                Gpolyline.Tuple tuple = (Gpolyline.Tuple)it.next();
                int tlat = this.e5(tuple.lat);
                int tlng = this.e5(tuple.lng);
                if (j == 0) {
                    lat0 = tlat;
                    lng0 = tlng;
                }
                sb.append(Gpolygon.encodeLatLng(tlat - lat)).append(Gpolygon.encodeLatLng(tlng - lng));
                lat = tlat;
                lng = tlng;
                ++j;
            }
            if (j > 0 && (lat != lat0 || lng != lng0)) {
                sb.append(Gpolygon.encodeLatLng(lat0 - lat)).append(Gpolygon.encodeLatLng(lng0 - lng));
            }
            this._encodedPolyline = j == 0 ? "??" : sb.toString();
        }
        return this._encodedPolyline;
    }

    public String getEncodedLevels() {
        if (this._encodedLevels == null) {
            StringBuffer sb = new StringBuffer(this._points.size() * 2);
            int lat0 = 0;
            int lng0 = 0;
            int lvl0 = 0;
            int lat = 0;
            int lng = 0;
            int j = 0;
            Iterator it = this._points.iterator();
            while (it.hasNext()) {
                Gpolyline.Tuple tuple = (Gpolyline.Tuple)it.next();
                int tlat = this.e5(tuple.lat);
                int tlng = this.e5(tuple.lng);
                if (j == 0) {
                    lat0 = tlat;
                    lng0 = tlng;
                    lvl0 = tuple.level;
                }
                sb.append(Gpolygon.encodeInt(tuple.level));
                lat = tlat;
                lng = tlng;
                ++j;
            }
            if (j > 0 && (lat != lat0 || lng != lng0)) {
                sb.append(Gpolygon.encodeInt(lvl0));
            }
            this._encodedLevels = j == 0 ? "?" : sb.toString();
        }
        return this._encodedLevels;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "fill", this.isFill());
        this.render(renderer, "outline", this.isOutline());
        this.render(renderer, "fillColor", this.getFillColor());
        this.render(renderer, "fillOpacity", new Double((double)this.getFillOpacity() / 100.0));
    }

    protected void prepareRerender(Map info) {
        super.prepareRerender(info);
        info.put("fill", this.isFill());
        info.put("outline", this.isOutline());
        info.put("fillColor", this.getFillColor());
        info.put("fillOpacity", new Double((double)this.getFillOpacity() / 100.0));
    }
}

