/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import java.util.HashMap;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.image.Image;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Gscreen
extends XulElement
implements Mapitem {
    private static final long serialVersionUID = 200807021855L;
    protected String _screenX = "0";
    protected String _screenY = "0";
    protected String _offsetX = "0";
    protected String _offsetY = "0";
    protected String _width = "50";
    protected String _height = "50";
    private String _src;
    private Image _image;
    private int _imgver;

    public Gscreen() {
    }

    public Gscreen(String src, String screenX, String screenY, String offsetX, String offsetY, String width, String height) {
        this.setSrc(src);
        this.setScreenX(screenX);
        this.setScreenY(screenY);
        this.setOffsetX(offsetX);
        this.setOffsetY(offsetY);
        this.setWidth(width);
        this.setHeight(height);
    }

    public String getScreenX() {
        if (this._screenX == null) {
            throw new NullPointerException("screenX");
        }
        return this._screenX;
    }

    public void setScreenX(String screenX) {
        if (screenX == null) {
            throw new NullPointerException("screenX");
        }
        if (!Objects.equals((Object)(screenX = screenX.trim()), (Object)this._screenX)) {
            this.validate(screenX, "screenX");
            this._screenX = screenX;
            this.smartRerender();
        }
    }

    public String getScreenY() {
        if (this._screenY == null) {
            throw new NullPointerException("screenY");
        }
        return this._screenY;
    }

    public void setScreenY(String screenY) {
        if (screenY == null) {
            throw new NullPointerException("screenY");
        }
        if (!Objects.equals((Object)(screenY = screenY.trim()), (Object)this._screenY)) {
            this.validate(screenY, "screenY");
            this._screenY = screenY;
            this.smartRerender();
        }
    }

    public String getOffsetX() {
        if (this._offsetX == null) {
            throw new NullPointerException("offsetX");
        }
        return this._offsetX;
    }

    public void setOffsetX(String offsetX) {
        if (offsetX == null) {
            throw new NullPointerException("offsetX");
        }
        if (!Objects.equals((Object)(offsetX = offsetX.trim()), (Object)this._offsetX)) {
            this.validate(offsetX, "offsetX");
            this._offsetX = offsetX;
            this.smartRerender();
        }
    }

    public String getOffsetY() {
        if (this._offsetY == null) {
            throw new NullPointerException("offsetY");
        }
        return this._offsetY;
    }

    public void setOffsetY(String offsetY) {
        if (offsetY == null) {
            throw new NullPointerException("offsetY");
        }
        if (!Objects.equals((Object)(offsetY = offsetY.trim()), (Object)this._offsetY)) {
            this.validate(offsetY, "offsetY");
            this._offsetY = offsetY;
            this.smartRerender();
        }
    }

    public void setWidth(String width) {
        if (width == null) {
            throw new NullPointerException("width");
        }
        if (!Objects.equals((Object)(width = width.trim()), (Object)this._width)) {
            this.validate(width, "width");
            this._width = width;
            this.smartRerender();
        }
    }

    public String getWidth() {
        return this._width;
    }

    public void setHeight(String height) {
        if (height == null) {
            throw new NullPointerException("height");
        }
        if (!Objects.equals((Object)(height = height.trim()), (Object)this._height)) {
            this.validate(height, "height");
            this._height = height;
            this.smartRerender();
        }
    }

    public String getHeight() {
        return this._height;
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._image != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._image = null;
            this.smartRerender();
        }
    }

    public void setContent(Image image) {
        if (image != this._image) {
            this._image = image;
            if (this._image != null) {
                ++this._imgver;
            }
            this.smartRerender();
        }
    }

    public Image getContent() {
        return this._image;
    }

    public boolean isChildable() {
        return false;
    }

    private void validate(String arg, String name) {
        try {
            String numstr = arg;
            if (arg.endsWith("px")) {
                numstr = arg.substring(0, arg.length() - 2);
                double num = Double.parseDouble(numstr);
                int inum = (int)num;
                if ((double)inum != num) {
                    throw new UiException(name + " allow px, or % only: " + arg);
                }
            } else if (arg.endsWith("%")) {
                numstr = arg.substring(0, arg.length() - 1);
                Double.parseDouble(numstr);
            } else {
                double num = Double.parseDouble(numstr);
                int inum = (int)num;
                if ((double)inum != num) {
                    throw new UiException(name + " allows px, or % only: " + arg);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new UiException(name + " allow px, or % only: " + arg);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "src", this.getEncodedURL());
        this.render(renderer, "screenX", this.getScreenX());
        this.render(renderer, "screenY", this.getScreenY());
        this.render(renderer, "offsetX", this.getOffsetX());
        this.render(renderer, "offsetY", this.getOffsetY());
        this.render(renderer, "width", this.getWidth());
        this.render(renderer, "height", this.getHeight());
    }

    private String getEncodedURL() {
        if (this._image != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, (int)this._imgver, (String)("c/" + this._image.getName()), (String)this._image.getFormat());
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(this._src != null ? this._src : "~./img/spacer.gif") : "";
    }

    private void smartRerender() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("src", new EncodedURL());
        info.put("screenX", this.getScreenX());
        info.put("screenY", this.getScreenY());
        info.put("offsetX", this.getOffsetX());
        info.put("offsetY", this.getOffsetY());
        info.put("width", this.getWidth());
        info.put("height", this.getHeight());
        this.smartUpdate("rerender_", info);
    }

    private class EncodedURL
    implements DeferredValue {
        private EncodedURL() {
        }

        public Object getValue() {
            return Gscreen.this.getEncodedURL();
        }
    }
}

