/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.io.Writer;
import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxBorderHelper;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class DocxCellHelper
extends BaseHelper {
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "center";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    private DocxBorderHelper borderHelper = null;

    public DocxCellHelper(Writer writer) {
        super(writer);
        this.borderHelper = new DocxBorderHelper(writer);
    }

    public DocxBorderHelper getBorderHelper() {
        return this.borderHelper;
    }

    public void exportHeader(JRPrintElement element, JRExporterGridCell gridCell) {
        this.write("    <w:tc>\n");
        this.exportPropsHeader();
        if (gridCell.getColSpan() > 1) {
            this.write("      <w:gridSpan w:val=\"" + gridCell.getColSpan() + "\" />\n");
        }
        if (gridCell.getRowSpan() > 1) {
            this.write("      <w:vMerge w:val=\"restart\" />\n");
        }
        this.exportProps(element, gridCell);
        this.exportPropsFooter();
    }

    public void exportFooter() {
        this.write("    </w:tc>\n");
    }

    public void exportProps(JRPrintElement element, JRExporterGridCell gridCell) {
        JRAlignment align;
        this.exportBackcolor(element.getMode(), element.getBackcolor());
        this.borderHelper.export(gridCell.getBox());
        JRAlignment jRAlignment = align = element instanceof JRAlignment ? (JRAlignment)((Object)element) : null;
        if (align != null) {
            JRPrintText text = element instanceof JRPrintText ? (JRPrintText)element : null;
            Byte ownRotation = text == null ? null : text.getOwnRotation();
            String verticalAlignment = DocxCellHelper.getVerticalAlignment(align.getOwnVerticalAlignment());
            String textRotation = DocxCellHelper.getTextDirection(ownRotation);
            this.exportAlignmentAndRotation(verticalAlignment, textRotation);
        }
    }

    public void exportProps(JRExporterGridCell gridCell) {
        this.exportBackcolor((byte)1, gridCell.getBackcolor());
        this.borderHelper.export(gridCell.getBox());
    }

    private void exportBackcolor(byte mode, Color backcolor) {
        if (mode == 1 && backcolor != null) {
            this.write("      <w:shd w:val=\"clear\" w:color=\"auto\"\tw:fill=\"" + JRColorUtil.getColorHexa(backcolor) + "\" />\n");
        }
    }

    private void exportPropsHeader() {
        this.write("      <w:tcPr>\n");
    }

    private void exportAlignmentAndRotation(String verticalAlignment, String textRotation) {
        if (verticalAlignment != null) {
            this.write("      <w:vAlign w:val=\"" + verticalAlignment + "\" />\n");
        }
        if (textRotation != null) {
            this.write("   <w:textDirection w:val=\"" + textRotation + "\" />\n");
        }
    }

    private void exportPropsFooter() {
        this.write("      </w:tcPr>\n");
    }

    private static String getTextDirection(Byte rotation) {
        String textDirection = null;
        if (rotation != null) {
            switch (rotation) {
                case 1: {
                    textDirection = "btLr";
                    break;
                }
                case 2: {
                    textDirection = "tbRl";
                    break;
                }
            }
        }
        return textDirection;
    }

    public static String getVerticalAlignment(Byte verticalAlignment) {
        if (verticalAlignment != null) {
            switch (verticalAlignment) {
                case 3: {
                    return VERTICAL_ALIGN_BOTTOM;
                }
                case 2: {
                    return VERTICAL_ALIGN_MIDDLE;
                }
            }
            return VERTICAL_ALIGN_TOP;
        }
        return null;
    }
}

