/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.NativeMapped;

public abstract class IntegerType
extends Number
implements NativeMapped {
    private int size;
    private Number value;

    public IntegerType(int size2) {
        this(size2, 0L);
    }

    public IntegerType(int size2, long value2) {
        this.size = size2;
        this.setValue(value2);
    }

    public void setValue(long value2) {
        long truncated = value2;
        switch (this.size) {
            case 1: {
                truncated = (byte)value2;
                this.value = new Byte((byte)value2);
                break;
            }
            case 2: {
                truncated = (short)value2;
                this.value = new Short((short)value2);
                break;
            }
            case 4: {
                truncated = (int)value2;
                this.value = new Integer((int)value2);
                break;
            }
            case 8: {
                this.value = new Long(value2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported size: " + this.size);
            }
        }
        if (this.size < 8) {
            long mask = (1L << this.size * 8) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if (value2 < 0L && truncated != value2 || value2 >= 0L && (mask & value2) != 0L) {
                throw new IllegalArgumentException("Argument value 0x" + Long.toHexString(value2) + " exceeds native capacity (" + this.size + " bytes) mask=0x" + Long.toHexString(mask));
            }
        }
    }

    public Object toNative() {
        return this.value;
    }

    public Object fromNative(Object nativeValue, FromNativeContext context) {
        long value2 = nativeValue == null ? 0L : ((Number)nativeValue).longValue();
        try {
            IntegerType number = (IntegerType)this.getClass().newInstance();
            number.setValue(value2);
            return number;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate " + this.getClass());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Not allowed to instantiate " + this.getClass());
        }
    }

    public Class nativeType() {
        return this.value.getClass();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object rhs) {
        return rhs instanceof IntegerType && this.value.equals(((IntegerType)rhs).value);
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

