/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.CanBeTrailTableEncoding;
import org.jcodings.CodeRange;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;
import org.jcodings.exception.InternalException;
import org.jcodings.util.BytesHash;

public final class SJISEncoding
extends CanBeTrailTableEncoding {
    private static final int[] CR_Hiragana = new int[]{1, 33439, 33521};
    private static final int[] CR_Katakana = new int[]{4, 166, 175, 177, 221, 33600, 33662, 33664, 33686};
    private static final int[][] PropertyList = new int[][]{CR_Hiragana, CR_Katakana};
    private static final BytesHash<Integer> CTypeNameHash = new BytesHash();
    static final boolean[] SJIS_CAN_BE_TRAIL_TABLE;
    static final int[] SjisEncLen;
    private static final int[][] SjisTrans;
    public static final SJISEncoding INSTANCE;

    protected SJISEncoding() {
        super(1, 2, SjisEncLen, SjisTrans, AsciiTables.AsciiCtypeTable, SJIS_CAN_BE_TRAIL_TABLE);
    }

    public String toString() {
        return "Shift_JIS";
    }

    public int length(byte[] bytes, int p2, int end2) {
        return this.length(bytes[p2]);
    }

    public int mbcToCode(byte[] bytes, int p2, int end2) {
        return this.mbnMbcToCode(bytes, p2, end2);
    }

    public int codeToMbcLength(int code) {
        if (code < 256) {
            return SjisEncLen[code] == 1 ? 1 : 0;
        }
        if (code <= 65535) {
            return 2;
        }
        throw new EncodingException("invalid code point value");
    }

    public int codeToMbc(int code, byte[] bytes, int p2) {
        int p_ = p2;
        if ((code & 0xFF00) != 0) {
            bytes[p_++] = (byte)(code >> 8 & 0xFF);
        }
        bytes[p_++] = (byte)(code & 0xFF);
        return p_ - p2;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end2, byte[] lower) {
        return this.mbnMbcCaseFold(flag, bytes, pp, end2, lower);
    }

    public int propertyNameToCType(byte[] bytes, int p2, int end2) {
        Integer ctype = CTypeNameHash.get(bytes, p2, end2);
        if (ctype == null) {
            return super.propertyNameToCType(bytes, p2, end2);
        }
        return ctype;
    }

    public boolean isCodeCType(int code, int ctype) {
        if (ctype <= 14) {
            if (code < 128) {
                return this.isCodeCTypeInternal(code, ctype);
            }
            if (SJISEncoding.isWordGraphPrint(ctype)) {
                return this.codeToMbcLength(code) > 1;
            }
        } else {
            if ((ctype -= 15) >= PropertyList.length) {
                throw new InternalException("undefined type (bug)");
            }
            return CodeRange.isInCodeRange(PropertyList[ctype], code);
        }
        return false;
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        if (ctype <= 14) {
            return null;
        }
        sbOut.value = 128;
        if ((ctype -= 15) >= PropertyList.length) {
            throw new InternalException("undefined type (bug)");
        }
        return PropertyList[ctype];
    }

    static {
        CTypeNameHash.put("Hiragana".getBytes(), 15);
        CTypeNameHash.put("Katakana".getBytes(), 16);
        SJIS_CAN_BE_TRAIL_TABLE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false};
        SjisEncLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1};
        SjisTrans = null;
        INSTANCE = new SJISEncoding();
    }
}

