/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Colon3Node
extends Node
implements INameNode {
    protected String name;

    public Colon3Node(ISourcePosition position, String name2) {
        super(position, NodeType.COLON3NODE);
        this.name = name2;
    }

    public Colon3Node(ISourcePosition position, NodeType id2, String name2) {
        super(position, id2);
        this.name = name2;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitColon3Node(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public RubyModule getEnclosingModule(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return runtime2.getObject();
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return runtime2.getObject().fastGetConstantFrom(this.name);
    }

    @Override
    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            RubyClass left = runtime2.getObject();
            if (this.hasConstant(left)) {
                return "constant";
            }
            if (this.hasMethod(left)) {
                return "method";
            }
        }
        catch (JumpException excptn) {
            // empty catch block
        }
        return null;
    }

    private boolean hasConstant(RubyModule left) {
        return left.fastGetConstantAt(this.name) != null;
    }

    private boolean hasMethod(IRubyObject left) {
        return left.getMetaClass().isMethodBound(this.name, true);
    }
}

