/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.runtime.builtin.IRubyObject;

public final class ValueConverter {
    private final Ruby runtime;

    public ValueConverter(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public RubyArray singleToArray(IRubyObject value2) {
        if (value2 == null || value2.isNil()) {
            return this.runtime.newEmptyArray();
        }
        if (value2 instanceof RubyArray) {
            if (((RubyArray)value2).getLength() == 1) {
                return (RubyArray)value2;
            }
            return this.runtime.newArray(value2);
        }
        return this.toArray(value2);
    }

    public IRubyObject arrayToSingle(IRubyObject value2, boolean useUndefined) {
        if (!(value2 instanceof RubyArray)) {
            value2 = this.toArray(value2);
        }
        switch (((RubyArray)value2).getLength()) {
            case 0: {
                return useUndefined ? null : this.runtime.getNil();
            }
            case 1: {
                return ((RubyArray)value2).eltInternal(0);
            }
        }
        return value2;
    }

    public RubyArray singleToMultiple(IRubyObject value2) {
        if (value2 == null || value2.isNil()) {
            return this.runtime.newEmptyArray();
        }
        if (value2 instanceof RubyArray) {
            return (RubyArray)value2;
        }
        return this.toArray(value2);
    }

    public IRubyObject multipleToSingle(IRubyObject value2) {
        if (!(value2 instanceof RubyArray)) {
            value2 = this.toArray(value2);
        }
        switch (((RubyArray)value2).getLength()) {
            case 0: {
                return this.runtime.getNil();
            }
            case 1: {
                if (((RubyArray)value2).eltInternal(0) instanceof RubyArray) break;
                return ((RubyArray)value2).eltInternal(0);
            }
        }
        return value2;
    }

    private RubyArray toArray(IRubyObject value2) {
        if (value2.isNil()) {
            return this.runtime.newEmptyArray();
        }
        if (value2 instanceof RubyArray) {
            return (RubyArray)value2;
        }
        if (value2.respondsTo("to_ary")) {
            return value2.convertToArray();
        }
        return this.runtime.newArray(value2);
    }
}

