/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.AbstractBuffer;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.AbstractMemoryPointer;
import org.jruby.ext.ffi.Callback;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.Invoker;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.StructLayoutBuilder;
import org.jruby.ext.ffi.io.FileDescriptorIO;
import org.jruby.runtime.load.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Factory {
    protected Factory() {
    }

    public static final Factory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Ruby runtime2, RubyModule module) {
        RubyModule rubyModule = module;
        synchronized (rubyModule) {
            if (module.fastGetClass("Provider") == null) {
                FFIProvider.createProviderClass(runtime2);
            }
            if (module.fastGetClass("Invoker") == null) {
                Invoker.createInvokerClass(runtime2);
            }
            if (module.fastGetClass("AbstractMemory") == null) {
                AbstractMemory.createAbstractMemoryClass(runtime2);
            }
            if (module.fastGetClass("AbstractMemoryPointer") == null) {
                AbstractMemoryPointer.createMemoryPointerClass(runtime2);
            }
            if (module.fastGetClass("AbstractBuffer") == null) {
                AbstractBuffer.createBufferClass(runtime2);
            }
            if (module.fastGetClass("Callback") == null) {
                Callback.createCallbackClass(runtime2);
            }
            if (module.fastGetClass("StructLayout") == null) {
                StructLayout.createStructLayoutClass(runtime2);
            }
            if (module.fastGetClass("StructLayoutBuilder") == null) {
                StructLayoutBuilder.createStructLayoutBuilderClass(runtime2);
            }
            if (module.fastGetClass("FileDescriptorIO") == null) {
                FileDescriptorIO.createFileDescriptorIOClass(runtime2);
            }
            FFIProvider provider = this.newProvider(runtime2);
            module.defineConstant("InvokerFactory", provider);
            module.defineConstant("CallbackFactory", provider);
            module.defineConstant("LastError", provider);
            RubyModule nativeType = module.defineModuleUnder("NativeType");
            for (NativeType type2 : NativeType.values()) {
                nativeType.defineConstant(type2.name(), runtime2.newFixnum(type2.ordinal()));
            }
            Platform.getPlatform().init(runtime2, module);
        }
    }

    protected abstract FFIProvider newProvider(Ruby var1);

    public abstract <T> T loadLibrary(String var1, Class<T> var2);

    public abstract Platform getPlatform();

    public abstract ByteChannel newByteChannel(int var1);

    public static class Service
    implements Library {
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            if (!RubyInstanceConfig.nativeEnabled) {
                throw runtime2.newLoadError("Native API access is disabled");
            }
            RubyModule ffi2 = runtime2.defineModuleUnder("FFI", runtime2.defineModule("JRuby"));
            Factory factory = Factory.getInstance();
            factory.init(runtime2, ffi2);
        }
    }

    private static final class SingletonHolder {
        private static final Factory INSTANCE = SingletonHolder.getInstance();

        private SingletonHolder() {
        }

        private static final Factory getInstance() {
            boolean useJNA = Boolean.getBoolean("jruby.ffi.usejna");
            String prefix = FFIProvider.class.getPackage().getName();
            Factory factory = null;
            if (!useJNA) {
                try {
                    factory = (Factory)Class.forName(prefix + ".jffi.JFFIFactory", true, Ruby.getClassLoader()).newInstance();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            if (factory == null) {
                try {
                    factory = (Factory)Class.forName(prefix + ".jna.JNAFactory", true, Ruby.getClassLoader()).newInstance();
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Could not load FFI provider", ex);
                }
            }
            return factory;
        }
    }
}

