/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"JRuby::FFI::Invoker"}, parent="Object")
public abstract class Invoker
extends RubyObject {
    static final String CLASS_NAME = "Invoker";
    protected final Arity arity;

    public static RubyClass createInvokerClass(Ruby runtime2) {
        RubyModule module = FFIProvider.getModule(runtime2);
        RubyClass result = module.defineClassUnder(CLASS_NAME, runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(Invoker.class);
        result.defineAnnotatedConstants(Invoker.class);
        return result;
    }

    protected Invoker(Ruby runtime2, int arity2) {
        super(runtime2, FFIProvider.getModule(runtime2).fastGetClass(CLASS_NAME));
        this.arity = Arity.fixed(arity2);
    }

    @JRubyMethod(name={"attach"})
    public IRubyObject attach(ThreadContext context, IRubyObject module, IRubyObject methodName) {
        DynamicMethod m = this.createDynamicMethod((RubyModule)module);
        ((RubyModule)module).addMethod(methodName.asJavaString(), m);
        return context.getRuntime().getNil();
    }

    protected DynamicMethod createDynamicMethod(RubyModule module) {
        return new DynamicMethod(module, Visibility.PUBLIC, CallConfiguration.NO_FRAME_NO_SCOPE){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                Invoker.this.arity.checkArity(context.getRuntime(), args2);
                return Invoker.this.invoke(context, args2);
            }

            public DynamicMethod dup() {
                return this;
            }

            public Arity getArity() {
                return Invoker.this.getArity();
            }

            public boolean isNative() {
                return true;
            }
        };
    }

    @JRubyMethod(name={"invoke", "call"}, rest=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] rubyArgs) {
        return this.invoke(context, ((RubyArray)rubyArgs[0]).toJavaArrayMaybeUnsafe());
    }

    public abstract IRubyObject invoke(ThreadContext var1, IRubyObject[] var2);

    public final Arity getArity() {
        return this.arity;
    }
}

