/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.CallbackProxy;
import com.sun.jna.Pointer;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.ext.ffi.Callback;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jna.Invocation;
import org.jruby.ext.ffi.jna.JNAMemoryPointer;
import org.jruby.ext.ffi.jna.Marshaller;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;

final class CallbackMarshaller
implements Marshaller {
    private static final Map<Object, com.sun.jna.Callback> callbackMap = Collections.synchronizedMap(new WeakHashMap());
    private final Callback callback;
    private final Class[] paramTypes;
    private final Class returnType;
    private final int convention;

    public CallbackMarshaller(Callback cb, int convention) {
        this.callback = cb;
        this.convention = convention;
        NativeType[] nativeParams = cb.getParameterTypes();
        this.paramTypes = new Class[nativeParams.length];
        for (int i = 0; i < nativeParams.length; ++i) {
            this.paramTypes[i] = CallbackMarshaller.classFor(nativeParams[i]);
            if (this.paramTypes[i] != null) continue;
            throw cb.getRuntime().newArgumentError("Invalid callback parameter type: " + nativeParams[i]);
        }
        switch (cb.getReturnType()) {
            case INT8: 
            case UINT8: 
            case INT16: 
            case UINT16: 
            case INT32: 
            case UINT32: 
            case LONG: 
            case ULONG: 
            case INT64: 
            case UINT64: 
            case FLOAT32: 
            case FLOAT64: 
            case POINTER: 
            case VOID: {
                this.returnType = CallbackMarshaller.classFor(cb.getReturnType());
                break;
            }
            default: {
                throw cb.getRuntime().newArgumentError("Invalid callback return type: " + cb.getReturnType());
            }
        }
    }

    private static final Class classFor(NativeType type2) {
        switch (type2) {
            case VOID: {
                return Void.TYPE;
            }
            case INT8: 
            case UINT8: {
                return Byte.TYPE;
            }
            case INT16: 
            case UINT16: {
                return Short.TYPE;
            }
            case INT32: 
            case UINT32: {
                return Integer.TYPE;
            }
            case INT64: 
            case UINT64: {
                return Long.TYPE;
            }
            case FLOAT32: {
                return Float.TYPE;
            }
            case FLOAT64: {
                return Double.TYPE;
            }
            case POINTER: {
                return Pointer.class;
            }
        }
        return null;
    }

    private final Object getCallback(Ruby runtime2, Object obj) {
        com.sun.jna.Callback cb = callbackMap.get(obj);
        if (cb != null) {
            return cb;
        }
        cb = this.convention == 1 ? new StdcallCallback(runtime2, obj) : new DefaultCallback(runtime2, obj);
        callbackMap.put(obj, cb);
        return cb;
    }

    public final Object marshal(Invocation invocation, IRubyObject parameter) {
        return this.getCallback(parameter.getRuntime(), parameter);
    }

    public final Object marshal(Ruby runtime2, Block block) {
        return this.getCallback(runtime2, block);
    }

    private static final Object toNative(Ruby runtime2, NativeType type2, IRubyObject value2) {
        switch (type2) {
            case VOID: {
                return 0L;
            }
            case INT8: {
                return Util.int8Value(value2);
            }
            case UINT8: {
                return (byte)Util.uint8Value(value2);
            }
            case INT16: {
                return Util.int16Value(value2);
            }
            case UINT16: {
                return (short)Util.uint16Value(value2);
            }
            case INT32: {
                return Util.int32Value(value2);
            }
            case UINT32: {
                return (int)Util.uint32Value(value2);
            }
            case INT64: 
            case UINT64: {
                return Util.int64Value(value2);
            }
            case FLOAT32: {
                return Float.valueOf(Util.floatValue(value2));
            }
            case FLOAT64: {
                return Util.doubleValue(value2);
            }
            case POINTER: {
                return ((JNAMemoryPointer)value2).getNativeMemory();
            }
        }
        return 0L;
    }

    private static final IRubyObject fromNative(Ruby runtime2, NativeType type2, Object value2) {
        switch (type2) {
            case VOID: {
                return runtime2.getNil();
            }
            case INT8: {
                return runtime2.newFixnum(((Byte)value2).byteValue());
            }
            case UINT8: {
                return Util.newUnsigned8(runtime2, ((Byte)value2).byteValue());
            }
            case INT16: {
                return runtime2.newFixnum(((Short)value2).shortValue());
            }
            case UINT16: {
                return Util.newUnsigned16(runtime2, ((Short)value2).shortValue());
            }
            case INT32: {
                return runtime2.newFixnum((Integer)value2);
            }
            case UINT32: {
                return Util.newUnsigned32(runtime2, (Integer)value2);
            }
            case INT64: {
                return runtime2.newFixnum((Long)value2);
            }
            case UINT64: {
                return Util.newUnsigned64(runtime2, (Long)value2);
            }
            case FLOAT32: {
                return runtime2.newFloat(((Float)value2).floatValue());
            }
            case FLOAT64: {
                return runtime2.newFloat((Double)value2);
            }
            case POINTER: {
                return new JNAMemoryPointer(runtime2, (Pointer)value2);
            }
        }
        throw new IllegalArgumentException("Invalid type " + type2);
    }

    private final class StdcallCallback
    extends RubyCallback
    implements AltCallingConvention {
        StdcallCallback(Ruby runtime2, Object recv2) {
            super(runtime2, recv2);
        }
    }

    private final class DefaultCallback
    extends RubyCallback {
        DefaultCallback(Ruby runtime2, Object recv2) {
            super(runtime2, recv2);
        }
    }

    private class RubyCallback
    implements CallbackProxy {
        private final WeakReference<Object> proc;
        private final Ruby runtime;

        RubyCallback(Ruby runtime2, Object proc2) {
            this.proc = new WeakReference<Object>(proc2);
            this.runtime = runtime2;
        }

        public Object callback(Object[] args2) {
            IRubyObject retVal;
            Object recv2 = this.proc.get();
            if (recv2 == null) {
                return 0L;
            }
            NativeType[] nativeParams = CallbackMarshaller.this.callback.getParameterTypes();
            IRubyObject[] params2 = new IRubyObject[nativeParams.length];
            for (int i = 0; i < params2.length; ++i) {
                params2[i] = CallbackMarshaller.fromNative(this.runtime, nativeParams[i], args2[i]);
            }
            try {
                retVal = recv2 instanceof RubyProc ? ((RubyProc)recv2).call(this.runtime.getCurrentContext(), params2) : ((Block)recv2).call(this.runtime.getCurrentContext(), params2);
            }
            catch (Throwable t) {
                return 0L;
            }
            return CallbackMarshaller.toNative(this.runtime, CallbackMarshaller.this.callback.getReturnType(), retVal);
        }

        public Class[] getParameterTypes() {
            return CallbackMarshaller.this.paramTypes;
        }

        public Class getReturnType() {
            return CallbackMarshaller.this.returnType;
        }
    }
}

