/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Function;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.jna.CallbackMarshaller;
import org.jruby.ext.ffi.jna.FunctionInvoker;
import org.jruby.ext.ffi.jna.Invocation;
import org.jruby.ext.ffi.jna.Marshaller;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

final class CallbackMethodWithBlock
extends DynamicMethod {
    private final Marshaller[] marshallers;
    private final Function function;
    private final FunctionInvoker functionInvoker;
    private final int cbindex;

    public CallbackMethodWithBlock(RubyModule implementationClass, Function function, FunctionInvoker functionInvoker, Marshaller[] marshallers, int cbindex) {
        super(implementationClass, Visibility.PUBLIC, CallConfiguration.FRAME_AND_SCOPE);
        this.function = function;
        this.functionInvoker = functionInvoker;
        this.marshallers = marshallers;
        this.cbindex = cbindex;
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        int i;
        boolean blockGiven = block.isGiven();
        Arity.checkArgumentCount(context.getRuntime(), args2, this.marshallers.length - (blockGiven ? 1 : 0), this.marshallers.length);
        Invocation invocation = new Invocation();
        Object[] nativeArgs = new Object[this.marshallers.length];
        if (!blockGiven) {
            for (i = 0; i < args2.length; ++i) {
                nativeArgs[i] = this.marshallers[i].marshal(invocation, args2[i]);
            }
        } else {
            for (i = 0; i < this.cbindex; ++i) {
                nativeArgs[i] = this.marshallers[i].marshal(invocation, args2[i]);
            }
            nativeArgs[this.cbindex] = ((CallbackMarshaller)this.marshallers[this.cbindex]).marshal(context.getRuntime(), block);
            for (i = this.cbindex + 1; i < this.marshallers.length; ++i) {
                nativeArgs[i] = this.marshallers[i].marshal(invocation, args2[i - 1]);
            }
        }
        IRubyObject retVal = this.functionInvoker.invoke(context.getRuntime(), this.function, nativeArgs);
        invocation.finish();
        return retVal;
    }

    public DynamicMethod dup() {
        return this;
    }

    public Arity getArity() {
        return Arity.fixed(this.marshallers.length);
    }

    public boolean isNative() {
        return true;
    }
}

