/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedBlock
extends BlockBody {
    private final IterNode iterNode;
    private final boolean hasVarNode;
    private final Node varNode;
    private final Node bodyNode;
    private final StaticScope scope;
    private final Arity arity;

    public static Block newInterpretedClosure(ThreadContext context, IterNode iterNode, IRubyObject self) {
        Frame f = context.getCurrentFrame();
        return InterpretedBlock.newInterpretedClosure(iterNode, self, Arity.procArityOf(iterNode.getVarNode()), f, f.getVisibility(), context.getRubyClass(), context.getCurrentScope());
    }

    public static Block newInterpretedClosure(ThreadContext context, InterpretedBlock body, IRubyObject self) {
        Frame f = context.getCurrentFrame();
        Binding binding2 = new Binding(self, f, f.getVisibility(), context.getRubyClass(), context.getCurrentScope());
        return new Block(body, binding2);
    }

    public static Block newInterpretedClosure(IterNode iterNode, IRubyObject self, Arity arity2, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope) {
        NodeType argsNodeId = InterpretedBlock.getArgumentTypeWackyHack(iterNode);
        InterpretedBlock body = new InterpretedBlock(iterNode, arity2, InterpretedBlock.asArgumentType(argsNodeId));
        Binding binding2 = new Binding(self, frame, visibility, klass, dynamicScope);
        return new Block(body, binding2);
    }

    public InterpretedBlock(IterNode iterNode, int argumentType) {
        this(iterNode, Arity.procArityOf(iterNode == null ? null : iterNode.getVarNode()), argumentType);
    }

    public InterpretedBlock(IterNode iterNode, Arity arity2, int argumentType) {
        super(argumentType);
        this.iterNode = iterNode;
        this.arity = arity2;
        this.hasVarNode = iterNode.getVarNode() != null;
        this.varNode = iterNode.getVarNode();
        this.bodyNode = iterNode.getBodyNode() == null ? NilImplicitNode.NIL : iterNode.getBodyNode();
        this.scope = iterNode.getScope();
    }

    protected Frame pre(ThreadContext context, RubyModule klass, Binding binding2) {
        return context.preYieldSpecificBlock(binding2, this.iterNode.getScope(), klass);
    }

    protected void post(ThreadContext context, Binding binding2, Visibility vis, Frame lastFrame) {
        binding2.getFrame().setVisibility(vis);
        context.postYield(binding2, lastFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        IRubyObject self = this.prepareSelf(binding2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            if (this.hasVarNode) {
                this.setupBlockArg(context, this.varNode, value2, self);
            }
            IRubyObject iRubyObject = this.evalBlockBody(context, self);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        if (klass == null) {
            self = this.prepareSelf(binding2);
        }
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, klass, binding2);
        try {
            if (this.hasVarNode) {
                if (aValue) {
                    this.setupBlockArgs(context, this.varNode, value2, self);
                } else {
                    this.setupBlockArg(context, this.varNode, value2, self);
                }
            }
            IRubyObject iRubyObject = this.evalBlockBody(context, self);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    /*
     * Loose catch block
     */
    private IRubyObject evalBlockBody(ThreadContext context, IRubyObject self) {
        while (true) {
            try {
                return this.bodyNode.interpret(context.getRuntime(), context, self, Block.NULL_BLOCK);
            }
            catch (JumpException.RedoJump rj) {
                context.pollThreadEvents();
                continue;
            }
            break;
        }
        catch (StackOverflowError sfe) {
            throw context.getRuntime().newSystemStackError("stack level too deep");
        }
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self = binding2.getSelf();
        binding2.getFrame().setSelf(self);
        return self;
    }

    private IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj, Block.Type type2) {
        return type2 == Block.Type.LAMBDA ? context.getRuntime().getNil() : (IRubyObject)nj.getValue();
    }

    private void setupBlockArgs(ThreadContext context, Node varNode, IRubyObject value2, IRubyObject self) {
        Ruby runtime2 = context.getRuntime();
        switch (varNode.nodeId) {
            case ZEROARGNODE: {
                break;
            }
            case MULTIPLEASGNNODE: {
                value2 = AssignmentVisitor.multiAssign(runtime2, context, self, (MultipleAsgnNode)varNode, (RubyArray)value2, false);
                break;
            }
            default: {
                this.defaultArgsLogic(context, runtime2, self, value2);
            }
        }
    }

    private void setupBlockArg(ThreadContext context, Node varNode, IRubyObject value2, IRubyObject self) {
        Ruby runtime2 = context.getRuntime();
        switch (varNode.nodeId) {
            case ZEROARGNODE: {
                return;
            }
            case MULTIPLEASGNNODE: {
                value2 = AssignmentVisitor.multiAssign(runtime2, context, self, (MultipleAsgnNode)varNode, ArgsUtil.convertToRubyArray(runtime2, value2, ((MultipleAsgnNode)varNode).getHeadNode() != null), false);
                break;
            }
            default: {
                this.defaultArgLogic(context, runtime2, self, value2);
            }
        }
    }

    private final void defaultArgsLogic(ThreadContext context, Ruby ruby, IRubyObject self, IRubyObject value2) {
        int length2 = ArgsUtil.arrayLength(value2);
        switch (length2) {
            case 0: {
                value2 = ruby.getNil();
                break;
            }
            case 1: {
                value2 = ((RubyArray)value2).eltInternal(0);
                break;
            }
            default: {
                ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length2 + " for 1)", new Object[0]);
            }
        }
        this.varNode.assign(ruby, context, self, value2, Block.NULL_BLOCK, false);
    }

    private final void defaultArgLogic(ThreadContext context, Ruby ruby, IRubyObject self, IRubyObject value2) {
        if (value2 == null) {
            ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
        }
        this.varNode.assign(ruby, context, self, value2, Block.NULL_BLOCK, false);
    }

    public StaticScope getStaticScope() {
        return this.scope;
    }

    public Block cloneBlock(Binding binding2) {
        binding2 = new Binding(binding2.getSelf(), binding2.getFrame().duplicate(), binding2.getVisibility(), binding2.getKlass(), binding2.getDynamicScope());
        return new Block(this, binding2);
    }

    public IterNode getIterNode() {
        return this.iterNode;
    }

    public Arity arity() {
        return this.arity;
    }
}

