/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.RubyArray;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.OneVarDynamicScope;

public class TwoVarDynamicScope
extends OneVarDynamicScope {
    protected IRubyObject variableValueOne;

    public TwoVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public TwoVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 2) {
            throw new RuntimeException("TwoVarDynamicScope cannot be grown; use ManyVarsDynamicScope");
        }
    }

    public DynamicScope cloneScope() {
        return new TwoVarDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
    }

    public IRubyObject getValue(int offset2, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset2, depth - 1);
        }
        assert (offset2 < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset2) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        assert (offset2 < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset2) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = nil;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = nil;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueOne == null) {
            this.variableValueOne = nil;
            return this.variableValueOne;
        }
        return this.variableValueOne;
    }

    public IRubyObject setValue(int offset2, IRubyObject value2, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(offset2, value2, depth - 1);
        }
        assert (offset2 < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset2) {
            case 0: {
                this.variableValueZero = value2;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value2;
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public IRubyObject setValueDepthZero(IRubyObject value2, int offset2) {
        assert (offset2 < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset2) {
            case 0: {
                this.variableValueZero = value2;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value2;
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public IRubyObject setValueOneDepthZero(IRubyObject value2) {
        this.variableValueOne = value2;
        return this.variableValueOne;
    }

    public void setArgValues(IRubyObject[] values, int size2) {
        assert (size2 <= 2) : "TwoVarDynamicScope only supports scopes with two variables, not " + size2;
        switch (size2) {
            case 2: {
                this.variableValueOne = values[1];
            }
            case 1: {
                this.variableValueZero = values[0];
            }
        }
    }

    public void setArgValues(IRubyObject arg0) {
        this.variableValueZero = arg0;
    }

    public void setArgValues(IRubyObject arg0, IRubyObject arg1) {
        this.variableValueZero = arg0;
        this.variableValueOne = arg1;
    }

    public void setArgValues(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        assert (false) : "TwoVarDynamicScope only supports two variables not three";
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs <= 2) : "TwoVarDynamicScope only supports scopes with two variables";
        if (this.staticScope.getRestArg() < 0) {
            switch (totalArgs) {
                case 0: {
                    return IRubyObject.NULL_ARRAY;
                }
                case 1: {
                    return new IRubyObject[]{this.variableValueZero};
                }
                case 2: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
                }
            }
            throw new RuntimeException("more args requested than available variables");
        }
        IRubyObject restArg = this.getValue(this.staticScope.getRestArg(), 0);
        assert (restArg != null);
        RubyArray splattedArgs = RuntimeHelpers.splatValue(restArg);
        IRubyObject[] argValues = new IRubyObject[totalArgs + splattedArgs.size()];
        System.arraycopy(splattedArgs.toJavaArray(), 0, argValues, totalArgs, splattedArgs.size());
        switch (totalArgs) {
            case 2: {
                argValues[1] = this.variableValueOne;
            }
            case 1: {
                argValues[0] = this.variableValueZero;
            }
        }
        return argValues;
    }

    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] names2 = this.staticScope.getVariables();
        buf.append(names2[0]).append("=");
        if (this.variableValueZero == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueZero);
        }
        buf.append(",");
        if (this.variableValueOne == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueOne);
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

