/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.CompileException;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;

public class AssertNode
extends ASTNode {
    public ExecutableStatement assertion;

    public AssertNode(char[] expr, int fields) {
        super(expr, fields);
        if ((fields & 0x10) != 0) {
            this.assertion = (ExecutableStatement)ParseTools.subCompileExpression(expr);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            Boolean bool = (Boolean)this.assertion.getValue(ctx, thisValue, factory);
            if (!bool.booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.name)));
            }
            return bool;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement");
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            Boolean bool = (Boolean)MVEL.eval(this.name, ctx, factory);
            if (!bool.booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.name)));
            }
            return bool;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement");
        }
    }
}

