/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.perftests;

import java.util.List;
import ognl.Ognl;
import ognl.OgnlContext;
import org.mvel.ExecutableAccessor;
import org.mvel.MVEL;
import org.mvel.util.FastList;

public class InlineCollectionsPerformance {
    private static final int COUNT = 200000;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.mvel.tests.perftests.InlineCollectionsPerformance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 5) {
            long time = System.currentTimeMillis();
            InlineCollectionsPerformance.testOGNLList();
            System.out.println("OGNL2.7 : " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
            InlineCollectionsPerformance.testMVELList();
            System.out.println("MVEL    : " + (System.currentTimeMillis() - time));
            System.out.println();
            ++i;
        }
    }

    public static void testMVELList() {
        ExecutableAccessor s = (ExecutableAccessor)MVEL.compileExpression("['Foo','Bar','Foo','Bar','Foo','Bar','Foo','Bar','Foo','Bar']");
        s.getNode().getReducedValueAccelerated(null, null, null);
        int i = 0;
        while (i < 200000) {
            List list = (List)s.getNode().getAccessor().getValue(null, null, null);
            if (!($assertionsDisabled || "Foo".equals(list.get(0)) && "Foo".equals(list.get(2)) && list.size() == 10)) {
                throw new AssertionError();
            }
            ++i;
        }
    }

    public static void testOGNLList() {
        OgnlContext context = (OgnlContext)Ognl.createDefaultContext(null);
        int i = 0;
        while (i < 200000) {
            ++i;
        }
    }

    public static void testJavaList() {
        int i = 0;
        while (i < 200000) {
            FastList list = new FastList(10);
            list.add("Foo");
            list.add("Bar");
            list.add("Foo");
            list.add("Bar");
            list.add("Foo");
            list.add("Bar");
            list.add("Foo");
            list.add("Bar");
            list.add("Foo");
            list.add("Bar");
            if (!($assertionsDisabled || "Foo".equals(list.get(0)) && "Bar".equals(list.get(1)) && list.size() == 10)) {
                throw new AssertionError();
            }
            ++i;
        }
    }
}

