/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Validator;
import org.zkoss.bind.impl.AnnotateBinderImpl;
import org.zkoss.bind.impl.BindEvaluatorXImpl;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.xel.BindXelFactory;
import org.zkoss.lang.Strings;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindComposer<T extends Component>
implements Composer<T>,
ComposerExt {
    private Object _viewModel;
    private Binder _binder;
    private final Map<String, Converter> _converters;
    private final Map<String, Validator> _validators;
    private static final String BIND_ANNO = "bind";
    private static final String COMPOSER_NAME_ATTR = "composerName";
    private static final String QUEUE_NAME_ATTR = "queueName";
    private static final String QUEUE_SCOPE_ATTR = "queueScope";
    private static final String BINDER_NAME_ATTR = "binderName";

    public BindComposer() {
        this.setViewModel(this);
        this._converters = new HashMap<String, Converter>(8);
        this._validators = new HashMap<String, Validator>(8);
    }

    public Binder getBinder() {
        return this._binder;
    }

    public void setViewModel(Object viewModel) {
        this._viewModel = viewModel;
        if (this._binder != null) {
            this._binder.setViewModel(this._viewModel);
        }
    }

    public Object getViewModel() {
        return this._viewModel;
    }

    public Converter getConverter(String name) {
        Converter conv = this._converters.get(name);
        return conv;
    }

    public Validator getValidator(String name) {
        Validator validator = this._validators.get(name);
        return validator;
    }

    public void addConverter(String name, Converter converter) {
        this._converters.put(name, converter);
    }

    public void addValidator(String name, Validator validator) {
        this._validators.put(name, validator);
    }

    public void doAfterCompose(T comp) throws Exception {
        BindEvaluatorXImpl evalx = new BindEvaluatorXImpl(null, BindXelFactory.class);
        String cname = (String)comp.getAttribute(COMPOSER_NAME_ATTR);
        if (cname == null) {
            cname = BindComposer.getAnnotatedBindString(evalx, comp, COMPOSER_NAME_ATTR);
        }
        comp.setAttribute(cname != null ? cname : comp.getId() + "$composer", (Object)this);
        String qname = BindComposer.getAnnotatedBindString(evalx, comp, QUEUE_NAME_ATTR);
        String qscope = BindComposer.getAnnotatedBindString(evalx, comp, QUEUE_SCOPE_ATTR);
        this._viewModel = this.initViewModel(evalx, (Component)comp, "viewModel");
        this._binder = new AnnotateBinderImpl((Component)comp, this._viewModel, qname, qscope);
        String bname = BindComposer.getAnnotatedBindString(evalx, comp, BINDER_NAME_ATTR);
        comp.setAttribute("$BINDER$", (Object)this._binder);
        comp.setAttribute(bname != null ? bname : "binder", (Object)this._binder);
        ((BinderImpl)this._binder).loadComponent((Component)comp);
    }

    private Object initViewModel(BindEvaluatorX evalx, Component comp, String attr) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation anno = compCtrl.getAnnotation(attr, BIND_ANNO);
        if (anno != null) {
            String vmname = null;
            Object vm = null;
            for (Map.Entry entry : anno.getAttributes().entrySet()) {
                String tag = (String)entry.getKey();
                Object tagExpr = entry.getValue();
                if (vmname != null) {
                    throw new UiException("alreay has a view model[" + vmname + "," + vm + "] for this component " + comp);
                }
                vmname = tag;
                vm = BindComposer.eval(evalx, comp, (String)tagExpr, Object.class);
                try {
                    if (vm instanceof String) {
                        vm = comp.getPage().resolveClass((String)vm);
                    }
                    if (vm instanceof Class) {
                        vm = ((Class)vm).newInstance();
                    }
                }
                catch (Exception e) {
                    throw new UiException(e.getMessage(), (Throwable)e);
                }
                if (vm == null || !vm.getClass().isPrimitive()) continue;
                throw new UiException("view model '" + vmname + "' is a primitive type " + vm);
            }
            if (vm == null) {
                throw new UiException("view model '" + vmname + "' is null");
            }
            comp.setAttribute(vmname, vm);
            return vm;
        }
        return this._viewModel;
    }

    private static String getAnnotatedBindString(BindEvaluatorX evalx, Component comp, String attr) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation anno = compCtrl.getAnnotation(attr, BIND_ANNO);
        String value = null;
        if (anno != null) {
            value = anno.getAttribute("value");
            if (!Strings.isBlank((String)value)) {
                return BindComposer.eval(evalx, comp, value, String.class);
            }
            throw new NullPointerException("bind value of " + attr + " return null");
        }
        return value;
    }

    private static <T> T eval(BindEvaluatorX evalx, Component comp, String expression, Class<T> expectedType) {
        ExpressionX expr = evalx.parseExpressionX(null, expression, expectedType);
        Object obj = evalx.getValue(null, comp, expr);
        return (T)obj;
    }

    public ComponentInfo doBeforeCompose(Page page, Component parent, ComponentInfo compInfo) throws Exception {
        return compInfo;
    }

    public void doBeforeComposeChildren(Component comp) throws Exception {
    }

    public boolean doCatch(Throwable ex) throws Exception {
        return false;
    }

    public void doFinally() throws Exception {
    }

    public void notifyChange(Object bean, String property) {
        this.getBinder().notifyChange(bean, property);
    }
}

