/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.Binding;
import org.zkoss.xel.ExpressionX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessInfo {
    final String commandName;
    final ExpressionX property;
    final boolean after;
    private static final Pattern ACCESS_PATTERN = Pattern.compile("\\s+|[^\\s\"']+|\"[^\"]*\"|'[^']*'|'[^']*");

    public AccessInfo(ExpressionX property, boolean after, String command) {
        this.property = property;
        this.after = after;
        this.commandName = command;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public boolean isAfter() {
        return this.after;
    }

    public ExpressionX getProperty() {
        return this.property;
    }

    public static AccessInfo create(Binding binding, String accessScript, Class<?> expectedType, boolean ignoreTracker) {
        BindContext ctx;
        String commandName;
        Binder binder = binding.getBinder();
        Matcher matcher = ACCESS_PATTERN.matcher(accessScript);
        StringBuffer property = new StringBuffer();
        StringBuffer command = new StringBuffer();
        Boolean after = null;
        while (matcher.find()) {
            String token = matcher.group();
            if (after != null) {
                command.append(token);
                continue;
            }
            if ("after".equalsIgnoreCase(token)) {
                after = Boolean.TRUE;
                continue;
            }
            if ("before".equalsIgnoreCase(token)) {
                after = Boolean.FALSE;
                continue;
            }
            property.append(token);
        }
        if (property.length() <= 0) {
            throw new IllegalArgumentException(accessScript);
        }
        BindEvaluatorX eval = binder.getEvaluatorX();
        String script = command.toString().trim();
        ExpressionX comm = script.length() > 0 ? eval.parseExpressionX(null, script, String.class) : null;
        String string = commandName = comm == null ? null : (String)eval.getValue(null, null, comm);
        if (comm != null && !AccessInfo.isLiteralString(script, commandName)) {
            throw new IllegalArgumentException("command must be a literal text rather than an expression: " + comm.getExpressionString());
        }
        BindContext bindContext = ctx = commandName != null ? null : BindContextUtil.newBindContext(binder, binding, false, null, null, null);
        if (ctx != null && ignoreTracker) {
            ctx.setAttribute("$IGNORE_TRACKER$", Boolean.TRUE);
        }
        ExpressionX prop = eval.parseExpressionX(ctx, property.toString().trim(), expectedType);
        boolean af = after != null ? after : false;
        return new AccessInfo(prop, af, commandName);
    }

    private static boolean isLiteralString(String script, String evaled) {
        return script.equals("'" + evaled + "'") || script.equals("\"" + evaled + "\"");
    }
}

