/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.bind.Binder;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.lang.Strings;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotateBinderHelper {
    private final Binder _binder;
    private static final String BIND_ANNO = "bind";
    private static final String FORM_ANNO = "form";
    private static final String VALIDATOR_ANNO = "validator";
    private static final String CONVERTER_ANNO = "converter";

    public AnnotateBinderHelper(Binder binder) {
        this._binder = binder;
    }

    public void initComponentBindings(Component comp) {
        this.initAllComponentsBindings(comp);
    }

    private void initAllComponentsBindings(Component comp) {
        Binder selfBinder = (Binder)comp.getAttribute("$BINDER$");
        if (selfBinder != null) {
            return;
        }
        this.initFormBindings(comp);
        this.initComponentPropertiesBindings(comp);
        for (Component kid : comp.getChildren()) {
            this.initAllComponentsBindings(kid);
        }
    }

    private void initFormBindings(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation formAnno = compCtrl.getAnnotation(FORM_ANNO);
        if (formAnno != null) {
            ArrayList<String> saveExprs = new ArrayList<String>();
            ArrayList<String> loadExprs = new ArrayList<String>();
            String id = null;
            Object value = null;
            String initExpr = null;
            Map<String, Object> args = null;
            ValidatorInfo validatorInfo = null;
            for (Map.Entry entry : formAnno.getAttributes().entrySet()) {
                String tag = (String)entry.getKey();
                Object tagExpr = entry.getValue();
                if ("id".equals(tag)) {
                    id = (String)tagExpr;
                    continue;
                }
                if ("init".equals(tag)) {
                    initExpr = (String)tagExpr;
                    continue;
                }
                if ("save".equals(tag)) {
                    this.addTagExpr(saveExprs, tagExpr);
                    continue;
                }
                if ("load".equals(tag)) {
                    this.addTagExpr(loadExprs, tagExpr);
                    continue;
                }
                if ("value".equals(tag)) {
                    value = tagExpr;
                    continue;
                }
                if (args == null) {
                    args = new HashMap<String, Object>();
                }
                args.put(tag, tagExpr);
            }
            if (Strings.isBlank(id)) {
                throw new UiException("Must specify a form id!");
            }
            if (value != null) {
                if (loadExprs.isEmpty()) {
                    this.addTagExpr(loadExprs, value);
                }
                if (saveExprs.isEmpty()) {
                    this.addTagExpr(saveExprs, value);
                }
            }
            args = args == null ? null : this.parsedArgs(args);
            Annotation validtorAnno = compCtrl.getAnnotation(VALIDATOR_ANNO);
            if (validtorAnno != null) {
                validatorInfo = this.parseValidator(compCtrl, validtorAnno);
            }
            this._binder.addFormBindings(comp, id, initExpr, loadExprs.toArray(new String[loadExprs.size()]), saveExprs.toArray(new String[saveExprs.size()]), validatorInfo == null ? null : validatorInfo.expr, args, validatorInfo == null ? null : validatorInfo.args);
        }
    }

    private void initComponentPropertiesBindings(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        List props = compCtrl.getAnnotatedPropertiesBy(BIND_ANNO);
        for (String propName : props) {
            if (this.isEventProperty(propName)) {
                this.initCommandBindings(comp, propName);
                continue;
            }
            this.initPropertyBindings(comp, propName);
        }
    }

    private boolean isEventProperty(String propName) {
        return propName.startsWith("on") && propName.length() >= 3 && Character.isUpperCase(propName.charAt(2));
    }

    private void initCommandBindings(Component comp, String propName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = compCtrl.getAnnotation(propName, BIND_ANNO);
        if (ann != null) {
            Map attrs = ann.getAttributes();
            Map<String, Object> args = null;
            ArrayList<String> cmdExprs = new ArrayList<String>();
            for (Map.Entry entry : attrs.entrySet()) {
                String tag = (String)entry.getKey();
                Object tagExpr = entry.getValue();
                if ("value".equals(tag)) {
                    if (tagExpr instanceof String[]) {
                        throw new UiException("Allow only one Command for an event!");
                    }
                    cmdExprs.add((String)tagExpr);
                    continue;
                }
                if (args == null) {
                    args = new HashMap<String, Object>();
                }
                args.put(tag, tagExpr);
            }
            args = args == null ? null : this.parsedArgs(args);
            for (String cmd : cmdExprs) {
                this._binder.addCommandBinding(comp, propName, cmd, args);
            }
        }
    }

    private void initPropertyBindings(Component comp, String propName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = compCtrl.getAnnotation(propName, BIND_ANNO);
        if (ann != null) {
            Annotation converterAnno;
            ArrayList<String> saveExprs = new ArrayList<String>();
            ArrayList<String> loadExprs = new ArrayList<String>();
            Object value = null;
            String initExpr = null;
            Map<String, Object> args = null;
            ValidatorInfo validatorInfo = null;
            ConverterInfo converterInfo = null;
            for (Map.Entry entry : ann.getAttributes().entrySet()) {
                String tag = (String)entry.getKey();
                Object tagExpr = entry.getValue();
                if ("init".equals(tag)) {
                    initExpr = (String)tagExpr;
                    continue;
                }
                if ("save".equals(tag)) {
                    this.addTagExpr(saveExprs, tagExpr);
                    continue;
                }
                if ("load".equals(tag)) {
                    this.addTagExpr(loadExprs, tagExpr);
                    continue;
                }
                if ("value".equals(tag)) {
                    value = tagExpr;
                    continue;
                }
                if (args == null) {
                    args = new HashMap<String, Object>();
                }
                args.put(tag, tagExpr);
            }
            if (value != null) {
                if (loadExprs.isEmpty()) {
                    this.addTagExpr(loadExprs, value);
                }
                if (saveExprs.isEmpty()) {
                    this.addTagExpr(saveExprs, value);
                }
            }
            args = args == null ? null : this.parsedArgs(args);
            Annotation validtorAnno = compCtrl.getAnnotation(propName, VALIDATOR_ANNO);
            if (validtorAnno != null) {
                validatorInfo = this.parseValidator(compCtrl, validtorAnno);
            }
            if ((converterAnno = compCtrl.getAnnotation(propName, CONVERTER_ANNO)) != null) {
                converterInfo = this.parseConverter(compCtrl, converterAnno);
            }
            this._binder.addPropertyBinding(comp, propName, initExpr, loadExprs.toArray(new String[loadExprs.size()]), saveExprs.toArray(new String[saveExprs.size()]), converterInfo == null ? null : converterInfo.expr, validatorInfo == null ? null : validatorInfo.expr, args, converterInfo == null ? null : converterInfo.args, validatorInfo == null ? null : validatorInfo.args);
        }
    }

    private ConverterInfo parseConverter(ComponentCtrl compCtrl, Annotation anno) {
        ConverterInfo info = new ConverterInfo();
        for (Map.Entry entry : anno.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            Object tagExpr = entry.getValue();
            if ("value".equals(tag)) {
                info.expr = (String)tagExpr;
                continue;
            }
            if (info.args == null) {
                info.args = new HashMap<String, Object>();
            }
            info.args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new UiException("Must specify a converter!");
        }
        info.args = info.args == null ? null : this.parsedArgs(info.args);
        return info;
    }

    private ValidatorInfo parseValidator(ComponentCtrl compCtrl, Annotation anno) {
        ValidatorInfo info = new ValidatorInfo();
        for (Map.Entry entry : anno.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            Object tagExpr = entry.getValue();
            if ("value".equals(tag)) {
                info.expr = (String)tagExpr;
                continue;
            }
            if (info.args == null) {
                info.args = new HashMap<String, Object>();
            }
            info.args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new UiException("Must specify a validator!");
        }
        info.args = info.args == null ? null : this.parsedArgs(info.args);
        return info;
    }

    private void addTagExpr(List<String> exprs, Object tagExpr) {
        if (tagExpr instanceof String[]) {
            for (String expr : (String[])tagExpr) {
                exprs.add(expr);
            }
        } else {
            exprs.add((String)tagExpr);
        }
    }

    private Map<String, Object> parsedArgs(Map<String, Object> args) {
        BindEvaluatorX eval = this._binder.getEvaluatorX();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(args.size());
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                this.addArg(eval, result, key, (String)value);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private void addArg(BindEvaluatorX eval, Map<String, Object> result, String key, String valueScript) {
        ExpressionX parsedValue = valueScript == null ? null : eval.parseExpressionX(null, valueScript, Object.class);
        result.put(key, parsedValue);
    }

    private static class ConverterInfo {
        Map<String, Object> args;
        String expr;

        private ConverterInfo() {
        }
    }

    private static class ValidatorInfo {
        Map<String, Object> args;
        String expr;

        private ValidatorInfo() {
        }
    }
}

