/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.VariableResolverX;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Label;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.Rows;

public class BindRowRenderer
implements RowRenderer {
    public void render(final Row row, final Object data) {
        Rows rows = (Rows)row.getParent();
        Grid grid = (Grid)rows.getParent();
        Template tm = grid.getTemplate("model");
        if (tm == null) {
            Label label = BindRowRenderer.newRenderLabel(Objects.toString((Object)data));
            label.applyProperties();
            label.setParent((Component)row);
            row.setValue(data);
        } else {
            final String varnm = (String)grid.getAttribute("$VAR$");
            Component[] items = tm.create((Component)rows, (Component)row, (VariableResolver)new VariableResolverX(){

                public Object resolveVariable(String name) {
                    return varnm.equals(name) ? data : null;
                }

                public Object resolveVariable(XelContext ctx, Object base, Object name) throws XelException {
                    if (base == null) {
                        return varnm.equals(name) ? data : null;
                    }
                    if (base.equals(data)) {
                        return "index".equals(name) ? Integer.valueOf(row.getIndex()) : null;
                    }
                    return null;
                }
            });
            if (items.length != 1) {
                throw new UiException("The model template must have exactly one row, not " + items.length);
            }
            Row nr = (Row)items[0];
            nr.setAttribute(varnm, data);
            if (nr.getValue() == null) {
                nr.setValue(data);
            }
            row.setAttribute("org.zkoss.zul.model.renderAs", (Object)nr);
            row.detach();
        }
    }

    private static Label newRenderLabel(String value) {
        Label label = new Label(value != null && value.length() > 0 ? value : " ");
        label.setPre(true);
        return label;
    }
}

