/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Form;
import org.zkoss.bind.Phase;
import org.zkoss.bind.PhaseListener;
import org.zkoss.bind.Property;
import org.zkoss.bind.SimpleForm;
import org.zkoss.bind.Validator;
import org.zkoss.bind.converter.FormatedDateConverter;
import org.zkoss.bind.converter.FormatedNumberConverter;
import org.zkoss.bind.converter.ObjectBooleanConverter;
import org.zkoss.bind.converter.UriConverter;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXImpl;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.CommandBindingImpl;
import org.zkoss.bind.impl.InitPropertyBindingImpl;
import org.zkoss.bind.impl.LoadFormBindingImpl;
import org.zkoss.bind.impl.LoadPropertyBindingImpl;
import org.zkoss.bind.impl.LogUtil;
import org.zkoss.bind.impl.SaveFormBindingImpl;
import org.zkoss.bind.impl.SavePropertyBindingImpl;
import org.zkoss.bind.impl.ValidationContextImpl;
import org.zkoss.bind.impl.ValidationHelper;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.CommandBinding;
import org.zkoss.bind.sys.LoadBinding;
import org.zkoss.bind.sys.LoadFormBinding;
import org.zkoss.bind.sys.LoadPropertyBinding;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.bind.sys.SaveBinding;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.sys.tracker.Tracker;
import org.zkoss.bind.tracker.impl.TrackerImpl;
import org.zkoss.bind.xel.BindXelFactory;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Strings;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zel.MethodNotFoundException;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinderImpl
implements Binder,
BinderCtrl {
    private static final LogUtil log = new LogUtil(BinderImpl.class.getName());
    private static final Map<String, Converter> CONVERTERS = new HashMap<String, Converter>();
    private static final Map<String, Validator> VALIDATORS = new HashMap<String, Validator>();
    private static final Map<String, Object> RENDERERS = new HashMap<String, Object>();
    public static final String BINDING = "$BINDING$";
    public static final String BINDER = "$BINDER$";
    public static final String BINDCTX = "$BINDCTX$";
    public static final String VAR = "$VAR$";
    public static final String VM = "$VM$";
    public static final String QUE = "$QUE$";
    public static final String NOTIFYS = "$NOTIFYS$";
    public static final String VALIDATES = "$VALIDATES$";
    public static final String SRCPATH = "$SRCPATH$";
    public static final String IGNORE_TRACKER = "$IGNORE_TRACKER$";
    private static final String SYSBIND = "$SYSBIND$";
    private static final String RENDERER = "$R$";
    private static final String LOADEVENT = "$LE$";
    private static final String SAVEEVENT = "$SE$";
    private static final String ACCESS = "$A$";
    private static final String CONVERTER = "$C$";
    private static final String VALIDATOR = "$V$";
    private static final String ON_POST_COMMAND = "onPostCommand";
    private static final String ZBIND_COMP_UUID = "$COMPUUID$";
    private static final String FORM_ID = "$FORM_ID$";
    private static final int SUCCESS = 0;
    private static final int FAIL_VALIDATE = 1;
    private Component _rootComp;
    private BindEvaluatorX _eval;
    private PhaseListener _phaseListener;
    private Tracker _tracker;
    private final Component _dummyTarget = new AbstractComponent();
    private final Map<Component, Map<String, List<Binding>>> _bindings;
    private final Map<String, List<LoadFormBinding>> _loadFormPromptBindings;
    private final Map<String, List<LoadFormBinding>> _loadFormAfterBindings;
    private final Map<String, List<SaveFormBinding>> _saveFormAfterBindings;
    private final Map<String, List<LoadFormBinding>> _loadFormBeforeBindings;
    private final Map<String, List<SaveFormBinding>> _saveFormBeforeBindings;
    private final Map<String, List<LoadPropertyBinding>> _loadPromptBindings;
    private final Map<String, List<LoadPropertyBinding>> _loadEventBindings;
    private final Map<String, List<SavePropertyBinding>> _saveEventBindings;
    private final Map<String, List<LoadPropertyBinding>> _loadAfterBindings;
    private final Map<String, List<SavePropertyBinding>> _saveAfterBindings;
    private final Map<String, List<LoadPropertyBinding>> _loadBeforeBindings;
    private final Map<String, List<SavePropertyBinding>> _saveBeforeBindings;
    private Map<Component, Set<SaveBinding>> _assocFormSaveBindings;
    private Map<Component, Map<SaveBinding, Set<SaveBinding>>> _reversedAssocFormSaveBindings;
    private final Map<String, CommandEventListener> _listenerMap;
    private final String _quename;
    private final String _quescope;
    private final EventListener<Event> _queueListener;
    private boolean _hasGetConverterMethod = true;
    private boolean _hasGetValidatorMethod = true;

    private static void initConverter() {
        CONVERTERS.put("objectBoolean", new ObjectBooleanConverter());
        CONVERTERS.put("formatedDate", new FormatedDateConverter());
        CONVERTERS.put("formatedNumber", new FormatedNumberConverter());
        CONVERTERS.put("uri", new UriConverter());
    }

    private static void initValidator() {
    }

    public BinderImpl(Component comp, Object vm, String qname, String qscope) {
        this._rootComp = comp;
        this._bindings = new HashMap<Component, Map<String, List<Binding>>>();
        this._loadFormPromptBindings = new HashMap<String, List<LoadFormBinding>>();
        this._loadFormAfterBindings = new HashMap<String, List<LoadFormBinding>>();
        this._saveFormAfterBindings = new HashMap<String, List<SaveFormBinding>>();
        this._loadFormBeforeBindings = new HashMap<String, List<LoadFormBinding>>();
        this._saveFormBeforeBindings = new HashMap<String, List<SaveFormBinding>>();
        this._loadPromptBindings = new HashMap<String, List<LoadPropertyBinding>>();
        this._loadEventBindings = new HashMap<String, List<LoadPropertyBinding>>();
        this._saveEventBindings = new HashMap<String, List<SavePropertyBinding>>();
        this._loadAfterBindings = new HashMap<String, List<LoadPropertyBinding>>();
        this._saveAfterBindings = new HashMap<String, List<SavePropertyBinding>>();
        this._loadBeforeBindings = new HashMap<String, List<LoadPropertyBinding>>();
        this._saveBeforeBindings = new HashMap<String, List<SavePropertyBinding>>();
        this._assocFormSaveBindings = new HashMap<Component, Set<SaveBinding>>();
        this._reversedAssocFormSaveBindings = new HashMap<Component, Map<SaveBinding, Set<SaveBinding>>>();
        this._listenerMap = new HashMap<String, CommandEventListener>();
        this._quename = qname != null && !Strings.isEmpty((String)qname) ? qname : QUE;
        this._quescope = qscope != null && !Strings.isBlank((String)qscope) ? qscope : "desktop";
        this.setViewModel(vm);
        this._dummyTarget.addEventListener(ON_POST_COMMAND, (EventListener)new PostCommandListener());
        this._queueListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof PropertyChangeEvent) {
                    PropertyChangeEvent evt = (PropertyChangeEvent)event;
                    BinderImpl.this.loadOnPropertyChange(evt.getBase(), evt.getPropertyName());
                }
            }
        };
        this.subscribeChangeListener(this._quename, this._quescope, this._queueListener);
    }

    private void loadOnPropertyChange(Object base, String prop) {
        log.debug("loadOnPropertyChange:base=[%s],prop=[%s]", base, prop);
        Tracker tracker = this.getTracker();
        Set<LoadBinding> bindings = tracker.getLoadBindings(base, prop);
        for (LoadBinding binding : bindings) {
            BindContext ctx = BindContextUtil.newBindContext(this, binding, false, null, binding.getComponent(), null);
            if (binding instanceof PropertyBinding) {
                BindContextUtil.setConverterArgs(this, binding.getComponent(), ctx, (PropertyBinding)((Object)binding));
            }
            log.debug("loadOnPropertyChange:binding.load(),binding=[%s],context=[%s]", binding, ctx);
            binding.load(ctx);
        }
    }

    @Override
    public void setViewModel(Object vm) {
        this._rootComp.setAttribute(VM, vm);
        this._hasGetConverterMethod = true;
        this._hasGetValidatorMethod = true;
    }

    @Override
    public Object getViewModel() {
        return this._rootComp.getAttribute(VM);
    }

    @Override
    public Converter getConverter(String name) {
        Converter converter = null;
        if (this._hasGetConverterMethod) {
            BindEvaluatorX eval = this.getEvaluatorX();
            ExpressionX vmc = eval.parseExpressionX(null, VM + ".getConverter('" + name + "')", Converter.class);
            try {
                converter = (Converter)eval.getValue(null, this._rootComp, vmc);
            }
            catch (MethodNotFoundException x) {
                this._hasGetConverterMethod = false;
            }
        }
        if (converter == null) {
            converter = CONVERTERS.get(name);
        }
        if (converter == null && name.indexOf(46) > 0) {
            try {
                converter = (Converter)Classes.newInstanceByThread((String)name);
                CONVERTERS.put(name, converter);
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        if (converter == null) {
            throw new UiException("Cannot find the named converter:" + name);
        }
        return converter;
    }

    @Override
    public Validator getValidator(String name) {
        Validator validator = null;
        if (this._hasGetValidatorMethod) {
            BindEvaluatorX eval = this.getEvaluatorX();
            ExpressionX vmv = eval.parseExpressionX(null, VM + ".getValidator('" + name + "')", Validator.class);
            try {
                validator = (Validator)eval.getValue(null, this._rootComp, vmv);
            }
            catch (MethodNotFoundException x) {
                this._hasGetValidatorMethod = false;
            }
        }
        if (validator == null) {
            validator = VALIDATORS.get(name);
        }
        if (validator == null && name.indexOf(46) > 0) {
            try {
                validator = (Validator)Classes.newInstanceByThread((String)name);
                VALIDATORS.put(name, validator);
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        if (validator == null) {
            throw new UiException("Cannot find the named validator:" + name);
        }
        return validator;
    }

    protected Object getRenderer(String name) {
        Object renderer = RENDERERS.get(name);
        if (renderer == null && name.indexOf(46) > 0) {
            try {
                renderer = Classes.newInstanceByThread((String)name);
                RENDERERS.put(name, renderer);
            }
            catch (IllegalAccessException e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return renderer;
    }

    @Override
    public BindEvaluatorX getEvaluatorX() {
        if (this._eval == null) {
            this._eval = new BindEvaluatorXImpl(null, BindXelFactory.class);
        }
        return this._eval;
    }

    @Override
    public void addFormBindings(Component comp, String idScript, String initExpr, String[] loadExprs, String[] saveExprs, String validator, Map<String, Object> args, Map<String, Object> validatorArgs) {
        BindEvaluatorX eval = this.getEvaluatorX();
        ExpressionX idExpr = eval.parseExpressionX(null, idScript, String.class);
        String id = (String)eval.getValue(null, comp, idExpr);
        Form form = this.doInitFormBinding(comp, initExpr, args);
        comp.setAttribute(FORM_ID, (Object)id);
        comp.setAttribute(id, (Object)form);
        for (String loadExpr : loadExprs) {
            this.addLoadFormBinding(comp, id, form, loadExpr, args);
        }
        for (String saveExpr : saveExprs) {
            this.addSaveFormBinding(comp, id, form, saveExpr, validator, args, validatorArgs);
        }
    }

    private Form doInitFormBinding(Component comp, String initExpr, Map<String, Object> args) {
        if (initExpr == null) {
            return new SimpleForm();
        }
        BindEvaluatorX eval = this.getEvaluatorX();
        BindContext ctx = BindContextUtil.newBindContext(this, null, false, null, comp, null);
        ctx.setAttribute(IGNORE_TRACKER, Boolean.TRUE);
        ExpressionX expr = eval.parseExpressionX(ctx, initExpr, Object.class);
        Object obj = eval.getValue(null, comp, expr);
        if (obj instanceof Form) {
            return (Form)obj;
        }
        throw new UiException("the return value of init expression is not a From is :" + obj);
    }

    private String getBindUuid(Component comp) {
        String uuid = (String)comp.getAttribute(ZBIND_COMP_UUID, 0);
        if (uuid == null) {
            uuid = comp.getUuid();
            comp.setAttribute(ZBIND_COMP_UUID, (Object)uuid, 0);
        }
        return uuid;
    }

    private void removeBindUuid(Component comp) {
        comp.removeAttribute(ZBIND_COMP_UUID, 0);
    }

    private void addLoadFormBinding(Component comp, String formid, Form form, String loadExpr, Map<String, Object> args) {
        LoadFormBindingImpl binding = new LoadFormBindingImpl(this, comp, formid, form, loadExpr, args);
        String attr = formid;
        this.addBinding(comp, attr, binding);
        String command = binding.getCommandName();
        if (command == null) {
            String bindDualId = this.getBindDualId(comp, attr);
            this.addLoadFormPromptBinding(bindDualId, binding);
        } else {
            boolean after = binding.isAfter();
            if (after) {
                this.addLoadFormAfterBinding(command, binding);
            } else {
                this.addLoadFormBeforeBinding(command, binding);
            }
        }
    }

    private void addSaveFormBinding(Component comp, String formid, Form form, String saveExpr, String validator, Map<String, Object> args, Map<String, Object> validatorArgs) {
        SaveFormBindingImpl binding = new SaveFormBindingImpl(this, comp, formid, form, saveExpr, validator, args, validatorArgs);
        String command = binding.getCommandName();
        if (command == null) {
            throw new UiException("Form " + formid + " must be saved by a Command: " + binding.getPropertyString());
        }
        this.addBinding(comp, formid, binding);
        boolean after = binding.isAfter();
        if (after) {
            this.addSaveFormAfterBinding(command, binding);
        } else {
            this.addSaveFormBeforeBinding(command, binding);
        }
    }

    @Override
    public void addPropertyBinding(Component comp, String attr, String initExpr, String[] loadExprs, String[] saveExprs, String converter, String validator, Map<String, Object> args, Map<String, Object> converterArgs, Map<String, Object> validatorArgs) {
        if (Strings.isBlank((String)converter) && (converter = this.getSystemConverter(comp, attr)) != null) {
            converter = "'" + converter + "'";
        }
        if (Strings.isBlank((String)validator) && (validator = this.getSystemValidator(comp, attr)) != null) {
            validator = "'" + validator + "'";
        }
        this.doInitPropertyBinding(comp, attr, initExpr, converter, args, converterArgs);
        for (String loadExpr : loadExprs) {
            this.addLoadBinding(comp, attr, loadExpr, converter, args, converterArgs);
        }
        for (String saveExpr : saveExprs) {
            this.addSaveBinding(comp, attr, saveExpr, converter, validator, args, converterArgs, validatorArgs);
        }
        this.initRendererIfAny(comp);
    }

    private void doInitPropertyBinding(Component comp, String attr, String initExpr, String converter, Map<String, Object> args, Map<String, Object> converterArgs) {
        if (initExpr == null) {
            return;
        }
        InitPropertyBindingImpl binding = new InitPropertyBindingImpl(this, comp, attr, initExpr, converter, args, converterArgs);
        BindContext ctx = BindContextUtil.newBindContext(this, binding, false, null, comp, null);
        ctx.setAttribute(IGNORE_TRACKER, Boolean.TRUE);
        if (binding instanceof PropertyBinding) {
            BindContextUtil.setConverterArgs(this, binding.getComponent(), ctx, binding);
        }
        binding.load(ctx);
    }

    private String getSystemConverter(Component comp, String attr) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = compCtrl.getAnnotation(attr, SYSBIND);
        if (ann != null) {
            Map attrs = ann.getAttributes();
            return (String)attrs.get(CONVERTER);
        }
        return null;
    }

    private String getSystemValidator(Component comp, String attr) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = compCtrl.getAnnotation(attr, SYSBIND);
        if (ann != null) {
            Map attrs = ann.getAttributes();
            return (String)attrs.get(VALIDATOR);
        }
        return null;
    }

    private void initRendererIfAny(Component comp) {
        String[] values;
        String rendererName;
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = compCtrl.getAnnotation(SYSBIND);
        Map attrs = ann != null ? ann.getAttributes() : null;
        Template tm = comp.getTemplate("model");
        if (tm == null) {
            return;
        }
        Object installed = comp.getAttribute(VAR);
        if (installed != null) {
            return;
        }
        String var = (String)tm.getParameters().get("var");
        String varnm = var == null ? "each" : var;
        comp.setAttribute(VAR, (Object)varnm);
        if (attrs != null && (rendererName = (String)attrs.get(RENDERER)) != null && (values = rendererName.split("=", 2)) != null) {
            Object renderer = this.getRenderer(values[1]);
            Object old = null;
            try {
                old = Fields.get((Object)comp, (String)values[0]);
            }
            catch (NoSuchMethodException e1) {
                // empty catch block
            }
            if (old == null) {
                try {
                    Fields.set((Object)comp, (String)values[0], (Object)renderer, (boolean)false);
                }
                catch (Exception e) {
                    throw UiException.Aide.wrap((Throwable)e);
                }
            }
        }
    }

    private void addLoadBinding(Component comp, String attr, String loadExpr, String converter, Map<String, Object> args, Map<String, Object> converterArgs) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = compCtrl.getAnnotation(attr, SYSBIND);
        String evtnm = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            String rw = (String)attrs.get(ACCESS);
            if (rw != null && !"both".equals(rw) && !"load".equals(rw)) {
                return;
            }
            evtnm = (String)attrs.get(LOADEVENT);
        }
        LoadPropertyBindingImpl binding = new LoadPropertyBindingImpl(this, comp, attr, loadExpr, converter, args, converterArgs);
        this.addBinding(comp, attr, binding);
        String command = binding.getCommandName();
        if (command == null) {
            String bindDualId;
            log.debug("add event(prompt)-load-binding: comp=[%s],attr=[%s],expr=[%s],evtnm=[%s],converter=[%s]", comp, attr, loadExpr, evtnm, converter);
            if (evtnm != null) {
                this.addEventCommandListenerIfNotExists(comp, evtnm, null);
                bindDualId = this.getBindDualId(comp, evtnm);
                this.addLoadEventBinding(comp, bindDualId, binding);
            }
            bindDualId = this.getBindDualId(comp, attr);
            this.addLoadPromptBinding(comp, bindDualId, binding);
        } else {
            boolean after = binding.isAfter();
            log.debug("add command-load-binding: comp=[%s],attr=[%s],expr=[%s],after=[%s],converter=[%s]", comp, attr, loadExpr, after, converter);
            if (after) {
                this.addLoadAfterBinding(command, binding);
            } else {
                this.addLoadBeforeBinding(command, binding);
            }
        }
    }

    private void addSaveBinding(Component comp, String attr, String saveExpr, String converter, String validator, Map<String, Object> args, Map<String, Object> converterArgs, Map<String, Object> validatorArgs) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = compCtrl.getAnnotation(attr, SYSBIND);
        String evtnm = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            String rw = (String)attrs.get(ACCESS);
            if (!"both".equals(rw) && !"save".equals(rw)) {
                return;
            }
            evtnm = (String)attrs.get(SAVEEVENT);
        }
        if (evtnm == null) {
            return;
        }
        SavePropertyBindingImpl binding = new SavePropertyBindingImpl(this, comp, attr, saveExpr, converter, validator, args, converterArgs, validatorArgs);
        this.addBinding(comp, attr, binding);
        String command = binding.getCommandName();
        if (command == null) {
            log.debug("add event(prompt)-save-binding: comp=[%s],attr=[%s],expr=[%s],evtnm=[%s],converter=[%s],validate=[%s]", comp, attr, saveExpr, evtnm, converter, validator);
            this.addEventCommandListenerIfNotExists(comp, evtnm, null);
            String bindDualId = this.getBindDualId(comp, evtnm);
            this.addSavePromptBinding(comp, bindDualId, binding);
        } else {
            boolean after = binding.isAfter();
            log.debug("add command-save-binding: comp=[%s],att=r[%s],expr=[%s],after=[%s],converter=[%s],validate=[%s]", comp, attr, saveExpr, after, converter, validator);
            if (after) {
                this.addSaveAfterBinding(command, binding);
            } else {
                this.addSaveBeforeBinding(command, binding);
            }
        }
    }

    private void addLoadFormPromptBinding(String bindDualId, LoadFormBinding binding) {
        List<LoadFormBinding> bindings = this._loadFormPromptBindings.get(bindDualId);
        if (bindings == null) {
            bindings = new ArrayList<LoadFormBinding>();
            this._loadFormPromptBindings.put(bindDualId, bindings);
        }
        bindings.add(binding);
    }

    private void addLoadFormBeforeBinding(String command, LoadFormBinding binding) {
        List<LoadFormBinding> bindings = this._loadFormBeforeBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<LoadFormBinding>();
            this._loadFormBeforeBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    private void addLoadFormAfterBinding(String command, LoadFormBinding binding) {
        List<LoadFormBinding> bindings = this._loadFormAfterBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<LoadFormBinding>();
            this._loadFormAfterBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    private void addSaveFormBeforeBinding(String command, SaveFormBinding binding) {
        List<SaveFormBinding> bindings = this._saveFormBeforeBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<SaveFormBinding>();
            this._saveFormBeforeBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    private void addSaveFormAfterBinding(String command, SaveFormBinding binding) {
        List<SaveFormBinding> bindings = this._saveFormAfterBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<SaveFormBinding>();
            this._saveFormAfterBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    private void addLoadEventBinding(Component comp, String bindDualId, LoadPropertyBinding binding) {
        List<LoadPropertyBinding> bindings = this._loadEventBindings.get(bindDualId);
        if (bindings == null) {
            bindings = new ArrayList<LoadPropertyBinding>();
            this._loadEventBindings.put(bindDualId, bindings);
        }
        bindings.add(binding);
    }

    private void addLoadPromptBinding(Component comp, String bindDualId, LoadPropertyBinding binding) {
        List<LoadPropertyBinding> bindings = this._loadPromptBindings.get(bindDualId);
        if (bindings == null) {
            bindings = new ArrayList<LoadPropertyBinding>();
            this._loadPromptBindings.put(bindDualId, bindings);
        }
        bindings.add(binding);
    }

    private void addLoadBeforeBinding(String command, LoadPropertyBinding binding) {
        List<LoadPropertyBinding> bindings = this._loadBeforeBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<LoadPropertyBinding>();
            this._loadBeforeBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    private void addLoadAfterBinding(String command, LoadPropertyBinding binding) {
        List<LoadPropertyBinding> bindings = this._loadAfterBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<LoadPropertyBinding>();
            this._loadAfterBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    private void addSavePromptBinding(Component comp, String bindDualId, SavePropertyBinding binding) {
        List<SavePropertyBinding> bindings = this._saveEventBindings.get(bindDualId);
        if (bindings == null) {
            bindings = new ArrayList<SavePropertyBinding>();
            this._saveEventBindings.put(bindDualId, bindings);
        }
        bindings.add(binding);
    }

    private void addSaveBeforeBinding(String command, SavePropertyBinding binding) {
        List<SavePropertyBinding> bindings = this._saveBeforeBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<SavePropertyBinding>();
            this._saveBeforeBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    private void addSaveAfterBinding(String command, SavePropertyBinding binding) {
        List<SavePropertyBinding> bindings = this._saveAfterBindings.get(command);
        if (bindings == null) {
            bindings = new ArrayList<SavePropertyBinding>();
            this._saveAfterBindings.put(command, bindings);
        }
        bindings.add(binding);
    }

    @Override
    public void addCommandBinding(Component comp, String evtnm, String commandExpr, Map<String, Object> args) {
        CommandBindingImpl binding = new CommandBindingImpl(this, comp, evtnm, commandExpr, args);
        this.addBinding(comp, evtnm, binding);
        this.addEventCommandListenerIfNotExists(comp, evtnm, binding);
    }

    private void addEventCommandListenerIfNotExists(Component comp, String evtnm, CommandBinding command) {
        String bindDualId = this.getBindDualId(comp, evtnm);
        CommandEventListener listener = this._listenerMap.get(bindDualId);
        if (listener == null) {
            listener = new CommandEventListener();
            comp.addEventListener(evtnm, (EventListener)listener);
            this._listenerMap.put(bindDualId, listener);
        }
        listener.setCommand(command);
    }

    private void removeEventCommandListenerIfExists(Component comp, String evtnm) {
        String bindDualId = this.getBindDualId(comp, evtnm);
        CommandEventListener listener = this._listenerMap.remove(bindDualId);
        if (listener != null) {
            comp.removeEventListener(evtnm, (EventListener)listener);
        }
    }

    @Override
    public void sendCommand(String command, Map<String, Object> args) {
        HashSet<Property> notifys = new HashSet<Property>();
        this.doCommand(this._rootComp, command, null, args, notifys);
        this.fireNotifyChanges(notifys);
    }

    private void fireNotifyChanges(Set<Property> notifys) {
        for (Property prop : notifys) {
            this.notifyChange(prop.getBase(), prop.getProperty());
        }
    }

    @Override
    public void postCommand(String command, Map<String, Object> args) {
        Event evt = new Event(ON_POST_COMMAND, this._dummyTarget, (Object)new Object[]{command, args});
        Events.postEvent((Event)evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCommand(Component comp, String command, Event evt, Map<String, Object> commandArgs, Set<Property> notifys) {
        String evtnm = evt == null ? null : evt.getName();
        log.debug("Start doCommand comp=[%s],command=[%s],evtnm=[%s]", comp, command, evtnm);
        BindContext ctx = BindContextUtil.newBindContext(this, null, false, command, comp, evt);
        BindContextUtil.setCommandArgs(this, comp, ctx, commandArgs);
        try {
            this.doPrePhase(Phase.COMMAND, ctx);
            boolean success = true;
            success = this.doValidate(comp, command, evt, ctx, notifys);
            if (!success) {
                int n = 1;
                return n;
            }
            this.doSaveBefore(comp, command, evt, ctx, notifys);
            this.doLoadBefore(comp, command, ctx);
            this.doExecute(comp, command, commandArgs, ctx, notifys);
            this.doSaveAfter(comp, command, evt, ctx, notifys);
            this.doLoadAfter(comp, command, ctx);
            log.debug("End doCommand", new Object[0]);
            int n = 0;
            return n;
        }
        finally {
            this.doPostPhase(Phase.COMMAND, ctx);
        }
    }

    void doPrePhase(Phase phase, BindContext ctx) {
        if (this._phaseListener != null) {
            this._phaseListener.prePhase(phase, ctx);
        }
    }

    void doPostPhase(Phase phase, BindContext ctx) {
        if (this._phaseListener != null) {
            this._phaseListener.postPhase(phase, ctx);
        }
    }

    private void doSaveEventNoValidate(Component comp, Event evt, Set<Property> notifys) {
        String evtnm = evt == null ? null : evt.getName();
        log.debug("doSaveEventNoValidate comp=[%s],evtnm=[%s],notifys=[%s]", comp, evtnm, notifys);
        String bindDualId = this.getBindDualId(comp, evtnm);
        List<SavePropertyBinding> bindings = this._saveEventBindings.get(bindDualId);
        if (bindings != null) {
            for (SavePropertyBinding binding : bindings) {
                this.doSavePropertyBinding(comp, binding, null, evt, notifys);
            }
        }
    }

    private boolean doSaveEvent(Component comp, Event evt, Set<Property> notifys) {
        String evtnm = evt == null ? null : evt.getName();
        log.debug("doSaveEvent comp=[%s],evtnm=[%s],notifys=[%s]", comp, evtnm, notifys);
        String bindDualId = this.getBindDualId(comp, evtnm);
        List<SavePropertyBinding> bindings = this._saveEventBindings.get(bindDualId);
        if (bindings != null) {
            for (SavePropertyBinding binding : bindings) {
                boolean success = this.doValidateSaveEvent(comp, binding, evt, notifys);
                if (!success) {
                    return false;
                }
                this.doSavePropertyBinding(comp, binding, null, evt, notifys);
            }
        }
        return true;
    }

    private void doLoadEvent(Component comp, String evtnm) {
        log.debug("doLoadEvent comp=[%s],evtnm=[%s]", comp, evtnm);
        String bindDualId = this.getBindDualId(comp, evtnm);
        List<LoadPropertyBinding> bindings = this._loadEventBindings.get(bindDualId);
        if (bindings != null) {
            for (LoadPropertyBinding binding : bindings) {
                this.doLoadPropertyBinding(comp, binding, null);
            }
        }
    }

    private boolean doValidate(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        HashSet<Property> validates = new HashSet<Property>();
        try {
            log.debug("doValidate comp=[%s],command=[%s],evt=[%s],context=[%s]", comp, command, evt, ctx);
            this.doPrePhase(Phase.VALIDATE, ctx);
            ValidationHelper vHelper = new ValidationHelper(this, new ValidationHelper.InfoProvider(){

                @Override
                public Map<String, List<SaveFormBinding>> getSaveFormBeforeBindings() {
                    return BinderImpl.this._saveFormBeforeBindings;
                }

                @Override
                public Map<String, List<SaveFormBinding>> getSaveFormAfterBindings() {
                    return BinderImpl.this._saveFormAfterBindings;
                }

                @Override
                public Map<String, List<SavePropertyBinding>> getSaveEventBindings() {
                    return BinderImpl.this._saveEventBindings;
                }

                @Override
                public Map<String, List<SavePropertyBinding>> getSaveBeforeBindings() {
                    return BinderImpl.this._saveBeforeBindings;
                }

                @Override
                public Map<String, List<SavePropertyBinding>> getSaveAfterBindings() {
                    return BinderImpl.this._saveAfterBindings;
                }

                @Override
                public String getBindDualId(Component comp, String attr) {
                    return BinderImpl.this.getBindDualId(comp, attr);
                }
            });
            vHelper.collectSaveBefore(comp, command, evt, validates);
            vHelper.collectSaveAfter(comp, command, evt, validates);
            if (evt != null) {
                vHelper.collectSaveEvent(comp, command, evt, validates);
            }
            if (validates.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            log.debug("doValidate validates=[%s]", validates);
            boolean valid = true;
            Map<String, Property[]> properties = this.toCollectedProperties(validates);
            valid &= vHelper.validateSaveBefore(comp, command, properties, valid, notifys);
            valid &= vHelper.validateSaveAfter(comp, command, properties, valid, notifys);
            if (evt != null) {
                valid &= vHelper.validateSaveEvent(comp, command, evt, properties, valid, notifys);
            }
            boolean bl = valid;
            return bl;
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        finally {
            this.doPostPhase(Phase.VALIDATE, ctx);
        }
    }

    private boolean doValidateSaveEvent(Component comp, SavePropertyBinding binding, Event evt, Set<Property> notifys) {
        if (binding.hasValidator()) {
            BindContext ctx = BindContextUtil.newBindContext(this, binding, true, null, binding.getComponent(), evt);
            BindContextUtil.setConverterArgs(this, binding.getComponent(), ctx, binding);
            BindContextUtil.setValidatorArgs((Binder)this, binding.getComponent(), ctx, binding);
            try {
                this.doPrePhase(Phase.VALIDATE, ctx);
                Property p = binding.getValidate(ctx);
                log.debug("doValidateSaveEvent comp=[%s],binding=[%s],evt=[%s],validate=[%s]", comp, binding, evt, p);
                if (p == null) {
                    throw new UiException("no main property for save-binding " + binding);
                }
                ValidationContextImpl vctx = new ValidationContextImpl(null, p, this.toCollectedProperties(p), ctx, true);
                binding.validate(vctx);
                boolean valid = vctx.isValid();
                log.debug("doValidateSaveEvent result=[%s]", valid);
                Set<Property> xnotifys = BinderImpl.getNotifys(ctx);
                if (xnotifys != null) {
                    notifys.addAll(xnotifys);
                }
                boolean bl = valid;
                return bl;
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            finally {
                this.doPostPhase(Phase.VALIDATE, ctx);
            }
        }
        return true;
    }

    private Map<String, Property[]> toCollectedProperties(Property validate) {
        HashSet<Property> cp = new HashSet<Property>();
        cp.add(validate);
        return this.toCollectedProperties(cp);
    }

    private Map<String, Property[]> toCollectedProperties(Set<Property> validates) {
        if (validates == null || validates.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, ArrayList<Property>> temp = new HashMap<String, ArrayList<Property>>(validates.size());
        for (Property p : validates) {
            ArrayList<Property> l = (ArrayList<Property>)temp.get(p.getProperty());
            if (l == null) {
                l = new ArrayList<Property>();
                temp.put(p.getProperty(), l);
            }
            l.add(p);
        }
        HashMap<String, Property[]> collected = new HashMap<String, Property[]>(temp.size());
        for (Map.Entry e : temp.entrySet()) {
            collected.put((String)e.getKey(), ((List)e.getValue()).toArray(new Property[((List)e.getValue()).size()]));
        }
        return collected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(Component comp, String command, Map<String, Object> commandArgs, BindContext ctx, Set<Property> notifys) {
        try {
            log.debug("before doExecute comp=[%s],command=[%s],notifys=[%s]", comp, command, notifys);
            this.doPrePhase(Phase.EXECUTE, ctx);
            Object base = this.getViewModel();
            Method method = null;
            Object[] param = null;
            try {
                method = Classes.getMethodInPublic(base.getClass(), (String)command, null);
                param = new Object[]{};
            }
            catch (NoSuchMethodException e) {
                try {
                    method = Classes.getMethodInPublic(base.getClass(), (String)command, (Class[])new Class[]{Map.class});
                    param = new Object[]{commandArgs == null ? Collections.emptyMap() : commandArgs};
                }
                catch (NoSuchMethodException e1) {
                    try {
                        method = Classes.getMethodInPublic(base.getClass(), (String)command, (Class[])new Class[]{BindContext.class});
                        param = new Object[]{ctx};
                    }
                    catch (NoSuchMethodException e2) {
                        throw UiException.Aide.wrap((Throwable)e);
                    }
                }
            }
            if (method != null) {
                try {
                    method.invoke(base, param);
                }
                catch (Exception e) {
                    throw UiException.Aide.wrap((Throwable)e);
                }
                notifys.addAll(BindELContext.getNotifys(method, base, null, null));
            }
            log.debug("after doExecute notifys=[%s]", notifys);
        }
        finally {
            this.doPostPhase(Phase.EXECUTE, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveBefore(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        log.debug("doSaveBefore, comp=[%s],command=[%s],evt=[%s],notifys=[%s]", comp, command, evt, notifys);
        try {
            this.doPrePhase(Phase.SAVE_BEFORE, ctx);
            this.doSavePropertyBefore(comp, command, evt, notifys);
            this.doSaveFormBefore(comp, command, evt, notifys);
        }
        finally {
            this.doPostPhase(Phase.SAVE_BEFORE, ctx);
        }
    }

    private void doSavePropertyBefore(Component comp, String command, Event evt, Set<Property> notifys) {
        List<SavePropertyBinding> bindings = this._saveBeforeBindings.get(command);
        if (bindings != null) {
            for (SavePropertyBinding binding : bindings) {
                this.doSavePropertyBinding(comp, binding, command, evt, notifys);
            }
        }
    }

    private void doSaveFormBefore(Component comp, String command, Event evt, Set<Property> notifys) {
        List<SaveFormBinding> bindings = this._saveFormBeforeBindings.get(command);
        if (bindings != null) {
            for (SaveFormBinding binding : bindings) {
                this.doSaveFormBinding(comp, binding, command, evt, notifys);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveAfter(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        log.debug("doSaveAfter, comp=[%s],command=[%s],evt=[%s],notifys=[%s]", comp, command, evt, notifys);
        try {
            this.doPrePhase(Phase.SAVE_AFTER, ctx);
            this.doSavePropertyAfter(comp, command, evt, notifys);
            this.doSaveFormAfter(comp, command, evt, notifys);
        }
        finally {
            this.doPostPhase(Phase.SAVE_AFTER, ctx);
        }
    }

    private void doSavePropertyAfter(Component comp, String command, Event evt, Set<Property> notifys) {
        List<SavePropertyBinding> bindings = this._saveAfterBindings.get(command);
        if (bindings != null) {
            for (SavePropertyBinding binding : bindings) {
                this.doSavePropertyBinding(comp, binding, command, evt, notifys);
            }
        }
    }

    private void doSaveFormAfter(Component comp, String command, Event evt, Set<Property> notifys) {
        List<SaveFormBinding> bindings = this._saveFormAfterBindings.get(command);
        if (bindings != null) {
            for (SaveFormBinding binding : bindings) {
                this.doSaveFormBinding(comp, binding, command, evt, notifys);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadBefore(Component comp, String command, BindContext ctx) {
        log.debug("doLoadBefore, comp=[%s],command=[%s]", comp, command);
        try {
            this.doPrePhase(Phase.LOAD_BEFORE, ctx);
            this.doLoadPropertyBefore(comp, command);
            this.doLoadFormBefore(comp, command);
        }
        finally {
            this.doPostPhase(Phase.LOAD_BEFORE, ctx);
        }
    }

    private void doLoadPropertyBefore(Component comp, String command) {
        List<LoadPropertyBinding> bindings = this._loadBeforeBindings.get(command);
        if (bindings != null) {
            for (LoadPropertyBinding binding : bindings) {
                this.doLoadPropertyBinding(comp, binding, command);
            }
        }
    }

    private void doLoadFormBefore(Component comp, String command) {
        List<LoadFormBinding> bindings = this._loadFormBeforeBindings.get(command);
        if (bindings != null) {
            for (LoadFormBinding binding : bindings) {
                this.doLoadFormBinding(comp, binding, command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadAfter(Component comp, String command, BindContext ctx) {
        log.debug("doLoadAfter, comp=[%s],command=[%s]", comp, command);
        try {
            this.doPrePhase(Phase.LOAD_AFTER, ctx);
            this.doLoadPropertyAfter(comp, command);
            this.doLoadFormAfter(comp, command);
        }
        finally {
            this.doPostPhase(Phase.LOAD_AFTER, ctx);
        }
    }

    private void doLoadPropertyAfter(Component comp, String command) {
        List<LoadPropertyBinding> bindings = this._loadAfterBindings.get(command);
        if (bindings != null) {
            for (LoadPropertyBinding binding : bindings) {
                this.doLoadPropertyBinding(comp, binding, command);
            }
        }
    }

    private void doLoadFormAfter(Component comp, String command) {
        List<LoadFormBinding> bindings = this._loadFormAfterBindings.get(command);
        if (bindings != null) {
            for (LoadFormBinding binding : bindings) {
                this.doLoadFormBinding(comp, binding, command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSavePropertyBinding(Component comp, SavePropertyBinding binding, String command, Event evt, Set<Property> notifys) {
        BindContext ctx = BindContextUtil.newBindContext(this, binding, true, command, binding.getComponent(), evt);
        BindContextUtil.setConverterArgs(this, binding.getComponent(), ctx, binding);
        BindContextUtil.setValidatorArgs((Binder)this, binding.getComponent(), ctx, binding);
        try {
            log.debug("doSavePropertyBinding:binding.save() comp=[%s],binding=[%s],command=[%s],evt=[%s],notifys=[%s]", comp, binding, command, evt, notifys);
            this.doPrePhase(Phase.SAVE_BINDING, ctx);
            binding.save(ctx);
        }
        finally {
            this.doPostPhase(Phase.SAVE_BINDING, ctx);
        }
        Set<Property> xnotifys = BinderImpl.getNotifys(ctx);
        if (xnotifys != null) {
            notifys.addAll(xnotifys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadPropertyBinding(Component comp, LoadPropertyBinding binding, String command) {
        BindContext ctx = BindContextUtil.newBindContext(this, binding, false, command, binding.getComponent(), null);
        BindContextUtil.setConverterArgs(this, binding.getComponent(), ctx, binding);
        try {
            log.debug("doLoadPropertyBinding:binding.load(),component=[%s],binding=[%s],context=[%s],command=[%s]", comp, binding, ctx, command);
            this.doPrePhase(Phase.LOAD_BINDING, ctx);
            binding.load(ctx);
        }
        finally {
            this.doPostPhase(Phase.LOAD_BINDING, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveFormBinding(Component comp, SaveFormBinding binding, String command, Event evt, Set<Property> notifys) {
        BindContext ctx = BindContextUtil.newBindContext(this, binding, true, command, binding.getComponent(), evt);
        BindContextUtil.setValidatorArgs((Binder)this, binding.getComponent(), ctx, binding);
        try {
            log.debug("doSaveFormBinding:binding.save() comp=[%s],binding=[%s],command=[%s],evt=[%s],notifys=[%s]", comp, binding, command, evt, notifys);
            this.doPrePhase(Phase.SAVE_BINDING, ctx);
            binding.save(ctx);
        }
        finally {
            this.doPostPhase(Phase.SAVE_BINDING, ctx);
        }
        Set<Property> xnotifys = BinderImpl.getNotifys(ctx);
        if (xnotifys != null) {
            notifys.addAll(xnotifys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadFormBinding(Component comp, LoadFormBinding binding, String command) {
        BindContext ctx = BindContextUtil.newBindContext(this, binding, false, command, binding.getComponent(), null);
        try {
            log.debug("doLoadFormBinding:binding.load(),component=[%s],binding=[%s],context=[%s],command=[%s]", comp, binding, ctx, command);
            this.doPrePhase(Phase.LOAD_BINDING, ctx);
            binding.load(ctx);
        }
        finally {
            this.doPostPhase(Phase.LOAD_BINDING, ctx);
        }
    }

    private static Set<Property> getNotifys(BindContext ctx) {
        return (Set)ctx.getAttribute(NOTIFYS);
    }

    @Override
    public void removeBindings(Component comp) {
        Map<String, List<Binding>> attrMap;
        if (this._rootComp == comp) {
            this.unsubscribeChangeListener(this._quename, this._quescope, this._queueListener);
        }
        if ((attrMap = this._bindings.remove(comp)) != null) {
            HashSet<Binding> removed = new HashSet<Binding>();
            for (Map.Entry<String, List<Binding>> entry : attrMap.entrySet()) {
                String key = entry.getKey();
                this.removeBindings(comp, key);
                removed.addAll((Collection<Binding>)entry.getValue());
            }
            if (!removed.isEmpty()) {
                this.removeBindings(removed);
            }
        }
        this.removeFormAssociatedSaveBinding(comp);
        TrackerImpl tracker = (TrackerImpl)this.getTracker();
        tracker.removeTrackings(comp);
        comp.removeAttribute(BINDER);
        this.removeBindUuid(comp);
    }

    @Override
    public void removeBindings(Component comp, String key) {
        this.removeEventCommandListenerIfExists(comp, key);
        String bindDualId = this.getBindDualId(comp, key);
        HashSet<Binding> bindings = new HashSet<Binding>();
        List<Binding> bindingx = this._loadFormPromptBindings.remove(bindDualId);
        if (bindingx != null) {
            bindings.addAll(bindingx);
        }
        if ((bindingx = this._loadPromptBindings.remove(bindDualId)) != null) {
            bindings.addAll(bindingx);
        }
        if ((bindingx = this._loadEventBindings.remove(bindDualId)) != null) {
            bindings.addAll(bindingx);
        }
        if ((bindingx = this._saveEventBindings.remove(bindDualId)) != null) {
            bindings.addAll(bindingx);
        }
        this.removeBindings(bindings);
    }

    private void removeBindings(Collection<Binding> bindings) {
        this._loadFormAfterBindings.values().removeAll(bindings);
        this._saveFormAfterBindings.values().removeAll(bindings);
        this._loadFormBeforeBindings.values().removeAll(bindings);
        this._saveFormBeforeBindings.values().removeAll(bindings);
        this._loadAfterBindings.values().removeAll(bindings);
        this._saveAfterBindings.values().removeAll(bindings);
        this._loadBeforeBindings.values().removeAll(bindings);
        this._saveBeforeBindings.values().removeAll(bindings);
    }

    private void addBinding(Component comp, String attr, Binding binding) {
        List<Binding> bindings;
        Map<String, List<Binding>> attrMap = this._bindings.get(comp);
        if (attrMap == null) {
            attrMap = new HashMap<String, List<Binding>>();
            this._bindings.put(comp, attrMap);
        }
        if ((bindings = attrMap.get(attr)) == null) {
            bindings = new ArrayList<Binding>();
            attrMap.put(attr, bindings);
        }
        bindings.add(binding);
        comp.setAttribute(BINDER, (Object)this);
    }

    @Override
    public Tracker getTracker() {
        if (this._tracker == null) {
            this._tracker = new TrackerImpl();
        }
        return this._tracker;
    }

    public void loadComponent(Component comp) {
        this.loadComponentProperties(comp);
        for (Component kid = comp.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            this.loadComponent(kid);
        }
    }

    private void loadComponentProperties(Component comp) {
        Map<String, List<Binding>> compBindings = this._bindings.get(comp);
        if (compBindings != null) {
            BindContext ctx;
            String bindDualId;
            for (String key : compBindings.keySet()) {
                bindDualId = this.getBindDualId(comp, key);
                List<LoadFormBinding> formBindings = this._loadFormPromptBindings.get(bindDualId);
                if (formBindings == null) continue;
                for (LoadFormBinding loadFormBinding : formBindings) {
                    ctx = BindContextUtil.newBindContext(this, loadFormBinding, false, null, comp, null);
                    log.debug("loadComponentProperties:form-binding.load(),component=[%s],binding=[%s],context=[%s]", comp, loadFormBinding, ctx);
                    loadFormBinding.load(ctx);
                }
            }
            for (String key : compBindings.keySet()) {
                bindDualId = this.getBindDualId(comp, key);
                List<LoadPropertyBinding> propBindings = this._loadPromptBindings.get(bindDualId);
                if (propBindings == null) continue;
                for (LoadPropertyBinding loadPropertyBinding : propBindings) {
                    ctx = BindContextUtil.newBindContext(this, loadPropertyBinding, false, null, comp, null);
                    BindContextUtil.setConverterArgs(this, loadPropertyBinding.getComponent(), ctx, loadPropertyBinding);
                    log.debug("loadComponentProperties:binding.load(),component=[%s],binding=[%s],context=[%s]", comp, loadPropertyBinding, ctx);
                    loadPropertyBinding.load(ctx);
                }
            }
        }
    }

    @Override
    public void notifyChange(Object base, String attr) {
        log.debug("notifyChange base=[%s],attr=[%s]", base, attr);
        this.getEventQueue().publish((Event)new PropertyChangeEvent("onPropertyChange", this._rootComp, base, attr));
    }

    @Override
    public void setPhaseListener(PhaseListener listener) {
        this._phaseListener = listener;
    }

    private void subscribeChangeListener(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)true);
        que.subscribe(listener);
    }

    private void unsubscribeChangeListener(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)false);
        if (que != null) {
            que.unsubscribe(listener);
        }
    }

    protected EventQueue<Event> getEventQueue() {
        return EventQueues.lookup((String)this._quename, (String)this._quescope, (boolean)true);
    }

    private String getBindDualId(Component comp, String attr) {
        String uuid = this.getBindUuid(comp);
        return uuid + "#" + attr;
    }

    private void removeFormAssociatedSaveBinding(Component comp) {
        this._assocFormSaveBindings.remove(comp);
        Map<SaveBinding, Set<SaveBinding>> associated = this._reversedAssocFormSaveBindings.remove(comp);
        if (associated != null) {
            Set<Map.Entry<SaveBinding, Set<SaveBinding>>> entries = associated.entrySet();
            for (Map.Entry<SaveBinding, Set<SaveBinding>> entry : entries) {
                entry.getValue().remove(entry.getKey());
            }
        }
    }

    @Override
    public void addFormAssociatedSaveBinding(Component associatedComp, String formId, SaveBinding saveBinding) {
        Component formComp = this.lookupAossicatedFormComponent(formId, associatedComp);
        if (formComp == null) {
            throw new UiException("cannot find any form " + formId + " with " + associatedComp);
        }
        Set<SaveBinding> bindings = this._assocFormSaveBindings.get(formComp);
        if (bindings == null) {
            bindings = new LinkedHashSet<SaveBinding>();
            this._assocFormSaveBindings.put(formComp, bindings);
        }
        bindings.add(saveBinding);
        Map<SaveBinding, Set<SaveBinding>> reverseMap = this._reversedAssocFormSaveBindings.get(associatedComp);
        if (reverseMap == null) {
            reverseMap = new HashMap<SaveBinding, Set<SaveBinding>>();
            this._reversedAssocFormSaveBindings.put(associatedComp, reverseMap);
        }
        reverseMap.put(saveBinding, bindings);
    }

    private Component lookupAossicatedFormComponent(String formId, Component associatedComp) {
        Component p;
        String fid = null;
        for (p = associatedComp; !(p == null || (fid = (String)p.getAttribute(FORM_ID)) != null && fid.equals(formId)); p = p.getParent()) {
        }
        return p;
    }

    @Override
    public Set<SaveBinding> getFormAssociatedSaveBindings(Component comp) {
        Set<SaveBinding> bindings = this._assocFormSaveBindings.get(comp);
        if (bindings == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<SaveBinding>(bindings);
    }

    static {
        BinderImpl.initConverter();
        BinderImpl.initValidator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PostCommandListener
    implements EventListener<Event> {
        private PostCommandListener() {
        }

        public void onEvent(Event event) throws Exception {
            Object[] data = (Object[])event.getData();
            String command = (String)data[0];
            Map args = (Map)data[1];
            BinderImpl.this.sendCommand(command, args);
        }
    }

    private class PropertyChangeEvent
    extends Event {
        private static final long serialVersionUID = 201109091736L;
        private final Object _base;
        private final String _propName;

        public PropertyChangeEvent(String name, Component comp, Object base, String propName) {
            super(name, comp);
            this._base = base;
            this._propName = propName;
        }

        public Object getBase() {
            return this._base;
        }

        public String getPropertyName() {
            return this._propName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommandEventListener
    implements EventListener<Event> {
        private boolean _prompt = false;
        private CommandBinding _commandBinding;

        private CommandEventListener() {
        }

        private void setCommand(CommandBinding command) {
            if (!this._prompt && command == null) {
                this._prompt = true;
            } else {
                this._commandBinding = command;
            }
        }

        public void onEvent(Event event) throws Exception {
            Component comp = event.getTarget();
            String evtnm = event.getName();
            LinkedHashSet notifys = new LinkedHashSet();
            int result = 0;
            String command = null;
            log.debug("====Start command event [%s]", event);
            if (this._commandBinding != null) {
                BindEvaluatorX eval = BinderImpl.this.getEvaluatorX();
                command = (String)eval.getValue(null, comp, ((CommandBindingImpl)this._commandBinding).getCommand());
                Map<String, Object> args = BindEvaluatorXUtil.evalArgs(eval, comp, this._commandBinding.getArgs());
                result = BinderImpl.this.doCommand(comp, command, event, args, notifys);
            }
            switch (result) {
                case 1: {
                    log.debug("There are [%s] property need to be notify after fail validate", notifys.size());
                    BinderImpl.this.fireNotifyChanges(notifys);
                    return;
                }
            }
            if (this._prompt) {
                log.debug("This is a prompt command", new Object[0]);
                if (command != null) {
                    BinderImpl.this.doSaveEventNoValidate(comp, event, notifys);
                } else {
                    BinderImpl.this.doSaveEvent(comp, event, notifys);
                }
                BinderImpl.this.doLoadEvent(comp, evtnm);
            }
            log.debug("There are [%s] property need to be notify after command", notifys.size());
            BinderImpl.this.fireNotifyChanges(notifys);
            log.debug("====End command event [%s]", event);
        }
    }
}

