/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.BindingImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.CommandBinding;
import org.zkoss.lang.Classes;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBindingImpl
extends BindingImpl
implements CommandBinding {
    private final String _evtnm;
    private final ExpressionX _command;

    public CommandBindingImpl(Binder binder, Component comp, String evtnm, String cmdScript, Map<String, Object> args) {
        super(binder, comp, args);
        this._evtnm = evtnm;
        BindEvaluatorX eval = binder.getEvaluatorX();
        this._command = eval.parseExpressionX(null, cmdScript, String.class);
    }

    public String getEventName() {
        return this._evtnm;
    }

    public ExpressionX getCommand() {
        return this._command;
    }

    @Override
    public String getCommandString() {
        return this.getPureExpressionString(this._command);
    }

    @Override
    public void execute(BindContext ctx) {
        Object base = this.getBinder().getViewModel();
        Component comp = ctx.getComponent();
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        String methodName = (String)eval.getValue(ctx, comp, this.getCommand());
        try {
            Method method = Classes.getMethodInPublic(base.getClass(), (String)methodName, (Class[])new Class[]{Map.class});
            method.invoke(this.getBinder().getViewModel(), ctx.getAttributes());
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ",component:" + this.getComponent() + ",evtnm:" + this._evtnm + ",command:" + this.getCommandString();
    }
}

