/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.impl.FormBindingImpl;
import org.zkoss.bind.impl.FormImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.LoadFormBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFormBindingImpl
extends FormBindingImpl
implements LoadFormBinding {
    private int _len;
    private Set<String> _doneDependsOn = new HashSet<String>(4);

    public LoadFormBindingImpl(Binder binder, Component comp, String formId, Form form, String loadExpr, Map<String, Object> args) {
        super(binder, comp, formId, form, loadExpr, args);
    }

    @Override
    public void load(BindContext ctx) {
        Binder binder = this.getBinder();
        BindEvaluatorX eval = binder.getEvaluatorX();
        Component comp = ctx.getComponent();
        Form form = this.getFormBean();
        for (String field : form.getLoadFieldNames()) {
            ExpressionX expr = this.getFieldExpression(eval, field);
            if (expr == null) continue;
            Object value = eval.getValue(ctx, comp, expr);
            form.setField(field, value);
        }
        ((FormImpl)form).initFields();
        binder.notifyChange(form, "*");
    }

    public void setSeriesLength(int len) {
        this._len = len;
    }

    public int getSeriesLength() {
        return this._len;
    }

    public void addDependsOnTrackings(Method m, String basepath, List<String> srcpath, String[] props) {
        if (srcpath != null) {
            String src = BindELContext.pathToString(srcpath);
            if (this._doneDependsOn.contains(src)) {
                return;
            }
            this._doneDependsOn.add(src);
        }
        for (String prop : props) {
            BindELContext.addDependsOnTracking(m, basepath, srcpath, prop, this);
        }
    }
}

