/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.impl.PropertyBindingImpl;
import org.zkoss.bind.impl.WeakHashSet;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.LoadPropertyBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadPropertyBindingImpl
extends PropertyBindingImpl
implements LoadPropertyBinding {
    private Set<String> _doneDependsOn = new HashSet<String>(4);
    private Set<Class<? extends Converter>> _doneConverterDependsOn = new WeakHashSet<Class<? extends Converter>>(4);

    public LoadPropertyBindingImpl(Binder binder, Component comp, String attr, String loadScript, String converter, Map<String, Object> args, Map<String, Object> converterArgs) {
        super(binder, comp, "self." + attr, loadScript, converter, args, converterArgs);
    }

    @Override
    public void load(BindContext ctx) {
        Component comp = ctx.getComponent();
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        Object value = eval.getValue(ctx, comp, this._accessInfo.getProperty());
        Converter conv = this.getConverter();
        if (conv != null) {
            this.addConverterDependsOnTrackings(conv, ctx);
            value = conv.coerceToUi(value, comp, ctx);
        }
        eval.setValue(null, comp, this._fieldExpr, value);
    }

    private void addConverterDependsOnTrackings(Converter conv, BindContext ctx) {
        Class<?> convClz = conv.getClass();
        if (this._doneConverterDependsOn.contains(convClz)) {
            return;
        }
        this._doneConverterDependsOn.add(convClz);
        Method m = this.getConverterMethod(convClz);
        String srcpath = this.getPropertyString();
        BindELContext.addDependsOnTrackings(m, srcpath, null, this, ctx);
    }

    private Method getConverterMethod(Class<? extends Converter> cls) {
        try {
            return cls.getMethod("coerceToUi", Object.class, Component.class, BindContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public void addDependsOnTrackings(Method m, String basepath, List<String> srcpath, String[] props) {
        if (srcpath != null) {
            String src = BindELContext.pathToString(srcpath);
            if (this._doneDependsOn.contains(src)) {
                return;
            }
            this._doneDependsOn.add(src);
        }
        for (String prop : props) {
            BindELContext.addDependsOnTracking(m, basepath, srcpath, prop, this);
        }
    }
}

