/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.impl.AccessInfo;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindingImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyBindingImpl
extends BindingImpl
implements PropertyBinding {
    protected final ExpressionX _fieldExpr;
    protected final AccessInfo _accessInfo;
    private final ExpressionX _converter;
    private final Map<String, Object> _converterArgs;

    protected PropertyBindingImpl(Binder binder, Component comp, String fieldScript, String accessScript, String converter, Map<String, Object> args, Map<String, Object> converterArgs) {
        super(binder, comp, args);
        BindEvaluatorX eval = binder.getEvaluatorX();
        Class<Object> returnType = Object.class;
        this._fieldExpr = eval.parseExpressionX(null, fieldScript, returnType);
        this._accessInfo = AccessInfo.create(this, accessScript, returnType, this.ignoreTracker());
        this._converterArgs = converterArgs;
        this._converter = converter == null ? null : this.parseConverter(eval, converter);
    }

    @Override
    public Map<String, Object> getConverterArgs() {
        return this._converterArgs;
    }

    protected boolean ignoreTracker() {
        return false;
    }

    private ExpressionX parseConverter(BindEvaluatorX eval, String converterExpr) {
        BindContext ctx = BindContextUtil.newBindContext(this.getBinder(), this, false, null, this.getComponent(), null);
        return eval.parseExpressionX(ctx, converterExpr, Object.class);
    }

    @Override
    public Converter getConverter() {
        if (this._converter == null) {
            return null;
        }
        BindContext ctx = BindContextUtil.newBindContext(this.getBinder(), this, false, null, this.getComponent(), null);
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        Object obj = eval.getValue(ctx, this.getComponent(), this._converter);
        if (obj instanceof Converter) {
            return (Converter)obj;
        }
        if (obj instanceof String) {
            return this.getBinder().getConverter((String)obj);
        }
        throw new ClassCastException("result of expression '" + this._converter.getExpressionString() + "' is not a Converter, is " + obj);
    }

    @Override
    public String getFieldName() {
        String fieldScript = this.getPureExpressionString(this._fieldExpr);
        int j = fieldScript.lastIndexOf(".");
        return j < 0 ? fieldScript : fieldScript.substring(j);
    }

    @Override
    public String getCommandName() {
        return this._accessInfo.getCommandName();
    }

    @Override
    public String getPropertyString() {
        return this.getPureExpressionString(this._accessInfo.getProperty());
    }

    @Override
    public boolean isAfter() {
        return this._accessInfo.isAfter();
    }

    ExpressionX getProperty() {
        return this._accessInfo.getProperty();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ",component:" + this.getComponent() + ",field:" + this.getFieldName() + ",access:" + this.getProperty().getExpressionString() + ",command:" + this.getCommandName();
    }
}

