/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Property;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.Validator;
import org.zkoss.bind.impl.PropertyBindingImpl;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.ValueReference;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavePropertyBindingImpl
extends PropertyBindingImpl
implements SavePropertyBinding {
    private final ExpressionX _validator;
    private final Map<String, Object> _validatorArgs;
    private static final String $COMPVALUE$ = "$COMPVALUE$";
    private static final String $VALUEREF$ = "$VALUEREF$";

    public SavePropertyBindingImpl(Binder binder, Component comp, String attr, String saveScript, String converter, String validator, Map<String, Object> args, Map<String, Object> converterArgs, Map<String, Object> validatorArgs) {
        super(binder, comp, "self." + attr, saveScript, converter, args, converterArgs);
        BindEvaluatorX eval = binder.getEvaluatorX();
        this._validator = validator == null ? null : this.parseValidator(eval, validator);
        this._validatorArgs = validatorArgs;
    }

    @Override
    public Map<String, Object> getValidatorArgs() {
        return this._validatorArgs;
    }

    @Override
    protected boolean ignoreTracker() {
        return true;
    }

    private ExpressionX parseValidator(BindEvaluatorX eval, String validatorExpr) {
        return eval.parseExpressionX(null, validatorExpr, Object.class);
    }

    @Override
    public Validator getValidator() {
        if (this._validator == null) {
            return null;
        }
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        Object obj = eval.getValue(null, this.getComponent(), this._validator);
        if (obj instanceof Validator) {
            return (Validator)obj;
        }
        if (obj instanceof String) {
            return this.getBinder().getValidator((String)obj);
        }
        throw new ClassCastException("result of expression '" + this._validator.getExpressionString() + "' is not a Validator, is " + obj);
    }

    private Object getComponentValue(BindContext ctx) {
        if (!this.containsAttribute(ctx, $COMPVALUE$)) {
            Component comp = ctx.getComponent();
            BindEvaluatorX eval = this.getBinder().getEvaluatorX();
            Object value = eval.getValue(null, comp, this._fieldExpr);
            Converter conv = this.getConverter();
            if (conv != null) {
                value = conv.coerceToBean(value, comp, ctx);
                ValueReference ref = this.getValueReference(ctx);
                BindELContext.addNotifys(this.getConverterMethod(conv.getClass()), ref.getBase(), null, value, ctx);
            }
            this.setAttribute(ctx, $COMPVALUE$, value);
        }
        return this.getAttribute(ctx, $COMPVALUE$);
    }

    @Override
    public void save(BindContext ctx) {
        Object value = this.getComponentValue(ctx);
        Component comp = ctx.getComponent();
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        eval.setValue(ctx, comp, this._accessInfo.getProperty(), value);
    }

    private ValueReference getValueReference(BindContext ctx) {
        ValueReference ref = (ValueReference)this.getAttribute(ctx, $VALUEREF$);
        if (ref == null) {
            Component comp = ctx.getComponent();
            BindEvaluatorX eval = this.getBinder().getEvaluatorX();
            ref = eval.getValueReference(ctx, comp, this._accessInfo.getProperty());
            this.setAttribute(ctx, $VALUEREF$, ref);
        }
        return ref;
    }

    @Override
    public Property getValidate(BindContext ctx) {
        Object value = this.getComponentValue(ctx);
        try {
            ValueReference ref = this.getValueReference(ctx);
            return new PropertyImpl(ref.getBase(), (String)ref.getProperty(), value);
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
    }

    @Override
    public boolean hasValidator() {
        return this._validator != null;
    }

    @Override
    public void validate(ValidationContext vctx) {
        Validator validator = this.getValidator();
        if (validator == null) {
            throw new NullPointerException("cannot find validator for " + this);
        }
        validator.validate(vctx);
        this.collectNotifyChange(validator, vctx);
    }

    private void collectNotifyChange(Validator validator, ValidationContext vctx) {
        ValueReference ref = this.getValueReference(vctx.getBindContext());
        BindELContext.addNotifys(this.getValidatorMethod(validator.getClass()), ref.getBase(), null, null, vctx.getBindContext());
    }

    private Method getConverterMethod(Class<? extends Converter> cls) {
        try {
            return cls.getMethod("coerceToBean", Object.class, Component.class, BindContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Method getValidatorMethod(Class<? extends Validator> cls) {
        try {
            return cls.getMethod("validate", ValidationContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

