/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.tracker.impl;

import java.util.Collection;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AnnotateBinderHelper;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.util.UiLifeCycle;

public class BindUiLifeCycle
implements UiLifeCycle {
    public void afterComponentAttached(Component comp, Page page) {
        Binder binder;
        Binder selfBinder;
        if (comp.getDesktop() != null && (selfBinder = (Binder)comp.getAttribute("$BINDER$")) == null && (binder = (Binder)comp.getAttribute("$BINDER$", true)) != null) {
            new AnnotateBinderHelper(binder).initComponentBindings(comp);
            ((BinderImpl)binder).loadComponent(comp);
        }
    }

    public void afterComponentDetached(Component comp, Page prevpage) {
        this.removeBindings(comp);
    }

    public void afterComponentMoved(Component parent, Component child, Component prevparent) {
    }

    public void afterPageAttached(Page page, Desktop desktop) {
    }

    public void afterPageDetached(Page page, Desktop prevdesktop) {
        if (prevdesktop != null) {
            Collection comps = prevdesktop.getComponents();
            for (Component comp : comps) {
                this.removeBindings0(comp);
            }
        }
    }

    private void removeBindings(Component comp) {
        this.removeBindings0(comp);
        for (Component kid : comp.getChildren()) {
            if (kid == null) continue;
            this.removeBindings(kid);
        }
    }

    private void removeBindings0(Component comp) {
        Binder binder = (Binder)comp.getAttribute("$BINDER$");
        if (binder != null) {
            binder.removeBindings(comp);
        }
    }
}

