/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.tracker.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.zkoss.bind.impl.WeakIdentityMap;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.LoadBinding;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.bind.sys.tracker.Tracker;
import org.zkoss.bind.sys.tracker.TrackerNode;
import org.zkoss.bind.tracker.impl.TrackerNodeImpl;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.lang.Primitives;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerImpl
implements Tracker {
    private Map<Component, Map<Object, TrackerNode>> _compMap = new LinkedHashMap<Component, Map<Object, TrackerNode>>();
    private Map<Object, Set<TrackerNode>> _beanMap = new WeakIdentityMap<Object, Set<TrackerNode>>();
    private Map<Object, Object> _equalBeanMap = new WeakHashMap<Object, Object>();
    private Map<Object, Set<TrackerNode>> _nullMap = new HashMap<Object, Set<TrackerNode>>();

    @Override
    public void addTracking(Component comp, String[] series, String[] srcpath, Binding binding) {
        if (!(binding instanceof LoadBinding)) {
            return;
        }
        TrackerNodeImpl node = (TrackerNodeImpl)this.getOrCreateTrackerNode(comp, series);
        if (srcpath == null || srcpath.length == 0) {
            node.addBinding(binding);
        } else {
            TrackerNode srcnode = this.getOrCreateTrackerNode(comp, srcpath);
            node.addAssociate(srcnode);
        }
    }

    private TrackerNode getOrCreateTrackerNode(Component comp, String[] series) {
        Map<Object, TrackerNode> nodes = this._compMap.get(comp);
        if (nodes == null) {
            nodes = new HashMap<Object, TrackerNode>(4);
            this._compMap.put(comp, nodes);
        }
        TrackerNode parentNode = null;
        for (String script : series) {
            TrackerNode node = null;
            if (parentNode == null) {
                node = nodes.get(script);
                if (node == null) {
                    node = new TrackerNodeImpl(script);
                    nodes.put(script, node);
                }
            } else {
                node = parentNode.getDependent(script);
                if (node == null) {
                    node = new TrackerNodeImpl(script);
                }
                parentNode.addDependent(script, node);
            }
            parentNode = node;
        }
        return parentNode;
    }

    @Override
    public void removeTrackings(Component comp) {
        Map<Object, TrackerNode> nodesMap = this._compMap.remove(comp);
        if (nodesMap != null) {
            HashSet<TrackerNode> removed = new HashSet<TrackerNode>();
            Collection<TrackerNode> nodes = nodesMap.values();
            for (TrackerNode node : nodes) {
                removed.add(node);
                removed.addAll(node.getDependents());
            }
            this.removeNodes(this._beanMap.values(), removed);
            this.removeNodes(this._nullMap.values(), removed);
        }
    }

    private void getLoadBindingsPerProperty(Collection<TrackerNode> nodes, String prop, Set<LoadBinding> bindings, Set<Object> kidbases, Set<TrackerNode> visited) {
        if (".".equals(prop)) {
            for (TrackerNode node : nodes) {
                this.getLoadBindings0(node, bindings, kidbases, visited);
            }
        } else if ("*".equals(prop)) {
            for (TrackerNode node : nodes) {
                Set<TrackerNode> kids = node.getDirectDependents();
                this.getNodesLoadBindings(kids, bindings, kidbases, visited);
            }
        } else {
            for (TrackerNode node : nodes) {
                TrackerNode kid = node.getDependent(prop);
                if (kid == null) continue;
                this.getLoadBindings0(kid, bindings, kidbases, visited);
            }
        }
    }

    @Override
    public Set<LoadBinding> getLoadBindings(Object base, String prop) {
        HashSet<LoadBinding> bindings = new HashSet<LoadBinding>();
        HashSet<TrackerNode> visited = new HashSet<TrackerNode>();
        this.collectLoadBindings(base, prop, bindings, visited);
        return bindings;
    }

    private void collectLoadBindings(Object base, String prop, Set<LoadBinding> bindings, Set<TrackerNode> visited) {
        HashSet<Object> kidbases = new HashSet<Object>();
        if (base != null) {
            if ("*".equals(base)) {
                Collection<Map<Object, TrackerNode>> nodesMaps = this._compMap.values();
                if (nodesMaps != null) {
                    for (Map<Object, TrackerNode> nodesMap : nodesMaps) {
                        Collection<TrackerNode> nodes = nodesMap.values();
                        if (nodes == null) continue;
                        this.getLoadBindingsPerProperty(nodes, prop, bindings, kidbases, visited);
                    }
                }
            } else {
                Set<TrackerNode> nodes = this.getTrackerNodesByBean(base);
                if (nodes != null) {
                    this.getLoadBindingsPerProperty(nodes, prop, bindings, kidbases, visited);
                }
            }
        } else if ("*".equals(prop)) {
            for (Set<TrackerNode> set : this._nullMap.values()) {
                this.getNodesLoadBindings(set, bindings, kidbases, visited);
            }
        } else {
            Set<TrackerNode> basenodes = this._nullMap.get(prop);
            this.getNodesLoadBindings(basenodes, bindings, kidbases, visited);
        }
        for (Set<TrackerNode> set : kidbases) {
            this.collectLoadBindings(set, "*", bindings, visited);
        }
    }

    @Override
    public void tieValue(Object comp, Object base, Object script, Object propName, Object value) {
        if (base == null) {
            Map<Object, TrackerNode> bindingNodes = this._compMap.get(comp);
            if (bindingNodes != null) {
                TrackerNode node = bindingNodes.get(script);
                if (value != null) {
                    this.addBeanMap(node, value);
                } else {
                    this.removeAllBeanMap(node);
                    this.addNullMap(node);
                }
            }
        } else {
            Set<TrackerNode> baseNodes = this.getTrackerNodesByBean(base);
            if (baseNodes != null) {
                for (TrackerNode baseNode : baseNodes) {
                    TrackerNode node = baseNode.getDependent(script);
                    if (node == null) continue;
                    if (BindELContext.isBracket((String)script)) {
                        ((TrackerNodeImpl)baseNode).tieProperty(propName, script);
                    }
                    if (value != null) {
                        this.addBeanMap(node, value);
                        continue;
                    }
                    this.removeAllBeanMap(node);
                }
            }
        }
    }

    private void addBeanMap(TrackerNode node, Object value) {
        if (!value.equals(node.getBean())) {
            this.removeBeanMap(node);
            if (!this.isPrimitive(value)) {
                Set<TrackerNode> nodes = this.getTrackerNodesByBean(value);
                if (nodes == null) {
                    nodes = new HashSet<TrackerNode>();
                    this._beanMap.put(value, nodes);
                    this._equalBeanMap.put(value, value);
                }
                nodes.add(node);
                node.setBean(value);
            }
        }
        this.removeNullMap(node);
    }

    private void addNullMap(TrackerNode node) {
        Object propName = node.getFieldScript();
        Set<TrackerNode> nodes = this._nullMap.get(propName);
        if (nodes == null) {
            nodes = new HashSet<TrackerNode>();
            this._nullMap.put(propName, nodes);
        }
        nodes.add(node);
        this.removeBeanMap(node);
    }

    private void removeNullMap(TrackerNode node) {
        Object propName = node.getFieldScript();
        Set<TrackerNode> nodes = this._nullMap.get(propName);
        if (nodes != null) {
            nodes.remove(node);
            if (nodes.isEmpty()) {
                this._nullMap.remove(propName);
            }
        }
    }

    private void removeAllBeanMap(TrackerNode node) {
        this.removeBeanMap(node);
        Set<TrackerNode> kidnodes = node.getDependents();
        for (TrackerNode kid : kidnodes) {
            this.removeBeanMap(kid);
        }
    }

    private void removeBeanMap(TrackerNode node) {
        Object value = node.getBean();
        if (value != null) {
            node.setBean(null);
            Set<TrackerNode> nodes = this.getTrackerNodesByBean(value);
            if (nodes != null) {
                nodes.remove(node);
                if (nodes.isEmpty()) {
                    Object proxy = this._equalBeanMap.remove(value);
                    if (proxy != null) {
                        this._beanMap.remove(proxy);
                    } else {
                        this._beanMap.remove(value);
                    }
                }
            }
        }
    }

    private boolean isPrimitive(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> cls = value.getClass();
        return cls.isPrimitive() || Primitives.toPrimitive(cls) != null || value instanceof String;
    }

    private void getNodesLoadBindings(Set<TrackerNode> basenodes, Set<LoadBinding> bindings, Set<Object> kidbases, Set<TrackerNode> visited) {
        if (basenodes != null) {
            for (TrackerNode node : basenodes) {
                if (node == null) continue;
                this.getLoadBindings0(node, bindings, kidbases, visited);
            }
        }
    }

    private void getLoadBindings0(TrackerNode node, Set<LoadBinding> bindings, Set<Object> kidbases, Set<TrackerNode> visited) {
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        Set<Binding> nodebindings = node.getBindings();
        for (Binding binding : nodebindings) {
            if (!(binding instanceof LoadBinding)) continue;
            bindings.add((LoadBinding)binding);
        }
        for (TrackerNode associate : node.getAssociates()) {
            this.getLoadBindings0(associate, bindings, kidbases, visited);
        }
        Object kidbase = node.getBean();
        if (kidbase != null) {
            kidbases.add(kidbase);
        } else {
            Set<TrackerNode> nodes = node.getDependents();
            for (TrackerNode kid : nodes) {
                Set<Binding> kidbindings = kid.getBindings();
                for (Binding binding : kidbindings) {
                    if (!(binding instanceof LoadBinding)) continue;
                    bindings.add((LoadBinding)binding);
                }
            }
        }
    }

    private Set<TrackerNode> getNodes(Object base, String postfix) {
        String[] props;
        Set<TrackerNode> nodes = this.getTrackerNodesByBean(base);
        for (String prop : props = postfix.split("\\.")) {
            nodes = this.getDependents(nodes, prop);
        }
        return nodes;
    }

    private Set<TrackerNode> getDependents(Set<TrackerNode> parentnodes, String prop) {
        HashSet<TrackerNode> kidnodes = new HashSet<TrackerNode>();
        for (TrackerNode node : parentnodes) {
            TrackerNode kid = node.getDependent(prop);
            if (kid == null) continue;
            kidnodes.add(kid);
        }
        return kidnodes;
    }

    private void removeNodes(Collection<Set<TrackerNode>> nodesets, Collection<TrackerNode> removed) {
        Iterator<Set<TrackerNode>> it = nodesets.iterator();
        while (it.hasNext()) {
            Set<TrackerNode> nodeset = it.next();
            nodeset.removeAll(removed);
            if (!nodeset.isEmpty()) continue;
            it.remove();
        }
    }

    private Set<TrackerNode> getTrackerNodesByBean(Object bean) {
        Object proxy = this._equalBeanMap.get(bean);
        return proxy != null ? this._beanMap.get(proxy) : this._beanMap.get(bean);
    }

    public void dump() {
        this.dumpCompMap();
        this.dumpBeanMap();
        this.dumpNullMap();
    }

    private void dumpBeanMap() {
        System.out.println("******* _beanMap: *********");
        for (Object bean : this._beanMap.keySet()) {
            System.out.println("bean:" + bean + "------------");
            Set<TrackerNode> nodes = this._beanMap.get(bean);
            for (TrackerNode node : nodes) {
                this.dumpNodeTree(node, 4);
            }
        }
    }

    private void dumpCompMap() {
        System.out.println("******* _compMap: *********");
        for (Component comp : this._compMap.keySet()) {
            System.out.println("comp:" + comp + "------------");
            Map<Object, TrackerNode> nodes = this._compMap.get(comp);
            for (Map.Entry<Object, TrackerNode> entry : nodes.entrySet()) {
                System.out.println("----field:" + entry.getKey() + "");
                this.dumpNodeTree(entry.getValue(), 4);
            }
        }
    }

    private void dumpNullMap() {
        System.out.println("******* _nullMap: *********");
        for (Object field : this._nullMap.keySet()) {
            System.out.println("field:" + field + "------");
            Set<TrackerNode> nodes = this._beanMap.get(field);
            for (TrackerNode node : nodes) {
                this.dumpNodeTree(node, 4);
            }
        }
    }

    private void dumpNodeTree(TrackerNode node, int indent) {
        this.dumpNode(node, indent);
        for (TrackerNode kid : node.getDirectDependents()) {
            this.dumpNodeTree(kid, indent + 4);
        }
    }

    private void dumpNode(TrackerNode node, int spaces) {
        System.out.println(this.dumpSpace(spaces) + node.getFieldScript() + ":" + node.getBean());
        this.dumpBindings(node, spaces);
        this.dumpPropNameMapping(node, spaces);
        this.dumpAssociate(node, spaces);
    }

    private void dumpNode0(TrackerNode node, int spaces) {
        System.out.println(this.dumpSpace(spaces) + node.getFieldScript() + ":" + node.getBean());
        this.dumpBindings(node, spaces);
        this.dumpPropNameMapping(node, spaces);
    }

    private void dumpAssociate(TrackerNode node, int spaces) {
        if (node.getAssociates().isEmpty()) {
            return;
        }
        System.out.println(this.dumpSpace(spaces) + "[dependents:");
        for (TrackerNode dependent : node.getAssociates()) {
            this.dumpNode0(dependent, spaces + 4);
        }
        System.out.println(this.dumpSpace(spaces) + "]");
    }

    private void dumpBindings(TrackerNode node, int spaces) {
        if (node.getBindings().size() == 0) {
            return;
        }
        System.out.println(this.dumpSpace(spaces) + "[bindings:");
        for (Binding binding : node.getBindings()) {
            this.dumpBinding(binding, spaces + 4);
        }
        System.out.println(this.dumpSpace(spaces) + "]");
    }

    private void dumpBinding(Binding binding, int spaces) {
        if (binding instanceof PropertyBinding) {
            System.out.println(this.dumpSpace(spaces) + ((PropertyBinding)binding).getPropertyString() + ":" + binding);
        } else if (binding instanceof FormBinding) {
            System.out.println(this.dumpSpace(spaces) + ((FormBinding)binding).getPropertyString() + ":" + binding);
        }
    }

    private void dumpPropNameMapping(TrackerNode node, int spaces) {
        if (((TrackerNodeImpl)node).getPropNameMapping().size() == 0) {
            return;
        }
        System.out.println(this.dumpSpace(spaces) + "[propertys:");
        for (Map.Entry<Object, Object> entry : ((TrackerNodeImpl)node).getPropNameMapping().entrySet()) {
            this.dumpEntry(entry, spaces + 4);
        }
        System.out.println(this.dumpSpace(spaces) + "]");
    }

    private void dumpEntry(Map.Entry<Object, Object> entry, int spaces) {
        System.out.println(this.dumpSpace(spaces) + entry.getKey() + "=" + entry.getValue());
    }

    private String dumpSpace(int space) {
        char[] spaces = new char[space];
        Arrays.fill(spaces, ' ');
        return new String(spaces);
    }
}

